/*
 * Decompiled with CFR 0.152.
 */
package evaluation;

import help.HelpFrame;
import help.HelpTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mauda.AboutFrame;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.evaluation.EvalExercise;
import mauda.utils.FileLocation;
import mauda.utils.PreviewPanel;
import mauda.utils.Prop;
import mauda.utils.XMLFilter;

public class MenuToolBarListener
implements ActionListener {
    private EvalExercise exercise;
    private JFileChooser fileChooser;
    private PreviewPanel previewPanel = new PreviewPanel();

    public MenuToolBarListener(EvalExercise exercise) {
        this.exercise = exercise;
        this.fileChooser = new JFileChooser(FileLocation.completedPath);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.addChoosableFileFilter(new XMLFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAccessory(this.previewPanel);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                    File f = (File)e.getNewValue();
                    if (f == null) {
                        return;
                    }
                    String s = f.getPath();
                    String suffix = null;
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        suffix = s.substring(i + 1).toLowerCase();
                    }
                    if (suffix != null && suffix.equals("xml")) {
                        MenuToolBarListener.this.previewPanel.configure(f);
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s == "OpenFile") {
            MetaData.setDisplayMode(3);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.completedPath));
            this.openFile();
        } else if (s == "SaveFile") {
            MetaData.setDisplayMode(3);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.evaluatedPath));
            this.saveFile(this.exercise.getFilename());
        } else if (s == "SaveAsFile") {
            MetaData.setDisplayMode(3);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.evaluatedPath));
            this.saveAsFile();
        } else if (s == "Meta") {
            boolean mod = this.exercise.getMetaData().inputDialog();
            if (mod) {
                this.exercise.setModified(true);
            }
        } else if (s == "Exit") {
            if (this.dialogDiscardActiveExercise()) {
                System.exit(0);
            }
        } else if (s == "ShowAbout") {
            AboutFrame.createAndShowGUI();
        } else if (s == "ShowHelp") {
            HelpTree.setView(3);
            HelpFrame.createAndShowGUI();
        }
    }

    private void openFile() {
        File file;
        if (!this.dialogDiscardActiveExercise()) {
            return;
        }
        int state = this.fileChooser.showOpenDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()).isFile()) {
            this.openFile(file);
        }
    }

    private void openFile(File file) {
        Object opVector = null;
        this.exercise.setFilename(file.getAbsolutePath());
        HashMap hm = this.exercise.load(this.exercise.getFilename());
        if (hm == null) {
            return;
        }
        String editorState = this.exercise.getMetaData().getEditorState();
        String evaluatorState = this.exercise.getMetaData().getEvaluatorState();
        if (!editorState.equals("completed")) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load an uncompleted exercise!");
            return;
        }
        this.exercise.load(hm);
        this.exercise.loadConfig(hm);
        this.exercise.loadCompleted(hm);
        this.exercise.setDefaultFilename();
    }

    private void saveFile(String fname) {
        if (fname.equals(this.exercise.getDefaultFilename())) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "DialogChooseSaveAs"));
            return;
        }
        this.exercise.saveEvaluated(fname);
        this.exercise.setFilename(fname);
    }

    private void saveAsFile() {
        File file;
        int state = this.fileChooser.showSaveDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()) != null) {
            String fname = file.getAbsolutePath();
            if (file.exists() && !this.dialogExistsOverwrite(fname)) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "FileNotSaved"));
                return;
            }
            if (!fname.toLowerCase().endsWith(".xml")) {
                fname = String.valueOf(fname) + ".xml";
            }
            this.saveFile(fname);
        }
    }

    private boolean dialogExistsOverwrite(String filename) {
        String s = Prop.get(this, "DialogExistsOverwrite");
        s = s.replaceAll("FILENAME", filename);
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogExistsOverwriteTitle"), 1, 2);
        return result == 0;
    }

    private boolean dialogDiscardActiveExercise() {
        if (!this.exercise.isModified()) {
            return true;
        }
        String s = Prop.get(this, "DialogDiscardActiveExercise");
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogDiscardActiveExerciseTitle"), 1, 2);
        return result == 0;
    }
}

