/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import jedas.CompPanel;
import jedas.ControlPanel;
import jedas.Item;
import jedas.Jedas;
import jedas.Scheduler;
import mauda.Difficulties;
import mauda.ExerciseMode;
import mauda.ExerciseUpdateEvent;
import mauda.Failure;
import mauda.JedasPanel;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.OperationRecorder;
import mauda.SimpleExercise;
import mauda.evaluation.PlayerExercise;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.plugin.JedasMainCompObj;
import mauda.plugin.PlugInHandler;
import mauda.undoredo.AnimatedUndoRedo;
import mauda.undoredo.UndoRedo;
import mauda.utils.Prop;

public class Exercise
extends SimpleExercise {
    public JedasPanel jedasPanel = new JedasPanel();
    public static Scheduler scheduler;
    public static ControlPanel controlPanel;
    public static CompPanel compPanel;
    public static MouseListener interactive;
    public static boolean quickAnim;
    protected UndoRedo undoRedo;
    protected boolean actionsAllowed;
    public Vector opsToAnimate;
    private boolean modified;
    public static final int OPERATION = 0;
    public static final int SUBOPERATION = 1;
    public static final int BOTHOPERATION = 2;
    public static final int NOPOPUP = 3;
    protected int interactiveMode = 0;

    public Exercise(String type) {
        scheduler = this.jedasPanel.getScheduler();
        controlPanel = this.jedasPanel.getControlPanel();
        compPanel = this.jedasPanel.getCompPanel();
        this.actionsAllowed = true;
        quickAnim = false;
        this.undoRedo = null;
        interactive = null;
        this.setPlugInHandler(new PlugInHandler(this));
        this.switchTo(type);
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Vector addFullLoadedMessage(Vector v) {
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 17);
        v.add(eue);
        return v;
    }

    public void reset() {
        this.sendExerciseUpdateMessages(new ExerciseUpdateEvent(this, 10));
        String type = this.getMetaData().getType();
        int diff = this.getMetaData().getDifficulty();
        int currentMode = this.getMetaData().getMode();
        this.setMetaData(new MetaData());
        this.getMetaData().setType(type);
        this.getMetaData().setDifficulty(diff);
        this.setMode(currentMode);
        this.setModified(false);
        if (!(this instanceof PlayerExercise)) {
            this.jedasPanel.setNormalCompPanel(compPanel);
        }
    }

    public void switchTo(String plugInName) {
        if (plugInName == null) {
            return;
        }
        this.reset();
        this.init();
        if (interactive != null) {
            compPanel.getDrawPanel().removeAll();
            compPanel.getDrawPanel().removeMouseListener(interactive);
        }
        this.getPlugInHandler().load(plugInName);
        compPanel.getDrawPanel().addMouseListener(interactive);
        this.opsToAnimate = new Vector();
        this.setDifficulty(this.difficulty);
        this.setMode(0);
        this.setModified(false);
        if (this.getUndoRedo() != null) {
            this.removeExerciseUpdateListener(this.getUndoRedo());
        }
        AnimatedUndoRedo undoRedo = new AnimatedUndoRedo(this);
        this.addExerciseUpdateListenerFirst(undoRedo);
        this.setUndoRedo(undoRedo);
        this.jedasPanel.setExercise(this);
        compPanel.clear();
        compPanel.addItem((Item)((JedasMainCompObj)this.getDSObject()).getMainCompObj());
        undoRedo.initialSnapshot(null);
        Jedas.updateDisplay();
        this.sendExerciseUpdateMessages(new ExerciseUpdateEvent(this, 11));
    }

    public void setMode(int mode) {
        super.setMode(mode);
        this.jedasPanel.setModeLabel("Mode: " + ExerciseMode.getString(mode));
        this.setModified(true);
    }

    public static void setQuickAnim(boolean b) {
        quickAnim = b;
        scheduler.setTransitionSkipping(b);
    }

    public void setInteractiveMode(int mode) {
        this.interactiveMode = mode;
    }

    public int getInteractiveMode() {
        return this.interactiveMode;
    }

    public void setActionsAllowed(boolean b) {
        this.actionsAllowed = b;
    }

    public boolean actionsAllowed() {
        return this.actionsAllowed;
    }

    protected void setUndoRedo(UndoRedo ur) {
        this.undoRedo = ur;
    }

    public UndoRedo getUndoRedo() {
        return this.undoRedo;
    }

    public void setDifficulty(int difficulty) {
        super.setDifficulty(difficulty);
        this.jedasPanel.setDifficultyLabel("Difficulty: " + Difficulties.getGUIString(this.getDifficulty()));
        this.setModified(true);
    }

    protected void addToAnimationQueue(SimpleOperation op) {
        Vector vector = this.opsToAnimate;
        synchronized (vector) {
            this.opsToAnimate.add(op);
        }
    }

    protected void addToAnimationQueue(Vector v) {
        Vector vector = this.opsToAnimate;
        synchronized (vector) {
            this.opsToAnimate.addAll(v);
        }
    }

    public void animate() {
        if (!scheduler.isActive()) {
            controlPanel.enablePlay();
            controlPanel.play();
        }
    }

    public void back() {
        if (!this.undoRedo.canBack()) {
            return;
        }
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        v.add(new ExerciseUpdateEvent(this, 7));
        this.commit(v);
    }

    public void forward() {
        if (!this.undoRedo.canForward()) {
            return;
        }
        if (this.undoRedo instanceof AnimatedUndoRedo) {
            Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
            v.add(new ExerciseUpdateEvent(this, 9));
            this.commit(v);
            return;
        }
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        v.add(new ExerciseUpdateEvent(this, 8));
        this.commit(v);
    }

    public void undo() {
        if (!this.undoRedo.canUndo() || !this.getOperationRecorder().canUndo()) {
            return;
        }
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        v.add(new ExerciseUpdateEvent(this, 18));
        int delta = this.undoRedo.getUndoJumpDelta();
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 12);
        eue.setValue(delta);
        v.add(eue);
        this.commit(v);
    }

    public void redo() {
        if (!this.undoRedo.canRedo()) {
            return;
        }
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        v.add(new ExerciseUpdateEvent(this, 19));
        int delta = this.undoRedo.getRedoJumpDelta();
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 12);
        eue.setValue(delta);
        v.add(eue);
        this.commit(v);
    }

    public void jumpToBeginning() {
        OperationRecorder or = this.getOperationRecorder();
        if (or.getCurrentOperation() == null) {
            return;
        }
        int delta = or.getOffset(0, -1) - or.getCurrentOffset();
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        if (--delta != 0) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 12);
            eue.setValue(delta);
            v.add(eue);
            this.commit(v);
        }
    }

    public void jumpToEnd() {
        OperationRecorder or = this.getOperationRecorder();
        if (or.getCurrentOffset() + 1 == or.getOperationCount()) {
            return;
        }
        int delta = or.getOffset(0, -1) - or.getCurrentOffset() + or.getOperationCount();
        --delta;
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        if (--delta != 0) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 12);
            eue.setValue(delta);
            v.add(eue);
            this.commit(v);
        }
    }

    public void commit(SimpleOperation so) {
        this.addToAnimationQueue(so);
        this.animate();
    }

    public void commitInteractive(SimpleOperation so) {
        int mode;
        if (so instanceof Operation && (mode = this.getInteractiveMode()) == 2) {
            ((Operation)so).setExecution(false);
        }
        this.commit(so);
    }

    public void commit(Vector v) {
        this.addToAnimationQueue(v);
        this.animate();
    }

    public void commit(OperationQueue oq) {
        this.commit(oq.toVector());
    }

    public void stopPlaying() {
        Vector vector = this.opsToAnimate;
        synchronized (vector) {
            this.opsToAnimate.removeAllElements();
        }
    }

    public void commit(String operation, String alert) {
        JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), String.valueOf(operation) + ": " + alert);
    }

    public HashMap load(String filename) {
        HashMap hm = super.load(filename);
        return hm;
    }

    public HashMap save(String filename) {
        HashMap hm = super.save(filename);
        this.setModified(false);
        return hm;
    }

    public String isReadyToSave() {
        boolean ok = this.getOperationRecorder().isValidTodoPosition();
        if (!ok) {
            return Prop.get(this, "ToDoPositionNotAllowed");
        }
        OperationQueue todoOps = this.getOperationRecorder().getAllTodoOperationQueue();
        if (todoOps.length() == 0) {
            return Prop.get(this, "NoToDoOperations");
        }
        if (this.getMode() == 1) {
            Failure f = this.getOperationRecorder().getUnlimitedFailure(0);
            if (f == null) {
                return Prop.get(this, "FaultModeNoFailure");
            }
            if (f.getDescription() == 1 && this.getOperationRecorder().getOperation(f.getOpNr() + 1) == null) {
                return Prop.get(this, "MissingSubOpNoNextOpFailure");
            }
            return "OK";
        }
        Failure f = this.getOperationRecorder().getUnlimitedFailure(0);
        if (f != null) {
            return Prop.get(this, "NormalModeWithFailure");
        }
        return "OK";
    }
}

