/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import mauda.SimpleExercise;
import mauda.operation.SimpleOperation;

public class ExerciseUpdateEvent {
    public static final int SPECIAL = -1;
    public static final int OPERATION_EXECUTED = 0;
    public static final int FILENAME_CHANGED = 1;
    public static final int CLEAR_PRECEDING = 2;
    public static final int CLEAR_FOLLOWING = 3;
    public static final int FINISHED_LOADING = 4;
    public static final int DSOBJECT_HIDE = 5;
    public static final int DSOBJECT_SHOW = 6;
    public static final int BACK = 7;
    public static final int FORWARD = 8;
    public static final int FORWARD_ANIMATED = 9;
    public static final int RESET = 10;
    public static final int PLUGIN_CHANGED = 11;
    public static final int JUMP = 12;
    public static final int END_OF_EXECUTION = 13;
    public static final int START_OF_EXECUTION = 14;
    public static final int SUSPEND_EXECUTION = 15;
    public static final int RESUME_EXECUTION = 16;
    public static final int FULL_LOADED = 17;
    public static final int UNDO = 18;
    public static final int REDO = 19;
    private int id;
    private String message;
    private int value;
    private SimpleExercise exercise;
    private SimpleOperation so;

    public ExerciseUpdateEvent(SimpleExercise ex, int id) {
        this.exercise = ex;
        this.id = id;
        this.message = null;
        this.so = null;
    }

    public int getID() {
        return this.id;
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public String getMessage() {
        return this.message;
    }

    public void setOperation(SimpleOperation so) {
        this.so = so;
    }

    public SimpleOperation getOperation() {
        return this.so;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public SimpleExercise getExercise() {
        return this.exercise;
    }

    public boolean dsChanged() {
        switch (this.id) {
            case 0: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = "ID = ";
        switch (this.id) {
            case 0: {
                s = "OPERATION_EXECUTED";
                break;
            }
            case 1: {
                s = "FILENAME_CHANGED";
                break;
            }
            case 2: {
                s = "CLEAR_PRECEDING";
                break;
            }
            case 3: {
                s = "CLEAR_FOLLOWING";
                break;
            }
            case 4: {
                s = "FINISHED_LOADING";
                break;
            }
            case 5: {
                s = "DSOBJECT_HIDE";
                break;
            }
            case 6: {
                s = "DSOBJECT_SHOW";
                break;
            }
            case 7: {
                s = "BACK";
                break;
            }
            case 8: {
                s = "FORWARD";
                break;
            }
            case 9: {
                s = "FORWARD_ANIMATED";
                break;
            }
            case 18: {
                s = "UNDO";
                break;
            }
            case 19: {
                s = "REDO";
                break;
            }
            case 10: {
                s = "RESET";
                break;
            }
            case 11: {
                s = "PLUGIN_CHANGED";
                break;
            }
            case 12: {
                s = "JUMP: delta = " + this.value;
                break;
            }
            case -1: {
                s = "SPECIAL -> Message=" + this.message;
                break;
            }
            case 14: {
                s = "START_OF_EXECUTION";
                break;
            }
            case 13: {
                s = "END_OF_EXECUTION";
                break;
            }
            case 15: {
                s = "SUSPEND_EXECUTION";
                break;
            }
            case 16: {
                s = "RESUME_EXECUTION";
            }
        }
        return s;
    }
}

