/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.util.Enumeration;
import java.util.Vector;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;

public class Failure {
    public static final int NO_DESCRIPTION = -1;
    public static final int DIFFERENT = 0;
    public static final int MISSING_SUBOP = 1;
    public static final int ADDITIONAL_FALSE_SUBOP = 2;
    private Vector differentOps = new Vector();
    private Operation superOp = null;
    private SimpleOperation correctOp = null;
    private SimpleOperation currentOp = null;
    private int recorderOffset = -1;
    private int recorderMaxOffset;
    private int opNr = -1;
    private int subOpNr = -1;
    private int description = -1;

    public void setSuperOp(Operation op) {
        this.superOp = op;
    }

    public void setCorrectOp(SimpleOperation so) {
        this.correctOp = so;
    }

    public void setCurrentOp(SimpleOperation so) {
        this.currentOp = so;
    }

    public void setOffset(int p) {
        this.recorderOffset = p;
    }

    public int getOffset() {
        return this.recorderOffset;
    }

    public void setMaxOffset(int p) {
        this.recorderMaxOffset = p;
    }

    public int getMaxOffset() {
        return this.recorderMaxOffset;
    }

    public void setOpNr(int n) {
        this.opNr = n;
    }

    public int getOpNr() {
        return this.opNr;
    }

    public void setSubOpNr(int n) {
        this.subOpNr = n;
    }

    public int getSubOpNr() {
        return this.subOpNr;
    }

    public void setDescription(int d) {
        this.description = d;
    }

    public int getDescription() {
        return this.description;
    }

    public void addDifferentOperation(SimpleOperation so) {
        this.differentOps.add(so);
    }

    public String getDescriptionString() {
        String diffOpStr = "";
        if (this.differentOps != null && this.differentOps.size() > 0) {
            int counter = this.subOpNr + 1;
            Enumeration en = this.differentOps.elements();
            while (en.hasMoreElements()) {
                diffOpStr = String.valueOf(diffOpStr) + "    -> " + (counter < 10 ? " " : "") + counter + ". " + en.nextElement() + "\n";
                ++counter;
            }
        }
        String msg = "Failure-Description:\n\n";
        msg = String.valueOf(msg) + "Recorder-Position: " + this.recorderOffset + "    (internal)\n";
        msg = String.valueOf(msg) + "Recorder-Max-Pos.: " + this.recorderMaxOffset + "    (internal)\n";
        msg = String.valueOf(msg) + "Operation-Nr.:     " + (this.opNr + 1) + "    [" + this.superOp + "]\n";
        msg = String.valueOf(msg) + "SubOperation-Nr.:  " + (this.subOpNr + 1) + "\n";
        msg = String.valueOf(msg) + "Type:              ";
        if (this.description == 0) {
            msg = String.valueOf(msg) + "DIFFERENT SUBOPERATIONS\n";
            msg = String.valueOf(msg) + "Description:\n    The following SubOperations differ from each other:\n    -> Correct: " + this.correctOp + "\n" + "    -> Present: " + this.currentOp + "\n";
        } else if (this.description == 1) {
            msg = String.valueOf(msg) + "MISSING SUBOPERATION(S)\n";
            msg = String.valueOf(msg) + "Description:\n    Correct but missing following SubOperation(s):\n" + diffOpStr;
        } else if (this.description == 2) {
            msg = String.valueOf(msg) + "ADDTIONAL FALSE SUBOPERATIONS\n";
            msg = String.valueOf(msg) + "Description:\n    Correct but following additional false SubOperations:\n" + diffOpStr;
        }
        return msg;
    }

    public boolean containsOffset(int p) {
        return p >= this.recorderOffset && p <= this.recorderMaxOffset;
    }
}

