/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jedas.CompPanel;
import jedas.ControlPanel;
import jedas.Jedas;
import jedas.JedasApplication;
import jedas.Scheduler;
import jedas.utils.ZoomSetPanel;
import mauda.AutomaticZoomThread;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.JedasPanelProgress;
import mauda.OperationRecorder;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.plugin.JedasMainCompObj;

public class JedasPanel
extends JPanel
implements JedasApplication,
ActionListener {
    protected static Scheduler scheduler;
    protected static ControlPanel controlPanel;
    protected static CompPanel compPanel;
    protected static ControlPanel memControlPanel;
    protected static ZoomSetPanel zoomSetPanel;
    protected static JPanel messagePanel;
    protected Exercise exercise;
    protected JLabel typeLabel;
    protected JLabel difficultyLabel;
    protected JLabel modeLabel;
    protected JCheckBox quickButton;
    protected JCheckBox adjustZoomButton;
    protected JLabel percentLabel;
    protected static final String percentLabelDefaultText = " ";
    protected boolean nextNoProgressBar;

    public JedasPanel() {
        scheduler = new Scheduler();
        memControlPanel = controlPanel = new ControlPanel((JedasApplication)this, scheduler);
        compPanel = new CompPanel();
        this.setLayout(new BorderLayout());
        JPanel aboveJedas = new JPanel();
        aboveJedas.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        this.typeLabel = new JLabel("?");
        this.typeLabel.setFont(new Font("SansSerif", 0, 20));
        leftPanel.add((Component)this.typeLabel, "Center");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(0, 0, 0));
        Font font = new Font("SansSerif", 0, 10);
        this.modeLabel = new JLabel("Mode: ");
        this.modeLabel.setFont(font);
        labelPanel.add(this.modeLabel);
        JLabel sepLabel = new JLabel("  /  ");
        sepLabel.setFont(font);
        labelPanel.add(sepLabel);
        this.difficultyLabel = new JLabel("Difficulty: ");
        this.difficultyLabel.setFont(font);
        labelPanel.add(this.difficultyLabel);
        leftPanel.add((Component)labelPanel, "South");
        aboveJedas.add((Component)leftPanel, "West");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        this.quickButton = new JCheckBox("Quick-Anim");
        this.quickButton.setSelected(false);
        this.quickButton.addActionListener(this);
        rightPanel.add((Component)this.quickButton, "Center");
        this.adjustZoomButton = new JCheckBox("Adjust-Zoom");
        this.adjustZoomButton.setSelected(false);
        this.adjustZoomButton.addActionListener(this);
        rightPanel.add((Component)this.adjustZoomButton, "West");
        this.percentLabel = new JLabel(percentLabelDefaultText);
        this.percentLabel.setFont(font);
        this.percentLabel.setHorizontalAlignment(4);
        rightPanel.add((Component)this.percentLabel, "South");
        aboveJedas.add((Component)rightPanel, "East");
        this.add((Component)aboveJedas, "North");
        zoomSetPanel = new ZoomSetPanel(compPanel);
        this.add((Component)zoomSetPanel, "Center");
        this.add((Component)controlPanel, "South");
        messagePanel = null;
    }

    public void nextNoProgressBar() {
        this.nextNoProgressBar = true;
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    public ControlPanel getControlPanel() {
        return controlPanel;
    }

    public CompPanel getCompPanel() {
        return compPanel;
    }

    public void setNormalCompPanel(CompPanel co) {
        if (controlPanel == memControlPanel) {
            return;
        }
        if (zoomSetPanel != null) {
            this.remove((Component)zoomSetPanel);
        } else if (compPanel != null) {
            this.remove(compPanel.getDrawPanel());
        }
        if (controlPanel != null) {
            this.remove((Component)controlPanel);
        }
        if (messagePanel != null) {
            this.remove(messagePanel);
        }
        zoomSetPanel = new ZoomSetPanel(co);
        compPanel = co;
        controlPanel = memControlPanel;
        messagePanel = null;
        this.add((Component)zoomSetPanel, "Center");
        this.add((Component)controlPanel, "South");
        this.adjustZoomButton.setEnabled(true);
        this.quickButton.setEnabled(false);
        this.invalidate();
        this.revalidate();
    }

    public void setPlayerCompPanel(CompPanel co) {
        if (zoomSetPanel != null) {
            this.remove((Component)zoomSetPanel);
        } else if (compPanel != null) {
            this.remove(compPanel.getDrawPanel());
        }
        if (controlPanel != null) {
            this.remove((Component)controlPanel);
        }
        if (messagePanel != null) {
            this.remove(messagePanel);
        }
        zoomSetPanel = null;
        compPanel = co;
        controlPanel = null;
        messagePanel = null;
        this.add((Component)compPanel.getDrawPanel(), "Center");
        this.adjustZoomButton.setEnabled(false);
        this.quickButton.setEnabled(false);
        this.invalidate();
        this.revalidate();
    }

    public void setMessage(String msg) {
        if (zoomSetPanel != null) {
            this.remove((Component)zoomSetPanel);
        } else if (compPanel != null) {
            this.remove(compPanel.getDrawPanel());
        }
        if (controlPanel != null) {
            this.remove((Component)controlPanel);
        }
        if (messagePanel != null) {
            this.remove(messagePanel);
        }
        zoomSetPanel = null;
        compPanel = null;
        controlPanel = null;
        messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        JLabel label = new JLabel(msg);
        messagePanel.setBackground(new Color(255, 255, 255));
        label.setFont(new Font("SansSerif", 2, 20));
        label.setHorizontalAlignment(0);
        messagePanel.add((Component)label, "Center");
        this.add((Component)messagePanel, "Center");
        this.adjustZoomButton.setEnabled(false);
        this.quickButton.setEnabled(false);
        this.invalidate();
        this.revalidate();
    }

    public void setExercise(Exercise ex) {
        this.exercise = ex;
        this.typeLabel.setText(ex.getMetaData().getType());
    }

    public void setDifficultyLabel(String s) {
        this.difficultyLabel.setText(s);
    }

    public void setModeLabel(String s) {
        this.modeLabel.setText(s);
    }

    public void setPercentLabel(String s) {
        if (s == null) {
            s = percentLabelDefaultText;
        }
        this.percentLabel.setText(s);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quickButton) {
            Exercise.setQuickAnim(this.quickButton.isSelected());
        } else if (e.getSource() == this.adjustZoomButton) {
            boolean enabled = this.adjustZoomButton.isSelected();
            AutomaticZoomThread.setEnabled(enabled);
            if (enabled) {
                AutomaticZoomThread.forceZoom(this.exercise);
                Jedas.updateDisplay();
            }
        }
    }

    public void initJedas() {
        Jedas.updateDisplay();
    }

    public void run() {
        this.exercise.setActionsAllowed(false);
        int opsToAnimateSize = this.exercise.opsToAnimate.size();
        int opsToAnimateCounter = 0;
        if (opsToAnimateSize > 4 && !this.nextNoProgressBar) {
            JedasPanelProgress.maxValue = opsToAnimateSize;
            new JedasPanelProgress();
        }
        this.nextNoProgressBar = false;
        AutomaticZoomThread automaticZoomThread = new AutomaticZoomThread();
        automaticZoomThread.startZooming(this.exercise);
        while (this.exercise.opsToAnimate.size() > 0) {
            Object obj = this.exercise.opsToAnimate.firstElement();
            Vector vector = this.exercise.opsToAnimate;
            synchronized (vector) {
                this.exercise.opsToAnimate.removeElementAt(0);
            }
            JedasPanelProgress.actValue = ++opsToAnimateCounter;
            if (obj instanceof SimpleOperation) {
                int copnr;
                OperationRecorder or;
                Operation op;
                if (obj instanceof SubOperation && ((op = (or = this.exercise.getOperationRecorder()).getOperation(copnr = or.getCurrentOperationNr())) == null || op.isExecuted())) {
                    this.exercise.commit("Error", "Execution of SubOperation on none template!");
                    continue;
                }
                ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 14);
                this.exercise.sendExerciseUpdateMessages(eue);
                SimpleOperation op2 = (SimpleOperation)obj;
                op2.execute(this.exercise.getDSObject());
                this.exercise.operationExecuted(op2);
                if (opsToAnimateSize > 1) {
                    int percent = (int)((double)opsToAnimateCounter / (double)opsToAnimateSize * 100.0);
                    this.percentLabel.setText("Progress: " + percent + "% ");
                }
                AutomaticZoomThread.forceZoom(this.exercise);
                continue;
            }
            if (!(obj instanceof ExerciseUpdateEvent)) continue;
            ExerciseUpdateEvent event = (ExerciseUpdateEvent)obj;
            this.exercise.sendExerciseUpdateMessages(event);
            if (event.getID() == 5) {
                this.quickButton.setSelected(true);
                this.quickButton.setEnabled(false);
                Exercise.setQuickAnim(true);
                ((JedasMainCompObj)this.exercise.getDSObject()).getMainCompObj().hide();
                continue;
            }
            if (event.getID() != 6) continue;
            this.quickButton.setSelected(false);
            this.quickButton.setEnabled(true);
            Exercise.setQuickAnim(false);
            ((JedasMainCompObj)this.exercise.getDSObject()).getMainCompObj().show();
            Jedas.updateDisplay();
        }
        scheduler.start();
        JedasPanelProgress.close();
        this.percentLabel.setText(percentLabelDefaultText);
        this.exercise.setActionsAllowed(true);
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 13);
        this.exercise.sendExerciseUpdateMessages(eue);
        automaticZoomThread.stopZooming();
    }

    public static String[] getAnimationInformation() {
        String[] infos = new String[]{"Author: Markus Krebs", "Date: 11 Nov 2003"};
        return infos;
    }
}

