/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.util.Vector;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.operation.SimpleOperation;
import mauda.undoredo.UndoRedoInfo;

public class ModifiedDetector
implements ExerciseUpdateListener {
    private Exercise exercise;
    private UndoRedoInfo undoRedoInfo;
    private Vector operations;
    private int position = -1;
    private int minPosition = 0;

    public ModifiedDetector(Exercise ex) {
        this.exercise = ex;
        this.undoRedoInfo = new UndoRedoInfo();
        this.operations = new Vector();
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 7) {
            this.back();
        } else if (e.getID() == 8) {
            this.forward();
        } else if (e.getID() == 18) {
            this.undo();
        } else if (e.getID() == 19) {
            this.redo();
        } else if (e.getID() == 0) {
            this.add(e.getOperation());
        } else if (e.getID() == 10) {
            this.clear();
        } else if (e.getID() == 2) {
            this.clearPreceding();
        } else if (e.getID() == 3) {
            this.clearFollowing();
        } else if (e.getID() == 12) {
            this.position += e.getValue();
        } else if (e.getID() == 17) {
            this.exercise.setModified(false);
        }
    }

    private void add(Object obj) {
        SimpleOperation undoRedoOp;
        Object o;
        SimpleOperation op = (SimpleOperation)obj;
        if (op != null && this.position < this.operations.size() - 1 && (o = this.operations.elementAt(this.position + 1)) != null && o instanceof SimpleOperation && (undoRedoOp = (SimpleOperation)o).equals(op)) {
            ++this.position;
            return;
        }
        ++this.position;
        o = null;
        if (op != null) {
            o = op.clone();
        }
        this.undoRedoInfo.storeChange(this.position, this.operations, o);
        this.exercise.setModified(true);
    }

    private void clear() {
        if (this.operations.size() > 1) {
            this.exercise.setModified(true);
        }
        this.minPosition = 0;
        this.position = 0;
        this.operations.removeAllElements();
        this.operations.add(null);
    }

    private void clearPreceding() {
        if (this.operations.size() > 1) {
            this.exercise.setModified(true);
        }
        this.position = 0;
        Object o = this.operations.lastElement();
        this.operations.removeAllElements();
        this.operations.add(null);
        this.minPosition = 0;
        Vector<Object> newv = new Vector<Object>();
        newv.add(null);
        this.undoRedoInfo.clear(newv);
    }

    private void clearFollowing() {
        if (this.operations.size() > this.position + 1) {
            this.exercise.setModified(true);
        }
        this.undoRedoInfo.clearFollowing(this.position + 1, this.operations);
    }

    private void back() {
        if (this.position <= this.minPosition) {
            return;
        }
        --this.position;
    }

    private void forward() {
        if (this.position >= this.operations.size() - 1) {
            return;
        }
        ++this.position;
    }

    protected void undo() {
        this.undoRedoInfo.undo(this.operations);
    }

    protected void redo() {
        this.undoRedoInfo.redo(this.operations);
    }
}

