/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.util.Enumeration;
import java.util.Vector;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.Failure;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.undoredo.UndoRedoInfo;

public class OperationRecorder
implements ExerciseUpdateListener {
    private UndoRedoInfo undoRedoInfo = new UndoRedoInfo();
    private Vector operations = new Vector();
    private int position = -1;
    private int todoPosition = 0x7FFFFFFE;
    private int minPosition = 0;

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 7) {
            this.back();
        } else if (e.getID() == 8) {
            this.forward();
        } else if (e.getID() == 18) {
            this.undo();
        } else if (e.getID() == 19) {
            this.redo();
        } else if (e.getID() == 0) {
            this.add(e.getOperation());
            SimpleOperation so = e.getOperation();
            if (so instanceof SubOperation && this.todoPosition == this.position - 1) {
                ++this.todoPosition;
            }
        } else if (e.getID() == 10) {
            this.clear();
        } else if (e.getID() == 2) {
            this.clearPreceding();
        } else if (e.getID() == 3) {
            this.clearFollowing();
        } else if (e.getID() == 12) {
            this.position += e.getValue();
        } else if (e.getID() == -1 && e.getMessage().equals("GO_IN_TODO-MODE")) {
            this.goInTodoMode();
        }
    }

    public void add(Object obj) {
        SimpleOperation undoRedoOp;
        Object o;
        SimpleOperation op = (SimpleOperation)obj;
        if (op != null && this.position < this.operations.size() - 1 && (o = this.operations.elementAt(this.position + 1)) != null && o instanceof SimpleOperation && (undoRedoOp = (SimpleOperation)o).equals(op)) {
            ++this.position;
            return;
        }
        o = null;
        if (op != null) {
            o = op.clone();
        }
        ++this.position;
        this.undoRedoInfo.storeChange(this.position, this.operations, o);
    }

    private void back() {
        if (this.position <= this.minPosition) {
            return;
        }
        --this.position;
    }

    private void forward() {
        if (this.position >= this.operations.size() - 1) {
            return;
        }
        ++this.position;
    }

    private void undo() {
        this.undoRedoInfo.undo(this.operations);
    }

    private void redo() {
        this.undoRedoInfo.redo(this.operations);
    }

    public void clear() {
        this.minPosition = 0;
        this.position = 0;
        this.operations.removeAllElements();
        this.operations.add(null);
        Vector<Object> newv = new Vector<Object>();
        newv.add(null);
        this.undoRedoInfo.clear(newv);
    }

    private void clearPreceding() {
        Vector<Object> newv = new Vector<Object>();
        newv.add(null);
        this.undoRedoInfo.clear(newv);
        this.todoPosition -= this.operations.size() - 1;
        this.position = 0;
        Object o = this.operations.lastElement();
        this.operations.removeAllElements();
        this.operations.add(null);
        this.minPosition = 0;
    }

    private void clearFollowing() {
        this.undoRedoInfo.clearFollowing(this.position + 1, this.operations);
    }

    public Object getCurrentOperation() {
        return this.operations.elementAt(this.position);
    }

    public int getCurrentOffset() {
        return this.position;
    }

    public Object getNextOperation() {
        if (this.operations.size() <= this.position + 1) {
            return null;
        }
        return this.operations.elementAt(this.position + 1);
    }

    public void goInTodoMode() {
        this.todoPosition = this.position;
    }

    public int getPossibleTodoPosition(int newTodoPosition) {
        if (newTodoPosition >= this.operations.size()) {
            return this.operations.size();
        }
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < this.operations.size()) {
            SimpleOperation so = (SimpleOperation)this.operations.elementAt(i);
            if (so instanceof Operation) {
                Operation op = (Operation)so;
                if (op.isExecuted()) {
                    v.add(new Integer(i));
                } else {
                    ++i;
                    while (i < this.operations.size()) {
                        so = (SimpleOperation)this.operations.elementAt(i);
                        if (so instanceof Operation) {
                            --i;
                            break;
                        }
                        ++i;
                    }
                    v.add(new Integer(i));
                }
            }
            ++i;
        }
        v.add(new Integer(this.operations.size()));
        i = 0;
        while (i < v.size()) {
            int p = (Integer)v.elementAt(i);
            if (newTodoPosition >= this.todoPosition) {
                if (p >= newTodoPosition) {
                    return p;
                }
            } else if (newTodoPosition < this.todoPosition && p > newTodoPosition) {
                if (i == 0) {
                    return 0;
                }
                int oldp = (Integer)v.elementAt(i - 1);
                return oldp;
            }
            ++i;
        }
        return 0;
    }

    public void decreaseTodoPosition() {
        this.todoPosition = this.getPossibleTodoPosition(this.todoPosition - 1);
    }

    public void increaseTodoPosition() {
        this.todoPosition = this.getPossibleTodoPosition(this.todoPosition + 1);
    }

    public void setTodoPosition(int p) {
        this.todoPosition = p;
    }

    public int getTodoPosition() {
        return this.todoPosition;
    }

    public boolean isValidTodoPosition() {
        if (this.position <= this.todoPosition) {
            return true;
        }
        SimpleOperation firstTodoOp = (SimpleOperation)this.operations.elementAt(this.todoPosition + 1);
        return !(firstTodoOp instanceof SubOperation);
    }

    public Failure getFirstFailure() {
        return this.getFailure(0, this.position);
    }

    public Failure getUnlimitedFailure(int offset) {
        return this.getFailure(offset, this.operations.size() - 1);
    }

    public Failure getLimitedFailure(int offset) {
        return this.getFailure(offset, this.position);
    }

    private Failure getFailure(int offset, int limit) {
        if (offset < 0) {
            return null;
        }
        Vector vec = new Vector();
        int size = this.operations.size();
        int opCounter = 0;
        if (offset > 0) {
            int counter = 0;
            Enumeration en = this.operations.elements();
            while (en.hasMoreElements() && counter < offset) {
                if (en.nextElement() instanceof Operation) {
                    ++opCounter;
                }
                ++counter;
            }
        }
        int i = offset;
        while (i <= limit) {
            SimpleOperation so = (SimpleOperation)this.operations.elementAt(i);
            if (so instanceof Operation) {
                Operation op = (Operation)so;
                if (!op.isExecuted()) {
                    if (i < this.todoPosition) {
                        return null;
                    }
                    SubOperationQueue soqCorrect = op.getSubOperationQueue();
                    SubOperationQueue soq = new SubOperationQueue();
                    int marker = ++i;
                    while (i <= limit && this.operations.elementAt(i) instanceof SubOperation) {
                        soq.add((SubOperation)this.operations.elementAt(i));
                        ++i;
                    }
                    --i;
                    int m = Math.min(soqCorrect.length(), soq.length());
                    int j = 0;
                    while (j < m) {
                        SubOperation so2;
                        SubOperation so1 = soqCorrect.get(j);
                        if (!so1.equals(so2 = soq.get(j))) {
                            Failure f = new Failure();
                            f.setSuperOp(op);
                            f.setOffset(marker + j);
                            f.setMaxOffset(marker + soq.length() - 1);
                            f.setCorrectOp(so1);
                            f.setCurrentOp(so2);
                            f.setOpNr(opCounter);
                            f.setSubOpNr(j);
                            f.setDescription(0);
                            return f;
                        }
                        ++j;
                    }
                    if (soqCorrect.length() > soq.length()) {
                        Failure f = new Failure();
                        f.setSuperOp(op);
                        f.setOffset(marker + soq.length());
                        f.setMaxOffset(marker + soq.length());
                        f.setOpNr(opCounter);
                        f.setSubOpNr(m);
                        f.setDescription(1);
                        int j2 = soq.length();
                        while (j2 < soqCorrect.length()) {
                            f.addDifferentOperation(soqCorrect.get(j2));
                            ++j2;
                        }
                        return f;
                    }
                    if (soqCorrect.length() < soq.length()) {
                        Failure f = new Failure();
                        f.setSuperOp(op);
                        f.setOffset(marker + soqCorrect.length());
                        f.setMaxOffset(marker + soq.length() - 1);
                        f.setOpNr(opCounter);
                        f.setSubOpNr(m);
                        f.setDescription(2);
                        int j3 = soqCorrect.length();
                        while (j3 < soq.length()) {
                            f.addDifferentOperation(soq.get(j3));
                            ++j3;
                        }
                        return f;
                    }
                }
                ++opCounter;
            }
            ++i;
        }
        return null;
    }

    private OperationQueue getPart(int start, int end) {
        OperationQueue oq = new OperationQueue();
        int i = start;
        while (i <= end) {
            int counter = -1;
            Object o = this.operations.elementAt(i);
            if (o != null) {
                Operation operation = (Operation)o;
                if (!operation.isExecuted()) {
                    operation = (Operation)operation.clone();
                    operation.getSubOperationQueue().clear();
                    ++i;
                    while (i <= end) {
                        o = this.operations.elementAt(i);
                        if (!(o instanceof SubOperation)) break;
                        operation.add((SubOperation)o);
                        ++i;
                    }
                    --i;
                }
                oq.add(operation);
            }
            ++i;
        }
        return oq;
    }

    public OperationQueue getInitOperationQueue() {
        int end = this.todoPosition;
        if (end > this.position) {
            end = this.position;
        }
        return this.getPart(0, end);
    }

    public OperationQueue getAllInitOperationQueue() {
        int end = this.todoPosition;
        if (end >= this.operations.size()) {
            end = this.operations.size() - 1;
        }
        return this.getPart(0, end);
    }

    public OperationQueue getTodoOperationQueue() {
        int end = this.operations.size();
        if (end > this.position) {
            end = this.position;
        }
        return this.getPart(this.todoPosition + 1, end);
    }

    public OperationQueue getAllTodoOperationQueue() {
        return this.getPart(this.todoPosition + 1, this.operations.size() - 1);
    }

    private Vector getSegment(int start, int end) {
        if (end > this.position) {
            end = this.position;
        }
        Vector oq = new Vector();
        int i = start;
        while (i <= end) {
            int counter = -1;
            Object o = this.operations.elementAt(i);
            if (o != null) {
                oq.add(o);
            }
            ++i;
        }
        return oq;
    }

    public Vector getInitOperations() {
        return this.getSegment(0, this.todoPosition);
    }

    public Vector getTodoOperations() {
        return this.getSegment(this.todoPosition + 1, this.operations.size());
    }

    public void addOperations(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            this.operations.add(op);
            if (op.isExecuted()) continue;
            SubOperationQueue soq = op.getSubOperationQueue();
            this.operations.addAll(soq.toVector());
        }
        this.position = this.operations.size() - 1;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "#Entries: " + this.operations.size() + "\n" + "Position: " + this.position + "\n\n";
        int counter = -1;
        Enumeration en = this.operations.elements();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o == null) {
                s = String.valueOf(s) + "EMPTY\n";
            } else if (o instanceof Operation) {
                s = String.valueOf(s) + (Operation)o + "\n";
            }
            if (++counter == this.position) {
                s = String.valueOf(s) + "----------- ACTUAL VIEW -----------\n";
            }
            if (counter != this.todoPosition) continue;
            s = String.valueOf(s) + "------------- EXERCISE ------------\n";
        }
        return s;
    }

    public boolean canUndo() {
        return this.undoRedoInfo.canUndo();
    }

    public int getCurrentOperationNr() {
        int cnr = -1;
        Enumeration en = this.operations.elements();
        int counter = -1;
        while (en.hasMoreElements() && counter < this.position) {
            if (en.nextElement() instanceof Operation) {
                ++cnr;
            }
            ++counter;
        }
        return cnr;
    }

    public int getCurrentSubOperationNr() {
        if (this.operations.elementAt(this.position) instanceof Operation) {
            return -2;
        }
        int cnr = -1;
        int size = this.operations.size();
        if (size > this.position) {
            size = this.position + 1;
        }
        while (size - (cnr + 2) > 0 && this.operations.elementAt(size - (cnr + 2)) instanceof SubOperation) {
            ++cnr;
        }
        return cnr;
    }

    public Object getEntry(int offset) {
        if (offset < 0 || offset >= this.operations.size()) {
            return null;
        }
        return this.operations.elementAt(offset);
    }

    public void addEntry(Object o) {
        this.operations.add(o);
    }

    public int getOperationCount() {
        return this.operations.size();
    }

    public int getOffset(int opnr, int subopnr) {
        if (subopnr < -1) {
            return -1;
        }
        int offset = -1;
        Enumeration en = this.operations.elements();
        ++opnr;
        Object o = null;
        while (opnr > 0 && en.hasMoreElements()) {
            o = en.nextElement();
            ++offset;
            if (!(o instanceof Operation)) continue;
            --opnr;
        }
        if (opnr > 0) {
            return -1;
        }
        if (subopnr == -1) {
            return offset;
        }
        ++subopnr;
        while (subopnr > 0 && en.hasMoreElements()) {
            o = en.nextElement();
            ++offset;
            if (!(o instanceof SubOperation)) {
                return -1;
            }
            --subopnr;
        }
        if (subopnr > 0) {
            return -1;
        }
        return offset;
    }

    public SubOperation getSubOperation(int opnr, int subopnr) {
        int offset = this.getOffset(opnr, subopnr);
        if (offset < 0) {
            return null;
        }
        return (SubOperation)this.getEntry(offset);
    }

    public SubOperation getCorrectSubOperation(int opnr, int subopnr) {
        if (subopnr < 0) {
            return null;
        }
        int offset = this.getOffset(opnr, -1);
        if (offset < 0) {
            return null;
        }
        Operation op = (Operation)this.getEntry(offset);
        SubOperationQueue soq = op.getSubOperationQueue();
        if (subopnr >= soq.length()) {
            return null;
        }
        return soq.get(subopnr);
    }

    public Operation getOperation(int opnr) {
        if (opnr < 0) {
            return null;
        }
        int offset = this.getOffset(opnr, -1);
        if (offset < 0) {
            return null;
        }
        return (Operation)this.getEntry(offset);
    }
}

