/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.OperationRecorder;
import mauda.XMLFileAccess;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.plugin.OperationExecuter;
import mauda.plugin.PlugInHandler;

public class SimpleExercise {
    private final String defaultFilename = "untitled.xml";
    private String filename;
    private Vector updateObjects = new Vector();
    private Object dsObject;
    public static OperationExecuter operationExecuter;
    private OperationRecorder operationRecorder = null;
    private PlugInHandler plugInHandler = new PlugInHandler(this);
    public static Vector availableOperations;
    public static Vector availableSubOperations;
    protected String dataDirectory;
    protected int mode;
    protected MetaData metaData;
    protected int difficulty;

    public SimpleExercise() {
        this.init();
    }

    public void init() {
        this.filename = "untitled.xml";
        this.mode = 0;
        this.difficulty = 0;
        this.dsObject = null;
        this.metaData = new MetaData();
        this.metaData.setDifficulty(this.difficulty);
        this.dataDirectory = null;
        if (this.operationRecorder != null) {
            this.removeExerciseUpdateListener(this.operationRecorder);
        }
        this.operationRecorder = new OperationRecorder();
        this.operationRecorder.add(null);
        this.addExerciseUpdateListenerFirst(this.operationRecorder);
    }

    public void switchTo(String plugInName) {
    }

    public PlugInHandler getPlugInHandler() {
        return this.plugInHandler;
    }

    public void setPlugInHandler(PlugInHandler pih) {
        this.plugInHandler = pih;
    }

    public void addExerciseUpdateListener(ExerciseUpdateListener eul) {
        this.updateObjects.add(eul);
    }

    public void addExerciseUpdateListenerFirst(ExerciseUpdateListener eul) {
        this.updateObjects.add(0, eul);
    }

    public void removeExerciseUpdateListener(ExerciseUpdateListener eul) {
        this.updateObjects.remove(eul);
    }

    public void sendExerciseUpdateMessages(ExerciseUpdateEvent event) {
        if (event.getID() == 3) {
            if (this.getOperationRecorder().getNextOperation() == null) {
                return;
            }
        } else {
            event.getID();
        }
        Enumeration en = this.updateObjects.elements();
        while (en.hasMoreElements()) {
            ((ExerciseUpdateListener)en.nextElement()).exerciseUpdate(event);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDefaultFilename() {
        return "untitled.xml";
    }

    public void setFilename(String fn) {
        this.filename = fn;
        ExerciseUpdateEvent event = new ExerciseUpdateEvent(this, 1);
        this.sendExerciseUpdateMessages(event);
    }

    public void setDefaultFilename() {
        this.setFilename(this.getDefaultFilename());
    }

    public void setDataDirectory(String directory) {
        this.dataDirectory = directory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setAvailableOperations(Vector v) {
        availableOperations = v;
    }

    public Vector getAvailableOperations() {
        return availableOperations;
    }

    public void setAvailableSubOperations(Vector v) {
        availableSubOperations = v;
    }

    public Vector getAvailableSubOperations() {
        return availableSubOperations;
    }

    public static void setOperationExecuter(OperationExecuter oe) {
        operationExecuter = oe;
    }

    public static OperationExecuter getOperationExecuter() {
        return operationExecuter;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData meta) {
        this.metaData = meta;
    }

    public void updateMetaDataInitTodoRating() {
        this.getMetaData().setInitRating(this.getOperationRecorder().getAllInitOperationQueue().getRating());
        this.getMetaData().setTodoRating(this.getOperationRecorder().getAllTodoOperationQueue().getRating());
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.metaData.setMode(mode);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
        this.metaData.setDifficulty(difficulty);
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDSObject(Object o) {
        this.dsObject = o;
    }

    public Object getDSObject() {
        return this.dsObject;
    }

    public OperationRecorder getOperationRecorder() {
        return this.operationRecorder;
    }

    public void operationExecuted(Object obj) {
        if (obj instanceof SimpleOperation) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 0);
            eue.setOperation((SimpleOperation)obj);
            this.sendExerciseUpdateMessages(eue);
        }
    }

    public HashMap load(String filename) {
        Vector v = XMLFileAccess.load(filename);
        if (v == null) {
            return null;
        }
        HashMap ht = (HashMap)v.firstElement();
        boolean ok = this.loadConfig(ht);
        if (!ok) {
            return null;
        }
        return ht;
    }

    public boolean loadConfig(HashMap ht) {
        String oldType = this.metaData.getType();
        MetaData m = new MetaData();
        m.load(ht.get("Meta-Data"));
        String newType = m.getType();
        if (!newType.equals(oldType)) {
            String plugInID = this.getPlugInHandler().getPlugInID(newType);
            if (plugInID == null) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Error: Unknown type. Cant load PlugIn!");
                return false;
            }
            this.switchTo(plugInID);
        }
        this.metaData.load(ht.get("Meta-Data"));
        this.difficulty = this.metaData.getDifficulty();
        this.setDifficulty(this.difficulty);
        this.setMode(this.metaData.getMode());
        if (ht.containsKey("Ratings")) {
            SimpleExercise.getOperationExecuter().getRatings().load((Vector)ht.get("Ratings"));
        }
        return true;
    }

    public boolean load(HashMap ht) {
        OperationQueue initOps = new OperationQueue();
        OperationQueue todoOps = new OperationQueue();
        initOps.load((Vector)ht.get("InitOperations"));
        todoOps.load((Vector)ht.get("TodoOperations"));
        this.operationRecorder.clear();
        this.operationRecorder.addOperations(initOps.toVector());
        this.operationRecorder.goInTodoMode();
        this.operationRecorder.addOperations(todoOps.toVector());
        return true;
    }

    public HashMap save(String filename) {
        HashMap<String, Cloneable> ht = new HashMap<String, Cloneable>();
        OperationQueue initOps = this.operationRecorder.getAllInitOperationQueue();
        OperationQueue todoOps = this.operationRecorder.getAllTodoOperationQueue();
        this.metaData.setInitRating(initOps.getRating());
        this.metaData.setTodoRating(todoOps.getRating());
        ht.put("Meta-Data", this.metaData.save());
        ht.put("InitOperations", initOps.save());
        ht.put("TodoOperations", todoOps.save());
        ht.put("Ratings", SimpleExercise.getOperationExecuter().getRatings().save());
        if (filename != null) {
            Vector<HashMap<String, Cloneable>> v = new Vector<HashMap<String, Cloneable>>();
            v.add(ht);
            boolean result = XMLFileAccess.save(filename, v);
            if (!result) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '" + filename + "' !\n\n" + "--> File not saved!");
            }
        }
        return ht;
    }
}

