/*
 * Decompiled with CFR 0.152.
 */
package mauda.evaluation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.evaluation.WrapPanel;
import mauda.operation.SimpleOperation;

public class CommentView
implements ExerciseUpdateListener {
    private Exercise exercise;
    private boolean finishedLoading;
    private Vector commentObjects;
    private int position;
    private JPanel panel;
    private JTextPane editorPane;

    public CommentView(Exercise exercise) {
        this.exercise = exercise;
        this.finishedLoading = false;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.editorPane = new JTextPane();
        this.editorPane.setEditable(true);
        WrapPanel wrapPanel = new WrapPanel(this.editorPane, true);
        JScrollPane sp = new JScrollPane(wrapPanel);
        this.panel.add((Component)sp, "Center");
        this.commentObjects = new Vector();
        this.position = -1;
        this.initComments();
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 4) {
            this.finishedLoading = true;
            this.showComment();
            return;
        }
        if (!this.finishedLoading) {
            return;
        }
        if (e.getID() == 14) {
            this.storeActualComment();
            ++this.position;
            this.showComment();
        }
        if (!e.dsChanged()) {
            return;
        }
        this.storeActualComment();
        switch (e.getID()) {
            case 0: {
                this.interactiveEvent(e.getOperation());
                break;
            }
            case 7: {
                --this.position;
                this.showComment();
                break;
            }
            case 8: {
                ++this.position;
                this.showComment();
                break;
            }
            case 10: {
                this.finishedLoading = false;
                this.position = -1;
                this.initComments();
                break;
            }
            case 12: {
                this.position += e.getValue();
                this.showComment();
                break;
            }
        }
    }

    private void initComments() {
        this.commentObjects.removeAllElements();
        Vector<String> newv = new Vector<String>();
        newv.add("Beginning of Exercise\n\n");
        this.commentObjects.addAll(newv);
        this.showComment();
    }

    private void interactiveEvent(SimpleOperation so) {
        if (this.position + 1 >= this.commentObjects.size()) {
            this.commentObjects.add("Comment for: " + so.out() + "\n\n");
        }
        this.showComment();
    }

    private void showComment() {
        if (this.position < -1) {
            return;
        }
        if (this.position + 1 >= this.commentObjects.size()) {
            return;
        }
        String comment = (String)this.commentObjects.elementAt(this.position + 1);
        this.editorPane.setText(comment);
    }

    private void storeActualComment() {
        if (this.position < -1) {
            return;
        }
        if (this.position + 1 >= this.commentObjects.size()) {
            return;
        }
        String comment = this.editorPane.getText();
        this.commentObjects.setElementAt(comment, this.position + 1);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Vector save() {
        this.storeActualComment();
        return (Vector)this.commentObjects.clone();
    }

    public void load(Vector v) {
        this.commentObjects = (Vector)v.clone();
    }
}

