/*
 * Decompiled with CFR 0.152.
 */
package mauda.evaluation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jedas.Jedas;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.OperationRecorder;
import mauda.SimpleExercise;
import mauda.XMLFileAccess;
import mauda.evaluation.CommentView;
import mauda.evaluation.TimeStampRecorder;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SubOperationQueue;
import mauda.treeoperationview.TreeOperationView;
import mauda.utils.FileLocation;

public class EvalExercise
extends Exercise
implements ExerciseUpdateListener {
    private TreeOperationView treeOperationView = new TreeOperationView(this);
    private CommentView commentView;
    private TimeStampRecorder timeStampRecorder;
    private Timer modifiedTimer;

    public EvalExercise(String type) {
        super(type);
        this.addExerciseUpdateListener(this.treeOperationView);
        this.commentView = new CommentView(this);
        this.addExerciseUpdateListener(this.commentView);
        this.timeStampRecorder = new TimeStampRecorder(this);
        this.addExerciseUpdateListener(this.timeStampRecorder);
        this.addExerciseUpdateListener(this);
        this.modifiedTimer = null;
    }

    public TreeOperationView getTreeOperationView() {
        return this.treeOperationView;
    }

    public CommentView getCommentView() {
        return this.commentView;
    }

    public boolean loadCompleted(HashMap ht) {
        File file;
        if (this.modifiedTimer != null) {
            this.modifiedTimer.stop();
        }
        if ((file = new File(FileLocation.jedasRecordingFilename)).exists()) {
            file.delete();
        }
        this.reset();
        this.metaData.load(ht.get("Meta-Data"));
        this.difficulty = this.metaData.getDifficulty();
        this.setDifficulty(this.difficulty);
        this.setMode(this.metaData.getMode());
        if (ht.containsKey("Ratings")) {
            SimpleExercise.getOperationExecuter().getRatings().load((Vector)ht.get("Ratings"));
        }
        OperationQueue init = new OperationQueue();
        OperationQueue todo = new OperationQueue();
        OperationQueue acco = new OperationQueue();
        init.load((Vector)ht.get("InitOperations"));
        todo.load((Vector)ht.get("TodoOperations"));
        acco.load((Vector)ht.get("AccomplishedOperations"));
        Vector exOps = new Vector();
        exOps.add(new ExerciseUpdateEvent(this, 5));
        exOps.addAll((Vector)init.toVector().clone());
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, -1);
        eue.setMessage("GO_IN_TODO-MODE");
        exOps.add(eue);
        exOps.add(new ExerciseUpdateEvent(this, 2));
        exOps.add(new ExerciseUpdateEvent(this, 4));
        int i = 0;
        while (i < acco.length()) {
            Operation op = acco.get(i);
            exOps.add(op);
            SubOperationQueue soq = op.getSubOperationQueue();
            int j = 0;
            while (j < soq.length()) {
                exOps.add(soq.get(j));
                ++j;
            }
            ++i;
        }
        exOps.add(new ExerciseUpdateEvent(this, 6));
        exOps = this.addFullLoadedMessage(exOps);
        this.getUndoRedo().clear();
        this.setDSObject(this.getUndoRedo().getDSObject());
        this.getOperationRecorder().clear();
        this.commit(exOps);
        this.metaData.setEvaluatorName("<Please enter your name!>");
        this.metaData.actualizeEvaluatorDate();
        this.metaData.setEvaluatorState("in process");
        this.metaData.setEvaluatorScore("<?> of 100");
        return true;
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 17) {
            this.treeOperationView.markCorrectness(false, true);
            this.jumpToBeginning();
            this.treeOperationView.enableJumping();
            this.treeOperationView.enableStop();
            final EvalExercise ex = this;
            this.modifiedTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Jedas.isRecording()) {
                        ex.setModified(true);
                        ((Timer)e.getSource()).stop();
                    }
                }
            });
            this.modifiedTimer.start();
        }
    }

    public void saveEvaluated(String filename) {
        boolean ok;
        String jeaFilename = FileLocation.jedasRecordingFilename;
        File jeaFile = new File(jeaFilename);
        if (!jeaFile.exists()) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "No Jedas-Recording performed!");
            return;
        }
        File newFile = new File(String.valueOf(filename) + ".jea");
        if (newFile.exists()) {
            newFile.delete();
        }
        if (!(ok = this.copyFile(jeaFile, newFile))) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant rename Jedas-Animation-File");
            return;
        }
        jeaFilename = newFile.getAbsolutePath();
        this.metaData.setEvaluatorState("evaluated");
        jeaFilename = jeaFilename.replace('\\', '/');
        jeaFilename = jeaFilename.substring(jeaFilename.lastIndexOf("/") + 1);
        this.metaData.setEvaluatorJEAFilename(jeaFilename);
        this.metaData.inputDialog();
        HashMap<String, Cloneable> ht = new HashMap<String, Cloneable>();
        ht.put("Meta-Data", this.metaData.save());
        OperationRecorder or = this.getOperationRecorder();
        OperationQueue acco = or.getAllTodoOperationQueue();
        ht.put("AccomplishedOperations", acco.save());
        ht.put("Comments", this.commentView.save());
        ht.put("TimeStamps", this.timeStampRecorder.save());
        Vector<HashMap<String, Cloneable>> v = new Vector<HashMap<String, Cloneable>>();
        v.add(ht);
        boolean result = XMLFileAccess.save(filename, v);
        if (!result) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '" + filename + "' !\n\n" + "--> File not saved!");
        } else {
            this.setModified(false);
        }
    }

    private boolean copyFile(File src, File dest) {
        boolean ok = true;
        BufferedInputStream srcIn = null;
        FilterOutputStream destOut = null;
        try {
            srcIn = new BufferedInputStream(new FileInputStream(src));
            byte[] b = new byte[srcIn.available()];
            srcIn.read(b);
            srcIn.close();
            destOut = new BufferedOutputStream(new FileOutputStream(dest));
            destOut.write(b);
            destOut.close();
        }
        catch (Exception ex) {
            ok = false;
        }
        if (!ok) {
            try {
                srcIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                destOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }
}

