/*
 * Decompiled with CFR 0.152.
 */
package mauda.evaluation;

import evalplayer.OperationPlayerThread;
import evalplayer.TimeSlider;
import java.util.HashMap;
import java.util.Vector;
import jedas.CompPanel;
import jedas.Jedas;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.OperationRecorder;
import mauda.evaluation.CommentView;
import mauda.evaluation.PleaseWaitFrame;
import mauda.evaluation.TimeStampRecorder;
import mauda.jedasnew.JedasPlayer;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperationQueue;
import mauda.treeoperationview.TreeOperationView;

public class PlayerExercise
extends Exercise
implements ExerciseUpdateListener {
    public OperationPlayerThread operationPlayerThread = null;
    private TreeOperationView treeOperationView = new TreeOperationView(this);
    private CommentView commentView;
    private TimeStampRecorder timeStampRecorder;
    private JedasPlayer jedasPlayer;

    public PlayerExercise(String type) {
        super(type);
        this.addExerciseUpdateListener(this.treeOperationView);
        this.commentView = new CommentView(this);
        this.addExerciseUpdateListener(this.commentView);
        this.timeStampRecorder = new TimeStampRecorder(this);
        this.timeStampRecorder.setPlayerMode(true);
        this.addExerciseUpdateListener(this.timeStampRecorder);
        this.addExerciseUpdateListener(this);
        this.jedasPlayer = null;
    }

    public TreeOperationView getTreeOperationView() {
        return this.treeOperationView;
    }

    public CommentView getCommentView() {
        return this.commentView;
    }

    public TimeStampRecorder getTimeStampRecorder() {
        return this.timeStampRecorder;
    }

    public boolean loadEvaluated(HashMap ht) {
        this.operationPlayerThread = null;
        this.reset();
        this.jedasPlayer = null;
        this.metaData.load(ht.get("Meta-Data"));
        this.difficulty = this.metaData.getDifficulty();
        this.setDifficulty(this.difficulty);
        this.setMode(this.metaData.getMode());
        OperationQueue acco = new OperationQueue();
        acco.load((Vector)ht.get("AccomplishedOperations"));
        this.commentView.load((Vector)ht.get("Comments"));
        this.timeStampRecorder.load((Vector)ht.get("TimeStamps"));
        Vector exOps = new Vector();
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, -1);
        eue.setMessage("GO_IN_TODO-MODE");
        exOps.add(eue);
        exOps.add(new ExerciseUpdateEvent(this, 4));
        int i = 0;
        while (i < acco.length()) {
            Operation op = acco.get(i);
            exOps.add(op);
            SubOperationQueue soq = op.getSubOperationQueue();
            int j = 0;
            while (j < soq.length()) {
                exOps.add(soq.get(j));
                ++j;
            }
            ++i;
        }
        eue = new ExerciseUpdateEvent(this, -1);
        eue.setMessage("FULL_LOADED");
        exOps.add(eue);
        exOps = this.addFullLoadedMessage(exOps);
        this.getUndoRedo().clear();
        this.setDSObject(this.getUndoRedo().getDSObject());
        this.getOperationRecorder().clear();
        this.commit(exOps);
        String jeaFilename = this.metaData.getEvaluatorJEAFilename();
        String path = this.getFilename();
        path = path.replace('\\', '/');
        path = path.substring(0, path.lastIndexOf("/") + 1);
        this.loadAnimation(String.valueOf(path) + jeaFilename);
        this.getTimeStampRecorder().calculateSeqTimeStamps();
        TimeSlider.getInstance().configure();
        return true;
    }

    protected void loadAnimation(String filename) {
        PleaseWaitFrame frame = new PleaseWaitFrame();
        String[] args = new String[]{filename};
        Jedas.setPlayerMode((boolean)true);
        new JedasPlayer(filename, false);
        this.jedasPlayer = JedasPlayer.getInstance();
        Vector v = this.jedasPlayer.getCompPanels();
        this.jedasPanel.setPlayerCompPanel((CompPanel)v.firstElement());
        frame.close();
    }

    public JedasPlayer getJedasPlayer() {
        return this.jedasPlayer;
    }

    public void commit(SimpleOperation so) {
        if (this.jedasPlayer == null) {
            super.commit(so);
        } else {
            this.addToAnimationQueue(so);
            this.startOperationPlayer();
        }
    }

    public void commit(Vector v) {
        if (this.jedasPlayer == null) {
            super.commit(v);
        } else {
            this.addToAnimationQueue(v);
            this.startOperationPlayer();
        }
    }

    public void stopPlaying() {
        super.stopPlaying();
        if (this.operationPlayerThread != null) {
            this.operationPlayerThread.stopAnimation();
        }
    }

    private void startOperationPlayer() {
        this.operationPlayerThread = new OperationPlayerThread(this);
        this.operationPlayerThread.start();
    }

    public boolean isPlaying() {
        if (this.operationPlayerThread == null) {
            return false;
        }
        return this.operationPlayerThread.isPlaying();
    }

    public void animate() {
        this.setActionsAllowed(false);
        while (this.opsToAnimate.size() > 0) {
            Object obj = this.opsToAnimate.firstElement();
            Vector vector = this.opsToAnimate;
            synchronized (vector) {
                this.opsToAnimate.removeElementAt(0);
            }
            this.performAction(obj);
        }
        this.setActionsAllowed(true);
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 13);
        this.sendExerciseUpdateMessages(eue);
    }

    public void performAction(Object obj) {
        if (obj instanceof SimpleOperation) {
            SimpleOperation op = (SimpleOperation)obj;
            OperationRecorder or = this.getOperationRecorder();
            TimeStampRecorder tsr = this.getTimeStampRecorder();
            int position = or.getCurrentOffset() - or.getOffset(0, -1);
            if (this.operationPlayerThread != null) {
                this.operationPlayerThread.playSeqOpTimeStamp(tsr.getSeqEntry(position + 1));
            } else {
                ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, 14);
                this.sendExerciseUpdateMessages(eue);
                this.operationExecuted(op);
            }
        } else if (obj instanceof ExerciseUpdateEvent) {
            ExerciseUpdateEvent event = (ExerciseUpdateEvent)obj;
            if (event.getID() == 9) {
                OperationRecorder or = this.getOperationRecorder();
                SimpleOperation so = (SimpleOperation)or.getEntry(or.getCurrentOffset() + 1);
                this.addToAnimationQueue(so);
            } else {
                this.sendExerciseUpdateMessages(event);
            }
        }
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == -1 && e.getMessage().equals("FULL_LOADED")) {
            this.jumpToBeginning();
            this.treeOperationView.enableJumping();
            this.treeOperationView.enableStop();
        }
    }
}

