/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.OperationRecorder;
import mauda.SimpleExercise;
import mauda.XMLFileAccess;
import mauda.feedback.FeedbackPanel;
import mauda.feedback.SimpleFeedback;
import mauda.feedback.select.FeedbackSelector;
import mauda.feedback.types.DemandFeedback;
import mauda.feedback.types.ErrorFlagging;
import mauda.feedback.types.FaultFeedback;
import mauda.feedback.types.ImmediateFeedbackAndErrorCorrection;
import mauda.feedback.types.NoTutor;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SubOperationQueue;
import mauda.treeoperationview.TreeOperationView;

public class FeedbackExercise
extends Exercise
implements ExerciseUpdateListener {
    private SimpleFeedback feedback;
    private FeedbackPanel feedbackPanel;
    private TreeOperationView treeOperationView = new TreeOperationView(this);
    private HashMap feedbackConfig;
    private Vector treeOperationViewConfig;

    public FeedbackExercise(String type) {
        super(type);
        this.addExerciseUpdateListener(this.treeOperationView);
        this.addExerciseUpdateListener(this);
        this.feedbackPanel = new FeedbackPanel(this);
    }

    public void setFeedback(SimpleFeedback feedback) {
        this.feedback = feedback;
        if (feedback instanceof DemandFeedback) {
            DemandFeedback df = (DemandFeedback)feedback;
            this.treeOperationView.getNodePopup().removeItem("Request Feedback");
            this.treeOperationView.getNodePopup().addItem("Request Feedback", df);
        } else {
            this.treeOperationView.getNodePopup().removeItem("Request Feedback");
        }
        int fbid = feedback.getFeedbackTypeID();
        String n = FeedbackSelector.getFeedbackTypeNameFromID(fbid);
        this.metaData.setEditorFeedback(n);
    }

    public SimpleFeedback getFeedback() {
        return this.feedback;
    }

    public FeedbackPanel getFeedbackPanel() {
        return this.feedbackPanel;
    }

    public TreeOperationView getTreeOperationView() {
        return this.treeOperationView;
    }

    public void saveWork(String filename) {
        int fbid = this.feedback.getFeedbackTypeID();
        OperationQueue init = this.feedback.getInitOperationQueue();
        OperationQueue todo = this.feedback.getTodoOperationQueue();
        OperationRecorder or = this.getOperationRecorder();
        OperationQueue acco = or.getAllTodoOperationQueue();
        HashMap<String, Cloneable> ht = new HashMap<String, Cloneable>();
        this.metaData.setEditorFeedback(FeedbackSelector.getFeedbackTypeNameFromID(fbid));
        ht.put("Meta-Data", this.metaData.save());
        ht.put("InitOperations", init.save());
        ht.put("TodoOperations", todo.save());
        ht.put("AccomplishedOperations", acco.save());
        ht.put("FeedbackSpecific", this.feedback.save());
        ht.put("TreeOperationView", this.getTreeOperationView().save());
        ht.put("Ratings", SimpleExercise.getOperationExecuter().getRatings().save());
        Vector<HashMap<String, Cloneable>> v = new Vector<HashMap<String, Cloneable>>();
        v.add(ht);
        boolean result = XMLFileAccess.save(filename, v);
        if (!result) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '" + filename + "' !\n\n" + "--> File not saved!");
        } else {
            this.setModified(false);
        }
    }

    public boolean loadWork(HashMap ht) {
        this.reset();
        this.removeExerciseUpdateListener(this.feedback);
        this.metaData.load(ht.get("Meta-Data"));
        this.difficulty = this.metaData.getDifficulty();
        this.setDifficulty(this.difficulty);
        this.setMode(this.metaData.getMode());
        if (ht.containsKey("Ratings")) {
            SimpleExercise.getOperationExecuter().getRatings().load((Vector)ht.get("Ratings"));
        }
        OperationQueue init = new OperationQueue();
        OperationQueue todo = new OperationQueue();
        OperationQueue acco = new OperationQueue();
        init.load((Vector)ht.get("InitOperations"));
        todo.load((Vector)ht.get("TodoOperations"));
        acco.load((Vector)ht.get("AccomplishedOperations"));
        this.feedbackConfig = (HashMap)ht.get("FeedbackSpecific");
        this.treeOperationViewConfig = (Vector)ht.get("TreeOperationView");
        int type = FeedbackSelector.getIDFromFeedbackTypeName(this.metaData.getEditorFeedback());
        switch (type) {
            case 0: {
                this.feedback = new ImmediateFeedbackAndErrorCorrection(this);
                break;
            }
            case 1: {
                this.feedback = new ErrorFlagging(this);
                break;
            }
            case 2: {
                this.feedback = new DemandFeedback(this);
                break;
            }
            case 3: {
                this.feedback = new NoTutor(this);
                break;
            }
            case 4: {
                this.feedback = new FaultFeedback(this);
                break;
            }
            default: {
                System.out.println("Unrecognized feedback!!! BREAK!!!");
                return false;
            }
        }
        this.feedback.setInitOperationQueue(init);
        this.feedback.setTodoOperationQueue(todo);
        this.feedback.configurated = false;
        this.addExerciseUpdateListener(this.feedback);
        this.feedback.displayMessage("FEEDBACK", "");
        this.feedback.displayMessage("TASK", "<b>Loading Exercise.</b><br><br>Please wait ...");
        this.setFeedback(this.feedback);
        Vector<Object> exOps = new Vector<Object>();
        exOps.add(new ExerciseUpdateEvent(this, 5));
        exOps.addAll((Vector)init.toVector().clone());
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this, -1);
        eue.setMessage("GO_IN_TODO-MODE");
        exOps.add(eue);
        exOps.add(new ExerciseUpdateEvent(this, 2));
        exOps.add(new ExerciseUpdateEvent(this, 6));
        exOps.add(new ExerciseUpdateEvent(this, 4));
        int i = 0;
        while (i < acco.length()) {
            Operation op = acco.get(i);
            exOps.add(op);
            SubOperationQueue soq = op.getSubOperationQueue();
            int j = 0;
            while (j < soq.length()) {
                exOps.add(soq.get(j));
                ++j;
            }
            ++i;
        }
        eue = new ExerciseUpdateEvent(this, -1);
        eue.setMessage("FEEDBACK_CONFIG");
        exOps.add(eue);
        this.getUndoRedo().clear();
        this.setDSObject(this.getUndoRedo().getDSObject());
        this.getOperationRecorder().clear();
        this.commit(exOps);
        this.setModified(false);
        return true;
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == -1) {
            if (e.getMessage().equals("FEEDBACK_CONFIG")) {
                this.feedback.load(this.feedbackConfig);
                this.getTreeOperationView().load(this.treeOperationViewConfig);
                if (!(this.feedback instanceof FaultFeedback)) {
                    this.getTreeOperationView().enableStop();
                }
            } else if (e.getMessage().equals("FAULT_STATE-CONFIG")) {
                ((FaultFeedback)this.feedback).stateConfig();
            }
        }
    }
}

