/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mauda.operation.Operation;
import mauda.operation.SubOperation;

public class FeedbackObject
implements Comparator {
    public static final int UNKNOWN = 0;
    public static final int CORRECT = 1;
    public static final int INCORRECT = 2;
    public static final int INCORRECT_MISSING = 3;
    private Vector messages = null;
    private int correctness = 0;
    private int messagePosition = -1;
    private Operation op;
    private SubOperation subop;
    private SubOperation correctsubop;
    private int opnr;
    private int subopnr;
    private boolean showLocation = false;

    public void setMessages(Vector m) {
        this.messages = (Vector)m.clone();
    }

    public Vector getMessages() {
        return this.messages;
    }

    public void setOperation(Operation op) {
        this.op = op;
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setSubOperation(SubOperation subop) {
        this.subop = subop;
    }

    public SubOperation getSubOperation() {
        return this.subop;
    }

    public void setCorrectSubOperation(SubOperation subop) {
        this.correctsubop = subop;
    }

    public SubOperation getCorrectSubOperation() {
        return this.correctsubop;
    }

    public void setOpNr(int n) {
        this.opnr = n;
    }

    public int getOpNr() {
        return this.opnr;
    }

    public void setSubOpNr(int n) {
        this.subopnr = n;
    }

    public int getSubOpNr() {
        return this.subopnr;
    }

    public void setCorrectness(int c) {
        this.correctness = c;
    }

    public int getCorrectness() {
        return this.correctness;
    }

    public void setMessagePosition(int p) {
        this.messagePosition = p;
    }

    public String getNextMessage() {
        if (this.messagePosition < this.messages.size() - 1) {
            ++this.messagePosition;
        }
        String msg = (String)this.messages.elementAt(this.messagePosition);
        return this.makeHTML(msg);
    }

    public String getPrevMessage() {
        if (this.messagePosition > 0) {
            --this.messagePosition;
        }
        String msg = (String)this.messages.elementAt(this.messagePosition);
        return this.makeHTML(msg);
    }

    private String makeHTML(String msg) {
        boolean next;
        switch (this.correctness) {
            case 3: {
                msg = this.genMessage("incorrect_x.gif", "<b>Incorrect</b><br>There are missing Sub-Operations", "explanation.gif", msg);
                break;
            }
            case 2: {
                msg = this.genMessage("incorrect_x.gif", "<b>Incorrect</b>", "explanation.gif", msg);
                break;
            }
            case 1: {
                msg = this.genMessage("correct_v.gif", "<b>Correct</b>", "lamp.gif", msg);
                break;
            }
            case 0: {
                msg = "Unknown";
                break;
            }
            default: {
                msg = "Unknown correctness";
            }
        }
        boolean prev = this.messagePosition > 0;
        boolean bl = next = this.messagePosition < this.messages.size() - 1;
        if (prev || next) {
            String plink = "";
            String nlink = "";
            if (prev) {
                plink = "<a href='prevMessage'>prev...</a>";
            }
            if (next) {
                nlink = "<a href='nextMessage'>more...</a>";
            }
            msg = String.valueOf(msg) + "<table width=100%><tr><td align=left>" + plink + "</td>" + "<td align=right>" + nlink + "</td></tr></table>";
        }
        if (this.showLocation) {
            String location = "<br><b>Location:</b> ";
            location = String.valueOf(location) + "<i>" + this.op.out() + "</i>";
            location = this.correctness != 3 ? String.valueOf(location) + " / <i>" + this.subop.out() + "</i>" : String.valueOf(location) + " et seqq.";
            msg = String.valueOf(msg) + location;
        }
        return msg;
    }

    public void setLocationShow(boolean b) {
        this.showLocation = b;
    }

    public String genMessage(String img1, String txt1, String img2, String txt2) {
        String msg = "<table border=0 cellpadding=1><tr><td valign=top>";
        if (img1 != null) {
            msg = String.valueOf(msg) + "<img src='./images/" + img1 + "'>";
        }
        msg = String.valueOf(msg) + "</td><td>" + txt1 + "</td></tr>";
        if (img2 != null || txt2 != null) {
            msg = String.valueOf(msg) + "<tr><td valign=top>";
            if (img2 != null) {
                msg = String.valueOf(msg) + "<img src='./images/" + img2 + "'>";
            }
            msg = String.valueOf(msg) + "</td><td>" + txt2 + "</td></tr>";
        }
        msg = String.valueOf(msg) + "</table>";
        return msg;
    }

    public int compare(Object o1, Object o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (!(o1 instanceof FeedbackObject)) {
            return 0;
        }
        if (!(o2 instanceof FeedbackObject)) {
            return 0;
        }
        FeedbackObject fo1 = (FeedbackObject)o1;
        FeedbackObject fo2 = (FeedbackObject)o2;
        if (fo1.getOpNr() < fo2.getOpNr()) {
            return -1;
        }
        if (fo1.getSubOpNr() < fo2.getSubOpNr()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeedbackObject)) {
            return false;
        }
        FeedbackObject fo = (FeedbackObject)o;
        boolean nosubopcheck = false;
        if (this.subopnr < 0 && fo.getSubOpNr() < 0) {
            nosubopcheck = true;
        }
        return this.correctness == 3 ? fo.getCorrectness() == this.correctness && fo.getOpNr() == this.opnr && (fo.getSubOpNr() - 1 == this.subopnr || nosubopcheck) : !(fo.getCorrectness() != this.correctness || fo.getOpNr() != this.opnr || fo.getSubOpNr() != this.subopnr && !nosubopcheck || fo.getCorrectSubOperation() != null && !fo.getCorrectSubOperation().equals(this.correctsubop) || !fo.getSubOperation().equals(this.subop));
    }

    public String toString() {
        String s = "FEEDBACK-OBJECT:\n";
        s = String.valueOf(s) + "  Operation = " + this.op.out() + " (" + this.opnr + ")\n";
        s = String.valueOf(s) + "  SubOperation = " + (this.subop != null ? this.subop.out() : "null") + " (" + this.subopnr + ")\n";
        s = String.valueOf(s) + "  Correct-SubOperation = " + (this.correctsubop != null ? this.correctsubop.out() : "null") + "\n";
        s = String.valueOf(s) + "  Correctness = ";
        switch (this.correctness) {
            case 0: {
                s = String.valueOf(s) + "UNKNOWN";
                break;
            }
            case 1: {
                s = String.valueOf(s) + "CORRECT";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "INCORRECT";
                break;
            }
            case 3: {
                s = String.valueOf(s) + "INCORRECT_MISSING";
                break;
            }
            default: {
                s = String.valueOf(s) + "error";
            }
        }
        s = String.valueOf(s) + "\n";
        if (this.messages == null) {
            s = String.valueOf(s) + "  NO MESSAGES!";
        } else {
            Enumeration en = this.messages.elements();
            while (en.hasMoreElements()) {
                s = String.valueOf(s) + "  Message: " + en.nextElement();
            }
        }
        return s;
    }

    public Object clone() {
        FeedbackObject nfo = new FeedbackObject();
        nfo.load(this.save());
        return nfo;
    }

    public HashMap save() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("Messages", this.messages);
        hm.put("Correctness", new Integer(this.correctness));
        hm.put("MessagePosition", new Integer(this.messagePosition));
        hm.put("Operation", this.op.save());
        if (this.subop != null) {
            hm.put("SubOperation", this.subop.save());
        } else {
            hm.put("SubOperation", "null");
        }
        if (this.correctsubop != null) {
            hm.put("CorrectSubOperation", this.correctsubop.save());
        } else {
            hm.put("CorrectSubOperation", "null");
        }
        hm.put("OperationNr", new Integer(this.opnr));
        hm.put("SubOperationNr", new Integer(this.subopnr));
        hm.put("ShowLocation", new Boolean(this.showLocation));
        return hm;
    }

    public void load(HashMap hm) {
        this.messages = (Vector)hm.get("Messages");
        this.correctness = (Integer)hm.get("Correctness");
        this.messagePosition = (Integer)hm.get("MessagePosition");
        this.op = new Operation();
        this.op.load((String)hm.get("Operation"));
        String s = (String)hm.get("SubOperation");
        if (!s.equals("null")) {
            this.subop = new SubOperation();
            this.subop.load(s);
        } else {
            this.subop = null;
        }
        s = (String)hm.get("CorrectSubOperation");
        if (!s.equals("null")) {
            this.correctsubop = new SubOperation();
            this.correctsubop.load(s);
        } else {
            this.correctsubop = null;
        }
        this.opnr = (Integer)hm.get("OperationNr");
        this.subopnr = (Integer)hm.get("SubOperationNr");
        this.showLocation = (Boolean)hm.get("ShowLocation");
    }
}

