/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.SimpleFeedback;
import mauda.utils.HTMLView;

public class FeedbackPanel
extends JPanel
implements HyperlinkListener,
ActionListener {
    private FeedbackExercise exercise;
    private JPanel actionPanel;
    private GridBagLayout actionPanelGridBagLayout;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton specialButton;
    protected JButton demandButton;
    protected JButton giveUpButton;
    private JTabbedPane tabbedPane;
    private HTMLView taskView;
    private HTMLView feedbackView;
    private HTMLEditorKit htmlEditorKit;

    public FeedbackPanel(FeedbackExercise exercise) {
        this.exercise = exercise;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.taskView = new HTMLView(this);
        this.tabbedPane.add("Task", this.taskView.getPanel());
        this.feedbackView = new HTMLView(this);
        this.tabbedPane.add("Feedback", this.feedbackView.getPanel());
        topPanel.add((Component)this.tabbedPane, "Center");
        this.backButton = new JButton("Back");
        this.backButton.addActionListener(this);
        this.forwardButton = new JButton("Forward");
        this.forwardButton.addActionListener(this);
        this.specialButton = new JButton("Special");
        this.specialButton.addActionListener(this);
        this.demandButton = new JButton("Demand");
        this.demandButton.addActionListener(this);
        this.giveUpButton = new JButton("Give up...");
        this.giveUpButton.addActionListener(this);
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.specialButton.setEnabled(false);
        exercise.setInteractiveMode(3);
        this.actionPanel = new JPanel();
        this.actionPanelGridBagLayout = new GridBagLayout();
        this.actionPanel.setLayout(this.actionPanelGridBagLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.actionPanelGridBagLayout.setConstraints(this.backButton, c);
        this.actionPanel.add(this.backButton);
        c.gridx = 1;
        this.actionPanelGridBagLayout.setConstraints(this.forwardButton, c);
        this.actionPanel.add(this.forwardButton);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.actionPanelGridBagLayout.setConstraints(this.specialButton, c);
        this.actionPanel.add(this.specialButton);
        c.gridx = 1;
        this.actionPanelGridBagLayout.setConstraints(this.demandButton, c);
        this.actionPanel.add(this.demandButton);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        this.actionPanelGridBagLayout.setConstraints(this.giveUpButton, c);
        this.actionPanel.add(this.giveUpButton);
        topPanel.add((Component)this.actionPanel, "South");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)exercise.getTreeOperationView().getPanel(), "Center");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setDividerLocation(350);
        splitPane.setTopComponent(topPanel);
        splitPane.setBottomComponent(bottomPanel);
        topPanel.setMinimumSize(new Dimension(240, 50));
        bottomPanel.setMinimumSize(new Dimension(240, 50));
        this.add((Component)splitPane, "Center");
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected HTMLView getTaskView() {
        return this.taskView;
    }

    protected HTMLView getFeedbackView() {
        return this.feedbackView;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        JButton b = (JButton)e.getSource();
        SimpleFeedback fb = this.exercise.getFeedback();
        if (b == this.backButton) {
            fb.backPressed();
        } else if (b == this.forwardButton) {
            fb.forwardPressed();
        } else if (b == this.specialButton) {
            fb.specialPressed();
        } else if (b == this.demandButton) {
            fb.demandPressed();
        } else if (b == this.giveUpButton) {
            fb.giveUpPressed();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                String href = e.getDescription();
                this.exercise.getFeedback().linkClicked(href);
            }
        }
    }

    public void showDemandButton() {
        this.actionPanel.remove(this.demandButton);
        this.actionPanel.add(this.demandButton);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.actionPanelGridBagLayout.setConstraints(this.specialButton, c);
        c.gridx = 1;
        this.actionPanelGridBagLayout.setConstraints(this.demandButton, c);
        this.actionPanel.invalidate();
        this.actionPanel.revalidate();
    }

    public void hideDemandButton() {
        this.actionPanel.remove(this.demandButton);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        this.actionPanelGridBagLayout.setConstraints(this.specialButton, c);
        this.actionPanel.invalidate();
        this.actionPanel.revalidate();
    }

    public void disableAllButtons() {
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.giveUpButton.setEnabled(false);
    }
}

