/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mauda.OperationRecorder;
import mauda.feedback.Evaluator;
import mauda.feedback.FeedbackObject;
import mauda.operation.Operation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;

public class NormalEvaluator
extends Evaluator {
    private static final double weight = 1.0;
    private int selfCorrectedErrorCounter = 0;
    private Vector falseFeedbackObjects = new Vector();

    public void log(FeedbackObject fo) {
        if (!this.falseFeedbackObjects.contains(fo)) {
            this.falseFeedbackObjects.add(fo);
        }
    }

    public void evaluate(OperationRecorder or) {
        this.maxPoints = 0.0;
        this.errorPoints = 0.0;
        this.errorCounter = 0;
        this.selfCorrectedErrorCounter = 0;
        int allErrorCounter = 0;
        Vector v = or.getTodoOperations();
        int counter = -1;
        int opnr = -1;
        int subopnr = -1;
        while (counter < v.size()) {
            if (++counter >= v.size()) break;
            Object o = v.elementAt(counter);
            if (!(o instanceof Operation)) continue;
            ++opnr;
            Operation op = (Operation)o;
            SubOperationQueue csoq = op.getSubOperationQueue();
            SubOperationQueue asoq = new SubOperationQueue();
            if (++counter < v.size()) {
                o = v.elementAt(counter);
                while (counter < v.size() && o instanceof SubOperation) {
                    asoq.add((SubOperation)o);
                    if (++counter >= v.size()) break;
                    o = v.elementAt(counter);
                }
            }
            --counter;
            this.maxPoints += 1.0;
            if (asoq.length() == 0) {
                ++allErrorCounter;
                FeedbackObject fo = this.check(opnr, -1, null, null, 3);
                if (fo == null) {
                    this.errorPoints += 1.0;
                    ++this.errorCounter;
                }
            }
            int max = Math.max(csoq.length(), asoq.length());
            SubOperation cso = null;
            SubOperation aso = null;
            subopnr = -1;
            int i = 0;
            while (i < max) {
                FeedbackObject fo;
                ++subopnr;
                cso = null;
                aso = null;
                int r = 1;
                if (i < csoq.length()) {
                    cso = csoq.get(i);
                    r = (Integer)this.ratings.get(cso.getID());
                    this.maxPoints += (double)r;
                }
                if (i < asoq.length()) {
                    aso = asoq.get(i);
                    if (cso == null || !cso.equals(aso)) {
                        ++allErrorCounter;
                        fo = this.check(opnr, subopnr, cso, aso, 2);
                        if (fo == null) {
                            this.errorPoints += (double)r * 1.0;
                            ++this.errorCounter;
                        }
                    }
                } else {
                    ++allErrorCounter;
                    fo = this.check(opnr, subopnr, cso, aso, 3);
                    if (fo == null) {
                        this.errorPoints += (double)r * 1.0;
                        ++this.errorCounter;
                    }
                }
                ++i;
            }
        }
        Enumeration en = this.falseFeedbackObjects.elements();
        while (en.hasMoreElements()) {
            FeedbackObject fo = (FeedbackObject)en.nextElement();
            switch (fo.getCorrectness()) {
                case 3: {
                    this.errorPoints += 1.0;
                    ++this.errorCounter;
                    break;
                }
                case 1: 
                case 2: {
                    SubOperation cso = fo.getCorrectSubOperation();
                    int r = 1;
                    if (cso != null) {
                        r = (Integer)this.ratings.get(cso.getID());
                    }
                    this.errorPoints += (double)r * 1.0;
                    ++this.errorCounter;
                    break;
                }
            }
        }
        this.selfCorrectedErrorCounter = this.errorCounter - allErrorCounter;
        if (this.errorPoints > this.maxPoints) {
            this.errorPoints = this.maxPoints;
        }
    }

    private FeedbackObject check(int opnr, int subopnr, SubOperation cso, SubOperation aso, int correctness) {
        FeedbackObject fo = new FeedbackObject();
        fo.setOpNr(opnr);
        fo.setSubOpNr(subopnr);
        fo.setCorrectSubOperation(cso);
        fo.setSubOperation(aso);
        fo.setCorrectness(correctness);
        int index = this.falseFeedbackObjects.indexOf(fo);
        if (index < 0) {
            return null;
        }
        return (FeedbackObject)this.falseFeedbackObjects.elementAt(index);
    }

    public String getHTMLMessage() {
        this.percent = this.doubleRound((this.maxPoints - this.errorPoints) / this.maxPoints * 100.0);
        String msg = "";
        msg = String.valueOf(msg) + "<table width=100%><tr><td>Score:</td><td align=right>";
        msg = String.valueOf(msg) + "<big><b>" + this.percent + "</b></big> of 100";
        msg = String.valueOf(msg) + "</td></tr></table>";
        msg = String.valueOf(msg) + "<hr>";
        msg = String.valueOf(msg) + "You have made " + this.errorCounter + " errors.<br>";
        msg = String.valueOf(msg) + this.selfCorrectedErrorCounter + " errors of them you have corrected by your own.<br>";
        msg = String.valueOf(msg) + this.doubleRound(this.maxPoints) + " are the maximal reachable points in this exercise.<br>";
        msg = String.valueOf(msg) + "You have reached " + this.doubleRound(this.maxPoints - this.errorPoints) + " points.<br>";
        return msg;
    }

    public HashMap save() {
        HashMap<String, Vector> hm = new HashMap<String, Vector>();
        hm.put("FalseFeedbackObjects", this.saveFeedbackObjects(this.falseFeedbackObjects));
        return hm;
    }

    public void load(HashMap hm) {
        this.falseFeedbackObjects = this.loadFeedbackObjects((Vector)hm.get("FalseFeedbackObjects"));
    }
}

