/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import java.util.HashMap;
import mauda.ExerciseUpdateEvent;
import mauda.Failure;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.plugin.KBFormulaEvaluator;

public class ErrorFlagging
extends SimpleFeedback {
    private static final int type = 1;
    private static final String specialGetNext = "Get next ...";
    private static final String specialFinishOp = "Finish Operation ...";
    private static final String specialFinishEx = "Finish exercise ...";

    public ErrorFlagging(FeedbackExercise exercise) {
        super(exercise);
        this.specialState = specialGetNext;
    }

    protected void jumpEvent(int delta) {
        super.jumpEvent(delta);
        this.updateBackForwardButtons();
        if (this.counter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + so.out());
            if (so instanceof SubOperation) {
                msg = this.makeNextLink(msg);
                this.displayMessage("FEEDBACK", msg);
                this.setSpecialButtonText(specialFinishOp);
                this.specialState = specialFinishOp;
                this.updateBackForwardButtons();
                FeedbackObject fo = this.callKB();
            } else if (so instanceof Operation) {
                this.displayMessage("FEEDBACK", msg);
                this.setSpecialButtonText(specialFinishOp);
                this.specialState = specialGetNext;
                --this.todoPosition;
                --this.counter;
                this.doInteractiveEvent();
            }
            this.exercise.setInteractiveMode(1);
        } else {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
            this.displayMessage("FEEDBACK", msg);
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
            this.exercise.setInteractiveMode(3);
        }
        this.updateTaskMessage();
    }

    protected void specialPressed() {
        String msg = null;
        if (this.specialState == specialGetNext) {
            if (this.todoPosition >= 0) {
                this.checkForFailure();
            }
            Operation op = (Operation)this.todoOperationQueue.get(this.todoPosition + 1).clone();
            op.setExecution(false);
            msg = SimpleFeedback.feedbackGenerator.genMessage("explanation.gif", "Perform the SubOperations for:");
            msg = String.valueOf(msg) + "<ul><li><b>" + op.out() + "</b></li></ul>" + "by pressing the right mouse button in the drawing-area, and selecting the correct suboperation." + "<br><br>" + "When you have finished all suboperations, please click the <b><i>" + specialFinishOp + "</i></b> button.";
            this.displayMessage("FEEDBACK", msg);
            this.exercise.commit(op);
            this.setSpecialButtonText(specialFinishOp);
            this.exercise.setInteractiveMode(1);
            this.exercise.getTreeOperationView().enableJumping();
            return;
        }
        if (this.specialState == specialFinishEx) {
            this.finishedExercise();
            return;
        }
        this.finishSwitch();
    }

    protected void demandPressed() {
    }

    protected void forwardPressed() {
        this.exercise.forward();
    }

    protected void backPressed() {
        Object actop = this.exercise.getOperationRecorder().getCurrentOperation();
        if (this.specialState == specialGetNext || this.specialState == specialFinishEx) {
            this.setSpecialButtonText(specialFinishOp);
            this.specialState = specialFinishOp;
            this.exercise.setInteractiveMode(1);
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> Finish Operation ...");
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
            this.updateBackForwardButtons();
            this.callKB();
            return;
        }
        this.exercise.back();
    }

    protected void forwardEvent() {
        ++this.counter;
        super.forwardEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
        }
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SimpleOperation)o).out());
        msg = this.makeNextLink(msg);
        this.displayMessage("FEEDBACK", msg);
    }

    protected void backEvent() {
        --this.counter;
        super.backEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getNextOperation();
        if (o instanceof Operation) {
            --this.todoPosition;
        }
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> " + ((SimpleOperation)o).out());
        msg = this.makeNextLink(msg);
        this.displayMessage("FEEDBACK", msg);
    }

    protected void interactiveEvent() {
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            this.updateTaskMessage();
            this.specialState = specialFinishOp;
            return;
        }
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Execute</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
        if (this.differentOperation) {
            this.cutFirstFailureFeedbackObjects();
            this.checkForFailure();
        }
    }

    private void finishSwitch() {
        OperationRecorder or = this.exercise.getOperationRecorder();
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 3);
        this.exercise.sendExerciseUpdateMessages(eue);
        this.exercise.getTreeOperationView().markCorrectness(true, true);
        this.exercise.setInteractiveMode(3);
        String msg = "";
        int opnr = or.getCurrentOperationNr();
        Failure f = or.getLimitedFailure(or.getOffset(opnr, -1));
        if (f != null && f.getDescription() == 1) {
            KBFormulaEvaluator kbfe = SimpleFeedback.feedbackGenerator.getKBFormulaEvaluator();
            kbfe.setFinishOperationState(true);
            FeedbackObject fo = this.callKB();
            kbfe.setFinishOperationState(false);
            msg = fo.getNextMessage();
            msg = String.valueOf(msg) + "<p>If you want you can press <i><b>Back</b></i> and perform the missing suboperations.</p>";
            this.evaluator.log(this.currentFeedbackObject);
        } else if (f == null || f.getOffset() > or.getCurrentOffset() + 1) {
            msg = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "<b>Well done.</b>", null, "You have performed all SubOperations correctly.");
        } else {
            FeedbackObject fo = null;
            if (this.firstFailureFeedbackObjects.size() > this.todoPosition) {
                fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(this.todoPosition);
            }
            msg = fo.getNextMessage();
            this.currentFeedbackObject = fo;
            msg = String.valueOf(msg) + "<p>If you want you can press <i><b>Back</b></i> and correct the errors.</p>";
        }
        if (this.todoPosition == this.todoOperationQueue.length() - 1) {
            msg = String.valueOf(msg) + "<p>Press <b><i>Finish exercise ...</i></b> to complete the exercise.</p>";
            this.setSpecialButtonText(specialFinishEx);
            this.specialState = specialFinishEx;
        } else {
            msg = String.valueOf(msg) + "<p>Press <b><i>Get next ...</i></b> to process the next Operation.</p>";
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
        }
        this.displayMessage("FEEDBACK", msg);
        this.setBackEnabled(true);
        this.setFeedbackBound();
    }

    protected void finishedLoading() {
        super.finishedLoading();
        String msg = this.genOpToPerformMessage();
        msg = String.valueOf(msg) + this.getFeedbackDescription();
        msg = String.valueOf(msg) + "<br>";
        msg = String.valueOf(msg) + "To perform the first operation, please click the <b><i>'Get next ...'</i></b> button below.";
        this.displayMessage("TASK", msg);
        this.setSpecialButtonText(specialGetNext);
        this.setSpecialEnabled(true);
    }

    protected String getFeedbackDescription() {
        return "Errors will be reported after pressing <i>Finish Operation ...</i> but not corrected.";
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
    }

    public int getFeedbackTypeID() {
        return 1;
    }

    public HashMap save() {
        HashMap hm = super.save();
        return hm;
    }

    public void load(HashMap hm) {
        super.load(hm);
    }
}

