/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mauda.ExerciseUpdateEvent;
import mauda.Failure;
import mauda.OperationRecorder;
import mauda.feedback.FaultEvaluator;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.treeoperationview.TreeOperationView;

public class FaultFeedback
extends SimpleFeedback {
    private static final int type = 4;
    private static final boolean playWholeExercise = true;
    private boolean playing;
    private Vector tries_vector;
    private SimpleOperation nextCorrect;
    private boolean makeRightMode;
    private int interactiveEditPos;
    private boolean backMessage;
    private static final String specialStart = "Start ...";
    private static final String specialThisIsIncorrect = "This Operation is incorrect ...";
    private static final String specialPerform = "Perform correct Operation...";
    private HashMap failureTypes;
    private Vector operations;
    private boolean stateConfigurated;

    public FaultFeedback(FeedbackExercise exercise) {
        super(exercise);
        this.setBackButtonText("Back");
        this.setForwardButtonText("Forward");
        this.failureTypes = new HashMap();
        this.failureTypes.put("missing", "All SubOperations correct, but missing some SubOperations for <i>OPERATION</i>.");
        this.failureTypes.put("different", "The false SubOperation differs from the correct one.");
        this.failureTypes.put("additionalfalse", "All correct, but additional false SubOperations, what means that all false SubOperations unnecessary for <i>OPERATION</i>");
        this.makeRightMode = false;
        this.backMessage = true;
        this.tries_vector = new Vector();
        this.nextCorrect = null;
        this.stateConfigurated = true;
    }

    private String genFailureTypesList() {
        Operation op;
        String msg = "";
        Iterator it = this.failureTypes.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.failureTypes.get(key);
            msg = String.valueOf(msg) + "<li><a href='" + key + "'>" + value + "</a></li>";
        }
        OperationRecorder or = this.exercise.getOperationRecorder();
        int opnr = or.getCurrentOperationNr();
        if (or.getCurrentOperation() instanceof Operation) {
            --opnr;
        }
        if ((op = or.getOperation(opnr)) != null) {
            msg = msg.replaceAll("OPERATION", op.out());
        }
        return msg;
    }

    protected void jumpEvent(int delta) {
        this.counter += delta;
        String msg = "";
        if (this.counter >= 0) {
            SimpleOperation o = (SimpleOperation)this.exercise.getOperationRecorder().getCurrentOperation();
            msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + o.out());
        } else {
            msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
        }
        if (!this.makeRightMode) {
            this.displayMessage("FEEDBACK", msg);
        }
        this.updateBackForwardButtons();
        this.checkEditable();
    }

    protected void specialPressed() {
        if (this.specialState == specialStart) {
            this.setSpecialButtonText(specialThisIsIncorrect);
            this.specialState = specialThisIsIncorrect;
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Playing exericse...</b>");
            this.displayMessage("FEEDBACK", msg);
            this.playing = true;
            this.setSpecialEnabled(false);
            this.setGiveUpEnabled(false);
            this.exercise.commit(this.operations);
        } else if (this.specialState == specialThisIsIncorrect) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            Failure f = or.getUnlimitedFailure(0);
            String falseNotFirst = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "This operation is false, but it is not the first failure in Exercise!");
            falseNotFirst = this.makeNextLink(falseNotFirst);
            String yesFirst = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "Yes, this is the first incorrect operation!", "explanation.gif", "Please specify the type of the failure:");
            yesFirst = String.valueOf(yesFirst) + this.genFailureTypesList();
            String noCorrect = SimpleFeedback.feedbackGenerator.genMessage("incorrect_x.gif", "No, this is correct!");
            noCorrect = this.makeNextLink(noCorrect);
            this.callKB();
            int currentOffset = or.getCurrentOffset();
            TreeOperationView tov = this.exercise.getTreeOperationView();
            if (f != null && currentOffset == f.getOffset()) {
                this.exercise.getTreeOperationView().disableJumping();
                this.setBackEnabled(false);
                this.setForwardEnabled(false);
                this.setSpecialEnabled(false);
                int opnr = or.getCurrentOperationNr();
                if (f.getDescription() == 1) {
                    --opnr;
                }
                this.displayMessage("FEEDBACK", yesFirst);
                tov.markCorrectness(false, true);
                this.evaluator.log(1);
            } else if (f != null && f.containsOffset(currentOffset)) {
                this.evaluator.log(3);
                this.evaluator.log(this.currentFeedbackObject);
                this.displayMessage("FEEDBACK", falseNotFirst);
                tov.markActAsIncorrect();
            } else {
                int opnr = or.getCurrentOperationNr();
                f = or.getUnlimitedFailure(or.getOffset(opnr, -1));
                if (f != null && f.containsOffset(currentOffset)) {
                    this.displayMessage("FEEDBACK", falseNotFirst);
                    tov.markActAsIncorrect();
                    this.evaluator.log(3);
                } else {
                    this.displayMessage("FEEDBACK", noCorrect);
                    tov.markActAsCorrect();
                    this.evaluator.log(2);
                }
                this.evaluator.log(this.currentFeedbackObject);
            }
        } else if (this.specialState == specialPerform) {
            this.makeRightMode = true;
            this.exercise.commit(this.nextCorrect);
        }
    }

    protected void demandPressed() {
    }

    protected void backPressed() {
        this.exercise.back();
    }

    protected void forwardPressed() {
        if (this.makeRightMode) {
            this.exercise.forward();
            return;
        }
        if (this.counter >= this.operations.size()) {
            return;
        }
        this.exercise.commit((SimpleOperation)this.operations.elementAt(this.counter + 1));
    }

    protected void backEvent() {
        super.backEvent();
        --this.counter;
        this.checkEditable();
        if (!this.makeRightMode) {
            if (this.backMessage) {
                SimpleOperation o = (SimpleOperation)this.exercise.getOperationRecorder().getCurrentOperation();
                String msg = "";
                msg = o != null ? SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> to " + o.out()) : SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> to beginning");
                this.displayMessage("FEEDBACK", msg);
            } else {
                this.backMessage = true;
            }
        }
        this.updateBackForwardButtons();
    }

    protected void forwardEvent() {
        super.forwardEvent();
        ++this.counter;
        this.checkEditable();
        this.updateBackForwardButtons();
    }

    protected void interactiveEvent() {
        if (this.makeRightMode) {
            this.checkEditable();
            if (!(this.differentOperation || this.counter > this.interactiveEditPos && this.counter + 1 <= this.interactiveEditPos)) {
                return;
            }
            OperationRecorder or = this.exercise.getOperationRecorder();
            Failure f = or.getUnlimitedFailure(0);
            int currentOffset = or.getCurrentOffset();
            if (f == null || f.getOffset() > currentOffset) {
                this.finishedExercise();
            } else {
                SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
                if (this.tries_vector.contains(so)) {
                    String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "This Operation (" + so.out() + ") you already tried, and it was incorrect!");
                    this.displayMessage("FEEDBACK", msg);
                    this.backMessage = false;
                    this.exercise.back();
                    return;
                }
                this.tries_vector.add(so);
                if (this.tries_vector.size() >= 3) {
                    int opnr = or.getCurrentOperationNr();
                    int subopnr = or.getCurrentSubOperationNr();
                    this.nextCorrect = or.getCorrectSubOperation(opnr, subopnr);
                    String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "You have tried this operation for 3 times,and it was allways incorrect.", "lamp.gif", "The correct Operation is<br><i>" + this.nextCorrect.out() + "</i>");
                    msg = String.valueOf(msg) + "<p>Press <b><i>Perform correct Operation...</i></b> to perform this correct operation.</p>";
                    this.displayMessage("FEEDBACK", msg);
                    this.setBackEnabled(false);
                    this.setForwardEnabled(false);
                    this.setSpecialEnabled(true);
                    this.exercise.setInteractiveMode(3);
                    this.setSpecialButtonText(specialPerform);
                    this.specialState = specialPerform;
                    TreeOperationView tov = this.exercise.getTreeOperationView();
                    tov.markCorrectness(true, true);
                    tov.disableJumping();
                    this.callKB();
                    this.evaluator.log(this.currentFeedbackObject);
                    this.makeRightMode = false;
                    this.backMessage = false;
                    this.exercise.back();
                } else {
                    FeedbackObject fo = this.callKB();
                    this.displayMessage("FEEDBACK", fo.getNextMessage());
                    TreeOperationView tov = this.exercise.getTreeOperationView();
                    tov.markCorrectness(true, true);
                    this.evaluator.log(this.currentFeedbackObject);
                    this.backMessage = false;
                    this.exercise.back();
                }
            }
            return;
        }
        if (this.playing) {
            if (this.counter == this.operations.size() - 1) {
                this.setSpecialEnabled(true);
                this.setGiveUpEnabled(true);
                this.updateBackForwardButtons();
                this.playing = false;
                String msg = this.genOpToPerformFalseMessage();
                msg = String.valueOf(msg) + "You have to press <b><i>This Operation is incorrect ...</b></i> when you think the actual Operation is false.";
                this.displayMessage("TASK", msg);
                msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "Exercise completly played.", null, "Now you can navigate throug the exericse by clicking the back- and forward-buttons, or jumping directly to an operation by clicking it below.");
                this.displayMessage("FEEDBACK", msg);
                this.exercise.getTreeOperationView().enableJumping();
                this.exercise.getTreeOperationView().enableStop();
            }
        } else {
            SimpleOperation o = (SimpleOperation)this.exercise.getOperationRecorder().getCurrentOperation();
            String msg = "";
            msg = this.counter == 0 ? "<b>Start</b> with " + o.out() : "<b>Forward</b> to " + o.out();
            msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", msg);
            this.displayMessage("FEEDBACK", msg);
            this.updateBackForwardButtons();
        }
    }

    private void checkEditable() {
        if (this.makeRightMode) {
            if (this.counter == this.interactiveEditPos) {
                this.exercise.setInteractiveMode(1);
            } else {
                this.exercise.setInteractiveMode(3);
            }
        }
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
        Failure f = this.exercise.getOperationRecorder().getUnlimitedFailure(0);
        if (href.equals("missing")) {
            if (f.getDescription() != 1) {
                this.falseType(href);
            } else {
                this.correctType(href);
            }
        } else if (href.equals("different")) {
            if (f.getDescription() != 0) {
                this.falseType(href);
            } else {
                this.correctType(href);
            }
        } else if (href.equals("additionalfalse")) {
            if (f.getDescription() != 2) {
                this.falseType(href);
            } else {
                this.correctType(href);
            }
        }
    }

    private void correctType(String type) {
        this.exercise.getTreeOperationView().enableJumping();
        if (type.equals("missing") || type.equals("different")) {
            String msg = this.genOpToPerformFalseMessage();
            msg = String.valueOf(msg) + "You have to specify the correct SubOperation by pressing the right mouse-button in the drawing pane at the location of the failure.";
            this.displayMessage("TASK", msg);
            SimpleOperation falseOp = (SimpleOperation)this.exercise.getOperationRecorder().getCurrentOperation();
            msg = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "<b>Correct</b>", null, "Please specify the correct SubOperation by pressing the right mouse-button in the drawing pane.<br><br>That means you must replace the false operation <i>" + falseOp.out() + "</i>!");
            this.displayMessage("FEEDBACK", msg);
            this.makeRightMode = true;
            if (this.stateConfigurated) {
                this.interactiveEditPos = this.counter - 1;
                this.backMessage = false;
                this.exercise.back();
            } else {
                this.interactiveEditPos = this.counter;
            }
            this.exercise.setInteractiveMode(1);
            this.evaluator.log(5);
        } else {
            this.finishedExercise();
        }
    }

    private void falseType(String type) {
        this.failureTypes.remove(type);
        String msg = "";
        msg = this.failureTypes.size() == 1 ? SimpleFeedback.feedbackGenerator.genMessage("incorrect_x.gif", "No this is the false type!", "lamp.gif", "The correct type is the following (please click it to proceed):") : SimpleFeedback.feedbackGenerator.genMessage("incorrect_x.gif", "No this is the false type. Try it again!", "explanation.gif", "Please specify the type of the failure:");
        msg = String.valueOf(msg) + this.genFailureTypesList();
        this.displayMessage("FEEDBACK", msg);
        this.evaluator.log(4);
    }

    public void setTodoOperationQueue(OperationQueue oq) {
        super.setTodoOperationQueue(oq);
        this.operations = new Vector();
        int i = 0;
        while (i < oq.length()) {
            Operation op = (Operation)oq.get(i).clone();
            this.operations.add(op);
            SubOperationQueue soq = op.getSubOperationQueue();
            int j = 0;
            while (j < soq.length()) {
                this.operations.add((SubOperation)soq.get(j).clone());
                ++j;
            }
            ++i;
        }
        this.evaluator.postProcessing(this.operations);
    }

    protected void finishedLoading() {
        super.finishedLoading();
        String msg = this.genOpToPerformFalseMessage();
        msg = String.valueOf(msg) + "To play the whole exericse now, please click the <b><i>'Start ...'</i></b> button below.";
        this.displayMessage("TASK", msg);
        this.setSpecialButtonText(specialStart);
        this.setSpecialEnabled(true);
        this.specialState = specialStart;
    }

    protected String getFeedbackDescription() {
        return "";
    }

    public int getFeedbackTypeID() {
        return 4;
    }

    public HashMap save() {
        HashMap hm = super.save();
        Vector<String> v = new Vector<String>();
        Enumeration en = this.tries_vector.elements();
        while (en.hasMoreElements()) {
            SimpleOperation so = (SimpleOperation)en.nextElement();
            if (so instanceof Operation) {
                v.add("OPERATION " + so.save());
                continue;
            }
            if (!(so instanceof SubOperation)) continue;
            v.add("SUBOPERATION " + so.save());
        }
        hm.put("tries_vector", v);
        if (this.nextCorrect == null) {
            hm.put("nextCorrect", "NULL");
        } else if (this.nextCorrect instanceof Operation) {
            hm.put("nextCorrect", "OPERATION " + this.nextCorrect.save());
        } else if (this.nextCorrect instanceof SubOperation) {
            hm.put("nextCorrect", "SUBOPERATION " + this.nextCorrect.save());
        }
        hm.put("makeRightMode", new Boolean(this.makeRightMode));
        hm.put("interactiveEditPos", new Integer(this.interactiveEditPos));
        hm.put("failureTypes", this.failureTypes);
        return hm;
    }

    public void load(HashMap hm) {
        String s;
        super.load(hm);
        Vector<ExerciseUpdateEvent> v = (Vector<ExerciseUpdateEvent>)hm.get("tries_vector");
        this.tries_vector.removeAllElements();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            if (s.startsWith("OPERATION ")) {
                Operation op = new Operation();
                op.load(s.substring(10));
                this.tries_vector.add(op);
                continue;
            }
            if (!s.startsWith("SUBOPERATION ")) continue;
            SubOperation subop = new SubOperation();
            subop.load(s.substring(13));
            this.tries_vector.add(subop);
        }
        s = (String)hm.get("nextCorrect");
        if (s.equals("NULL")) {
            this.nextCorrect = null;
        } else if (s.startsWith("OPERATION ")) {
            this.nextCorrect = new Operation();
            this.nextCorrect.load(s.substring(10));
        } else if (s.startsWith("SUBOPERATION")) {
            this.nextCorrect = new SubOperation();
            this.nextCorrect.load(s.substring(13));
        }
        this.makeRightMode = (Boolean)hm.get("makeRightMode");
        this.interactiveEditPos = (Integer)hm.get("interactiveEditPos");
        this.failureTypes = (HashMap)hm.get("failureTypes");
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, -1);
        eue.setMessage("FAULT_STATE-CONFIG");
        v = new Vector<ExerciseUpdateEvent>();
        v.add(eue);
        this.exercise.commit(v);
        this.stateConfigurated = false;
    }

    public void stateConfig() {
        switch (((FaultEvaluator)this.evaluator).getState()) {
            case 0: {
                if (this.counter < 0) break;
                this.setSpecialButtonText(specialThisIsIncorrect);
                this.specialState = specialThisIsIncorrect;
                this.exercise.getTreeOperationView().enableJumping();
                String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "You have to search the first failure!");
                this.displayMessage("FEEDBACK", msg);
                this.exercise.getTreeOperationView().enableStop();
                break;
            }
            case 2: 
            case 3: {
                this.exercise.getTreeOperationView().enableJumping();
                this.exercise.getTreeOperationView().enableStop();
                this.setSpecialButtonText(specialThisIsIncorrect);
                this.specialState = specialThisIsIncorrect;
                String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "You have to search the first failure!");
                this.displayMessage("FEEDBACK", msg);
                break;
            }
            case 1: {
                this.exercise.getTreeOperationView().enableStop();
                this.setSpecialButtonText(specialThisIsIncorrect);
                this.specialState = specialThisIsIncorrect;
                this.specialPressed();
                break;
            }
            case 4: {
                this.exercise.getTreeOperationView().enableStop();
                this.exercise.getTreeOperationView().disableJumping();
                this.setSpecialEnabled(false);
                this.setBackEnabled(false);
                this.setForwardEnabled(false);
                this.falseType(null);
                break;
            }
            case 5: {
                this.exercise.getTreeOperationView().enableStop();
                this.exercise.getTreeOperationView().enableJumping();
                this.correctType("missing");
                if (this.tries_vector.size() < 3) break;
                SimpleOperation so = (SimpleOperation)this.tries_vector.remove(2);
                this.exercise.commit(so);
            }
        }
        this.stateConfigurated = true;
    }
}

