/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mauda.Failure;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.plugin.KBFormulaEvaluator;

public class ImmediateFeedbackAndErrorCorrection
extends SimpleFeedback {
    private static final int type = 0;
    private Vector tries_vector;
    private static final String specialGetNext = "Get next ...";
    private static final String specialFinishOp = "Finish Operation ...";
    private static final String specialFinishEx = "Finish exercise ...";
    private static final String specialPerform = "Perform correct Operation...";
    private boolean noBackEvent;
    private boolean noKBCall;
    private SimpleOperation nextCorrect;
    private int triesVectorPosition;

    public ImmediateFeedbackAndErrorCorrection(FeedbackExercise exercise) {
        super(exercise);
        this.specialState = specialGetNext;
        this.tries_vector = new Vector();
        this.feedbackBound = Integer.MAX_VALUE;
    }

    protected void jumpEvent(int delta) {
        super.jumpEvent(delta);
        this.updateBackForwardButtons();
        if (this.counter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + so.out());
            if (so instanceof SubOperation) {
                msg = this.makeNextLink(msg);
                this.displayMessage("FEEDBACK", msg);
                this.setSpecialButtonText(specialFinishOp);
                this.specialState = specialFinishOp;
                this.updateBackForwardButtons();
                FeedbackObject fo = this.callKB();
                if (fo.getCorrectness() == 2) {
                    this.noBackEvent = true;
                    this.addToTriesVector();
                    this.noKBCall = true;
                    this.exercise.back();
                }
            } else if (so instanceof Operation) {
                this.displayMessage("FEEDBACK", msg);
                this.setSpecialButtonText(specialFinishOp);
                this.specialState = specialGetNext;
                --this.todoPosition;
                --this.counter;
                this.doInteractiveEvent();
            }
            this.exercise.setInteractiveMode(1);
        } else {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
            this.displayMessage("FEEDBACK", msg);
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
            this.exercise.setInteractiveMode(3);
        }
        this.updateTaskMessage();
    }

    protected void specialPressed() {
        String msg = null;
        if (this.specialState == specialGetNext) {
            if (this.todoPosition >= 0) {
                this.checkForFailure();
            }
            Operation op = (Operation)this.todoOperationQueue.get(this.todoPosition + 1).clone();
            op.setExecution(false);
            msg = SimpleFeedback.feedbackGenerator.genMessage("explanation.gif", "Perform the SubOperations for:");
            msg = String.valueOf(msg) + "<ul><li><b>" + op.out() + "</b></li></ul>" + "by pressing the right mouse button in the drawing-area, and selecting the correct suboperation." + "<br><br>" + "When you have finished all suboperations, please click the <b><i>" + specialFinishOp + "</i></b> button.";
            this.displayMessage("FEEDBACK", msg);
            this.exercise.getTreeOperationView().markCorrectness(true, true);
            this.setSpecialButtonText(specialFinishOp);
            this.exercise.setInteractiveMode(1);
            this.exercise.getTreeOperationView().enableJumping();
            this.exercise.commit(op);
            return;
        }
        if (this.specialState == specialFinishEx) {
            this.finishedExercise();
            return;
        }
        if (this.specialState == specialPerform) {
            this.setBackEnabled(true);
            this.setForwardEnabled(true);
            this.exercise.setInteractiveMode(1);
            this.tries_vector.removeAllElements();
            if (this.nextCorrect instanceof Operation) {
                this.specialState = specialGetNext;
                this.specialPressed();
                return;
            }
            this.exercise.commit(this.nextCorrect);
            this.nextCorrect = null;
            this.setSpecialButtonText(specialFinishOp);
            this.specialState = specialFinishOp;
            this.exercise.getTreeOperationView().enableJumping();
            return;
        }
        this.finishSwitch();
    }

    protected void demandPressed() {
    }

    protected void forwardPressed() {
        this.exercise.forward();
    }

    protected void backPressed() {
        Object actop = this.exercise.getOperationRecorder().getCurrentOperation();
        if (this.specialState == specialGetNext || this.specialState == specialFinishEx) {
            this.setSpecialButtonText(specialFinishOp);
            this.specialState = specialFinishOp;
            this.exercise.setInteractiveMode(1);
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> Finish Operation ...");
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
            return;
        }
        this.exercise.back();
    }

    protected void forwardEvent() {
        ++this.counter;
        super.forwardEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((Operation)o).out());
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
        } else if (o instanceof SubOperation) {
            this.exercise.getTreeOperationView().markCorrectness(false, false);
            switch (fo.getCorrectness()) {
                case 1: {
                    String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SubOperation)o).out());
                    msg = this.makeNextLink(msg);
                    this.displayMessage("FEEDBACK", msg);
                    break;
                }
                case 2: {
                    this.noBackEvent = true;
                    this.setForwardEnabled(false);
                    if (o instanceof Operation) {
                        --this.todoPosition;
                    }
                    String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SubOperation)o).out(), null, "Because this Operation was incorrect, it was undoed.");
                    OperationRecorder or = this.exercise.getOperationRecorder();
                    Object prevop = or.getEntry(or.getOffset(or.getCurrentOperationNr(), or.getCurrentSubOperationNr()) - 1);
                    msg = this.makeNextLink(msg, prevop);
                    this.displayMessage("FEEDBACK", msg);
                    this.exercise.back();
                    break;
                }
                default: {
                    this.displayMessage("FEEDBACK", "Internal Error (redoEvent())");
                }
            }
        }
    }

    protected void backEvent() {
        --this.counter;
        if (this.noBackEvent) {
            FeedbackObject temp = this.currentFeedbackObject;
            FeedbackObject fo = this.callKB();
            if (fo.getCorrectness() == 1) {
                this.currentFeedbackObject = temp;
                if (!this.noKBCall) {
                    this.callKB();
                } else {
                    this.noKBCall = false;
                }
                this.noBackEvent = false;
                return;
            }
            OperationRecorder or = this.exercise.getOperationRecorder();
            Object o = or.getCurrentOperation();
            if (o instanceof Operation) {
                this.currentFeedbackObject = temp;
                this.noKBCall = false;
                this.noBackEvent = false;
                return;
            }
            this.noBackEvent = true;
            this.noKBCall = true;
            this.exercise.back();
            return;
        }
        super.backEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getNextOperation();
        if (o instanceof Operation) {
            --this.todoPosition;
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> " + ((Operation)o).out());
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
        } else if (o instanceof SubOperation) {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SubOperation)o).out());
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
        }
    }

    protected void interactiveEvent() {
        OperationRecorder or = this.exercise.getOperationRecorder();
        SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
        if (so instanceof Operation) {
            if (this.specialState != specialGetNext) {
                String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Execute</b> " + so.out());
                this.displayMessage("FEEDBACK", msg);
            }
            ++this.todoPosition;
            this.updateTaskMessage();
            this.specialState = specialFinishOp;
            return;
        }
        this.exercise.getTreeOperationView().markCorrectness(false, false);
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        String msg = fo.getNextMessage();
        this.displayMessage("FEEDBACK", msg);
        if (fo.getCorrectness() == 2) {
            this.noBackEvent = true;
            this.noKBCall = true;
            if (!this.addToTriesVector()) {
                this.checkMaxTries();
            }
            this.exercise.stopPlaying();
            if (this.configurated) {
                this.exercise.back();
            }
        }
        FeedbackObject temp = this.currentFeedbackObject;
        if (this.differentOperation) {
            this.cutFirstFailureFeedbackObjects();
            this.checkForFailure();
        }
        this.currentFeedbackObject = temp;
    }

    private void finishSwitch() {
        OperationRecorder or = this.exercise.getOperationRecorder();
        Failure f = or.getLimitedFailure(or.getOffset(or.getCurrentOperationNr(), -1));
        if (f != null) {
            KBFormulaEvaluator kbfe = SimpleFeedback.feedbackGenerator.getKBFormulaEvaluator();
            kbfe.setFinishOperationState(true);
            FeedbackObject fo = this.callKB();
            kbfe.setFinishOperationState(false);
            this.displayMessage("FEEDBACK", fo.getNextMessage());
            this.evaluator.log(this.currentFeedbackObject);
            return;
        }
        this.exercise.setInteractiveMode(3);
        if (this.todoPosition == this.todoOperationQueue.length() - 1) {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "<b>Well done.</b>", null, "You have performed all SubOperations correctly. Press <b><i>Finish exercise ...</i></b> to complete the exercise.");
            this.displayMessage("FEEDBACK", msg);
            this.setSpecialButtonText(specialFinishEx);
            this.specialState = specialFinishEx;
        } else {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("correct_v.gif", "<b>Well done.</b>", null, "You have performed all SubOperations correctly. Press <b><i>Get next ...</i></b> to process the next Operation.");
            this.displayMessage("FEEDBACK", msg);
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
        }
    }

    protected void finishedLoading() {
        super.finishedLoading();
        String msg = this.genOpToPerformMessage();
        msg = String.valueOf(msg) + this.getFeedbackDescription();
        msg = String.valueOf(msg) + "<br>";
        msg = String.valueOf(msg) + "To perform the first operation, please click the <b><i>'Get next ...'</i></b> button below.";
        this.displayMessage("TASK", msg);
        this.setSpecialButtonText(specialGetNext);
        this.setSpecialEnabled(true);
    }

    protected String getFeedbackDescription() {
        return "You will get an immediate feedback after every operation, and errors are automatically undoed.";
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
    }

    private boolean addToTriesVector() {
        if (this.triesVectorPosition != this.counter) {
            this.tries_vector.removeAllElements();
        }
        this.triesVectorPosition = this.counter;
        Object actop = this.exercise.getOperationRecorder().getCurrentOperation();
        SimpleOperation so = (SimpleOperation)actop;
        if (this.tries_vector.contains(so)) {
            String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "This Operation (" + so.out() + ") you already tried, and it was incorrect!");
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
            return true;
        }
        this.tries_vector.add(so);
        this.evaluator.log(this.currentFeedbackObject);
        return false;
    }

    private boolean checkMaxTries() {
        if (this.tries_vector.size() < 3) {
            return false;
        }
        this.exercise.getTreeOperationView().disableJumping();
        OperationRecorder or = this.exercise.getOperationRecorder();
        Failure f = or.getLimitedFailure(or.getOffset(or.getCurrentOperationNr(), -1));
        switch (f.getDescription()) {
            case 2: {
                Operation op = (Operation)this.todoOperationQueue.get(this.todoPosition + 1).clone();
                op.setExecution(false);
                this.nextCorrect = op;
                break;
            }
            case 0: 
            case 1: {
                SubOperation actop;
                SubOperation subop = actop = or.getCorrectSubOperation(or.getCurrentOperationNr(), or.getCurrentSubOperationNr());
                this.nextCorrect = subop;
            }
        }
        this.setSpecialButtonText(specialPerform);
        this.specialState = specialPerform;
        this.setBackEnabled(false);
        this.setForwardEnabled(false);
        this.exercise.setInteractiveMode(3);
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "You have tried this operation for different 3 times,and it was allways incorrect.", "lamp.gif", "The correct Operation is<br><i>" + this.nextCorrect.out() + "</i><br><br>" + "Press <b><i>" + specialPerform + "</i></b> to perform this correct operation.");
        msg = this.makeNextLink(msg);
        this.displayMessage("FEEDBACK", msg);
        return true;
    }

    public int getFeedbackTypeID() {
        return 0;
    }

    public HashMap save() {
        HashMap hm = super.save();
        Vector<String> v = new Vector<String>();
        Enumeration en = this.tries_vector.elements();
        while (en.hasMoreElements()) {
            SimpleOperation so = (SimpleOperation)en.nextElement();
            if (so instanceof Operation) {
                v.add("OPERATION " + so.save());
                continue;
            }
            if (!(so instanceof SubOperation)) continue;
            v.add("SUBOPERATION " + so.save());
        }
        hm.put("tries_vector", v);
        if (this.nextCorrect == null) {
            hm.put("nextCorrect", "NULL");
        } else if (this.nextCorrect instanceof Operation) {
            hm.put("nextCorrect", "OPERATION " + this.nextCorrect.save());
        } else if (this.nextCorrect instanceof SubOperation) {
            hm.put("nextCorrect", "SUBOPERATION " + this.nextCorrect.save());
        }
        return hm;
    }

    public void load(HashMap hm) {
        String s;
        super.load(hm);
        Vector v = (Vector)hm.get("tries_vector");
        this.tries_vector.removeAllElements();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            if (s.startsWith("OPERATION ")) {
                Operation op = new Operation();
                op.load(s.substring(10));
                this.tries_vector.add(op);
                continue;
            }
            if (!s.startsWith("SUBOPERATION ")) continue;
            SubOperation subop = new SubOperation();
            subop.load(s.substring(13));
            this.tries_vector.add(subop);
        }
        s = (String)hm.get("nextCorrect");
        if (s.equals("NULL")) {
            this.nextCorrect = null;
        } else if (s.startsWith("OPERATION ")) {
            this.nextCorrect = new Operation();
            this.nextCorrect.load(s.substring(10));
        } else if (s.startsWith("SUBOPERATION")) {
            this.nextCorrect = new SubOperation();
            this.nextCorrect.load(s.substring(13));
        }
        if (this.tries_vector.size() >= 3) {
            int lastIndex = this.tries_vector.size() - 1;
            SimpleOperation so = (SimpleOperation)this.tries_vector.elementAt(lastIndex);
            this.tries_vector.removeElementAt(lastIndex);
            this.exercise.commit(so);
        }
    }
}

