/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import java.util.HashMap;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;

public class NoTutor
extends SimpleFeedback {
    private static final int type = 3;
    private static final String specialGetNext = "Get next ...";
    private static final String specialFinishEx = "Finish exercise ...";

    public NoTutor(FeedbackExercise exercise) {
        super(exercise);
        this.specialState = specialGetNext;
    }

    protected void jumpEvent(int delta) {
        super.jumpEvent(delta);
        this.updateBackForwardButtons();
        String msg = "";
        if (this.counter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
            msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + so.out());
            this.exercise.setInteractiveMode(1);
        } else {
            msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
            this.exercise.setInteractiveMode(3);
        }
        this.displayMessage("FEEDBACK", msg);
        if (this.todoPosition == this.todoOperationQueue.length() - 1) {
            this.setSpecialButtonText(specialFinishEx);
            this.specialState = specialFinishEx;
        } else {
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
        }
        this.updateTaskMessage();
    }

    protected void specialPressed() {
        String msg = null;
        if (this.specialState == specialGetNext) {
            if (this.todoPosition >= 0) {
                this.checkForFailure();
            }
            this.exercise.getTreeOperationView().enableJumping();
            Operation op = (Operation)this.todoOperationQueue.get(this.todoPosition + 1).clone();
            op.setExecution(false);
            msg = SimpleFeedback.feedbackGenerator.genMessage("explanation.gif", "Perform the SubOperations for:");
            msg = String.valueOf(msg) + "<ul><li><b>" + op.out() + "</b></li></ul>" + "by pressing the right mouse button in the drawing-area, and selecting the correct suboperation." + "<br><br>";
            if (this.todoPosition + 1 == this.todoOperationQueue.length() - 1) {
                msg = String.valueOf(msg) + "When you have finished all suboperations, please click the <b><i>Finish exercise ...</i></b> button to complete the exercise.";
                this.setSpecialButtonText(specialFinishEx);
                this.specialState = specialFinishEx;
            } else {
                msg = String.valueOf(msg) + "When you have finished all suboperations, please click the <b><i>Get next ...</i></b> button.";
                this.setSpecialButtonText(specialGetNext);
            }
            this.displayMessage("FEEDBACK", msg);
            this.exercise.commit(op);
            this.exercise.setInteractiveMode(1);
            return;
        }
        if (this.specialState == specialFinishEx) {
            this.finishedExercise();
            return;
        }
    }

    protected void demandPressed() {
    }

    protected void forwardPressed() {
        this.exercise.forward();
    }

    protected void backPressed() {
        this.exercise.back();
    }

    protected void forwardEvent() {
        ++this.counter;
        super.forwardEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            if (this.todoPosition == this.todoOperationQueue.length() - 1) {
                this.setSpecialButtonText(specialFinishEx);
                this.specialState = specialFinishEx;
            }
        }
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
    }

    protected void backEvent() {
        --this.counter;
        super.backEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getNextOperation();
        if (o instanceof Operation) {
            --this.todoPosition;
            if (this.todoPosition < this.todoOperationQueue.length() - 1) {
                this.setSpecialButtonText(specialGetNext);
                this.specialState = specialGetNext;
            }
        }
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Back</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
    }

    protected void interactiveEvent() {
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            this.updateTaskMessage();
            this.updateBackForwardButtons();
            return;
        }
        this.updateBackForwardButtons();
        String msg = SimpleFeedback.feedbackGenerator.genMessage("information.gif", "<b>Execute</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
        if (this.differentOperation) {
            this.cutFirstFailureFeedbackObjects();
            this.checkForFailure();
        }
    }

    protected void finishedLoading() {
        super.finishedLoading();
        String msg = this.genOpToPerformMessage();
        msg = String.valueOf(msg) + this.getFeedbackDescription();
        msg = String.valueOf(msg) + "<br>";
        msg = String.valueOf(msg) + "To perform the first operation, please click the <b><i>'Get next ...'</i></b> button below.";
        this.displayMessage("TASK", msg);
        this.setSpecialButtonText(specialGetNext);
        this.setSpecialEnabled(true);
    }

    protected String getFeedbackDescription() {
        return "You will get no feedback.";
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
    }

    public int getFeedbackTypeID() {
        return 3;
    }

    public HashMap save() {
        HashMap hm = super.save();
        return hm;
    }

    public void load(HashMap hm) {
        super.load(hm);
    }
}

