/*
 * Decompiled with CFR 0.152.
 */
package mauda.jedasnew;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.Timer;
import jedas.Jedas;
import jedas.io.RecordPanel;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;

public class RecordFrame
extends JFrame
implements ActionListener {
    private Exercise exercise;
    private JButton pauseButton;
    private boolean pause;
    private Timer timer;
    private boolean highlight;
    private Color blinkColor1 = new Color(170, 170, 170);
    private Color blinkColor2 = new Color(255, 160, 160);

    public RecordFrame() {
        super("Record");
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        RecordPanel recordPanel = new RecordPanel();
        contentPane.add((Component)recordPanel, "Center");
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(this);
        contentPane.add((Component)this.pauseButton, "South");
        this.setBounds(0, 0, 133, 120);
        this.setVisible(true);
        this.pause = false;
        this.exercise = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pauseButton) {
            boolean bl = this.pause = !this.pause;
            if (this.pause) {
                this.suspendRecording();
            } else {
                this.resumeRecording();
            }
        } else if (this.timer != null && e.getSource() == this.timer) {
            if (this.highlight) {
                this.pauseButton.setBackground(this.blinkColor1);
            } else {
                this.pauseButton.setBackground(this.blinkColor2);
            }
            this.highlight = !this.highlight;
        }
    }

    public void setExercise(Exercise exercise) {
        this.exercise = exercise;
    }

    public void suspendRecording() {
        Jedas.getScheduler().suspend();
        if (this.exercise != null) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 15);
            this.exercise.sendExerciseUpdateMessages(eue);
        }
        this.highlight = true;
        this.pauseButton.setBackground(this.blinkColor2);
        this.timer = new Timer(500, this);
        this.timer.start();
    }

    public void resumeRecording() {
        if (this.exercise != null) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 16);
            this.exercise.sendExerciseUpdateMessages(eue);
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.pauseButton.setBackground(null);
        Jedas.getScheduler().resume();
    }
}

