/*
 * Decompiled with CFR 0.152.
 */
package mauda.operation;

import java.util.StringTokenizer;
import mauda.SimpleExercise;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;

public class Operation
extends SimpleOperation
implements Comparable {
    public static final int SORT_BY_RATING = 0;
    public static final int SORT_BY_NAME = 1;
    private static int sortmode = 0;
    private int rating;
    private int effect;
    private boolean execute = true;
    private SubOperationQueue subOperations;

    public Operation() {
        super(null, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.rating = Integer.MIN_VALUE;
        this.effect = Integer.MIN_VALUE;
        this.execute = true;
    }

    public Operation(String id) {
        super(id, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.rating = Integer.MIN_VALUE;
        this.effect = Integer.MIN_VALUE;
        this.execute = true;
        this.subOperations = new SubOperationQueue();
    }

    public Operation(String id, int param1, int param2, int rating) {
        super(id, param1, param2);
        this.rating = rating;
        this.effect = Integer.MIN_VALUE;
        this.execute = true;
        this.subOperations = new SubOperationQueue();
    }

    public void setExecution(boolean execute) {
        this.execute = execute;
    }

    public boolean isExecuted() {
        return this.execute;
    }

    public void setEffect(int effect) {
        this.effect = effect;
    }

    public static void setSort(int mode) {
        sortmode = mode;
    }

    public int compareTo(Object o) {
        if (sortmode == 0) {
            return this.rating - ((Operation)o).getRating();
        }
        if (sortmode == 1) {
            return this.toString().compareTo(((Operation)o).toString());
        }
        return 0;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int r) {
        this.rating = r;
    }

    public SubOperationQueue getSubOperationQueue() {
        return this.subOperations;
    }

    public void setSubOperationQueue(SubOperationQueue so) {
        this.subOperations = so;
    }

    public void add(SubOperation so) {
        this.subOperations.add(so);
    }

    public boolean equals(Object o) {
        SimpleOperation op = (SimpleOperation)o;
        if (op instanceof SubOperation) {
            return super.equals(op);
        }
        Operation operation = (Operation)op;
        return operation.isExecuted() == this.execute && super.equals(op);
    }

    public void execute(Object o) {
        if (!this.execute) {
            SimpleExercise.getOperationExecuter().executeTemplate(this, o);
            return;
        }
        SimpleExercise.getOperationExecuter().execute(this, o);
    }

    public Object clone() {
        Operation op = new Operation(this.id, this.param1, this.param2, this.rating);
        op.setEffect(this.effect);
        op.setExecution(this.execute);
        op.subOperations = this.subOperations != null ? (SubOperationQueue)this.subOperations.clone() : null;
        return op;
    }

    public String save() {
        String s = this.id;
        if (this.param1 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + this.param1;
        }
        if (this.param2 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + this.param2;
        }
        s = this.execute ? String.valueOf(s) + " EXECUTE" : String.valueOf(s) + " TEMPLATE";
        return s;
    }

    public void load(String opString) {
        String s;
        this.id = null;
        this.param1 = Integer.MIN_VALUE;
        this.param2 = Integer.MIN_VALUE;
        this.effect = Integer.MIN_VALUE;
        this.rating = Integer.MIN_VALUE;
        this.execute = true;
        StringTokenizer st = new StringTokenizer(opString);
        this.id = s = st.nextToken();
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.equals("EXECUTE")) {
                this.execute = true;
                return;
            }
            if (s.equals("TEMPLATE")) {
                this.execute = false;
                return;
            }
            this.param1 = Integer.parseInt(s);
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.equals("EXECUTE")) {
                this.execute = true;
                return;
            }
            if (s.equals("TEMPLATE")) {
                this.execute = false;
                return;
            }
            this.param2 = Integer.parseInt(s);
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.equals("EXECUTE")) {
                this.execute = true;
                return;
            }
            if (s.equals("TEMPLATE")) {
                this.execute = false;
                return;
            }
        }
    }

    public String toString() {
        if (this.param1 == Integer.MIN_VALUE && this.param2 == Integer.MIN_VALUE && this.effect == Integer.MIN_VALUE && this.rating == Integer.MIN_VALUE) {
            return this.id;
        }
        String s = this.id;
        if (this.param1 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + (this.param1 < 10 ? " " : "") + this.param1;
        }
        if (this.param2 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + (this.param2 < 10 ? " " : "") + this.param2;
        }
        if (this.effect != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " (" + (this.effect < 10 ? " " : "") + this.effect + ")";
        }
        if (!this.execute) {
            return String.valueOf(s) + " (Template)";
        }
        return String.valueOf(s) + " -> " + this.rating;
    }

    public String out() {
        String s = this.id;
        if (this.param1 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + (this.param1 < 10 ? " " : "") + this.param1;
        }
        if (this.param2 != Integer.MIN_VALUE) {
            s = String.valueOf(s) + " " + (this.param2 < 10 ? " " : "") + this.param2;
        }
        return s;
    }
}

