/*
 * Decompiled with CFR 0.152.
 */
package mauda.operation;

import java.util.Enumeration;
import java.util.Vector;
import mauda.operation.Operation;
import mauda.operation.SubOperationQueue;

public class OperationQueue
implements Comparable {
    private Vector operations = new Vector();
    private int rating = 0;
    private int permCounter;
    private OperationQueue[] permOQ;

    public void add(String id) {
        this.operations.add(new Operation(id));
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.rating += operation.getRating();
    }

    public void addAll(OperationQueue o) {
        this.operations.addAll(o.operations);
        this.rating += o.getRating();
    }

    public Operation get(int index) {
        return (Operation)this.operations.elementAt(index);
    }

    public void set(int index, Operation op) {
        this.rating -= ((Operation)this.operations.elementAt(index)).getRating();
        this.operations.setElementAt(op, index);
        this.rating += op.getRating();
    }

    public void remove(int index) {
        this.rating -= ((Operation)this.operations.elementAt(index)).getRating();
        this.operations.removeElementAt(index);
    }

    public void shuffle() {
        int l = this.operations.size();
        int i = 0;
        while (i < 10) {
            int i2;
            int i1 = (int)(Math.random() * (double)l);
            if (i1 != (i2 = (int)(Math.random() * (double)l))) {
                Object temp = this.operations.elementAt(i1);
                this.operations.setElementAt(this.operations.elementAt(i2), i1);
                this.operations.setElementAt(temp, i2);
            }
            ++i;
        }
    }

    public void shuffleDelmin() {
        this.shuffle();
        int l = this.operations.size();
        if (l > 4) {
            int delminIndex = -1;
            int i = l - 1;
            while (i >= 0) {
                Operation op = (Operation)this.operations.elementAt(i);
                if (op.getID().equals("DELETE_MIN")) {
                    delminIndex = i;
                    break;
                }
                --i;
            }
            if (delminIndex >= 0 && delminIndex < l - 4) {
                Object temp = this.operations.elementAt(l - 4);
                this.operations.setElementAt(this.operations.elementAt(delminIndex), l - 4);
                this.operations.setElementAt(temp, delminIndex);
            }
        }
    }

    public OperationQueue[] getPermutations() {
        int permSize = 1;
        int i = 2;
        while (i <= this.length()) {
            permSize *= i;
            ++i;
        }
        this.permOQ = new OperationQueue[permSize];
        this.permCounter = 0;
        this.permut(0, this.length() - 1);
        return this.permOQ;
    }

    private void permut(int d, int n) {
        Operation h = this.get(d);
        int i = d;
        while (i <= n) {
            this.set(d, this.get(i));
            this.set(i, h);
            if (d < n) {
                this.permut(d + 1, n);
            } else {
                OperationQueue oq = new OperationQueue();
                int j = 0;
                while (j <= i) {
                    oq.add(this.get(j));
                    ++j;
                }
                this.permOQ[this.permCounter] = oq;
                ++this.permCounter;
            }
            this.set(i, this.get(d));
            ++i;
        }
        this.set(d, h);
    }

    public Operation[] toArray() {
        Operation[] ops = new Operation[this.length()];
        this.operations.toArray(ops);
        return ops;
    }

    public Vector toVector() {
        return this.operations;
    }

    public int length() {
        return this.operations.size();
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public int compareTo(Object o) {
        return this.rating - ((OperationQueue)o).getRating();
    }

    public Object clone() {
        OperationQueue oq = new OperationQueue();
        Enumeration en = this.operations.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            oq.add((Operation)op.clone());
        }
        oq.setRating(this.rating);
        return oq;
    }

    public String toString() {
        String s = "";
        Enumeration en = this.operations.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            s = String.valueOf(s) + op + " | ";
        }
        s = String.valueOf(s) + " Rating = " + this.rating;
        return s;
    }

    public void execute(Object o) {
        Enumeration en = this.operations.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            op.execute(o);
        }
    }

    public Vector save() {
        Vector vector = new Vector();
        Enumeration en = this.toVector().elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            Vector<Object> v = new Vector<Object>();
            v.add(op.save());
            v.add(op.getSubOperationQueue().save());
            vector.add(v);
        }
        return vector;
    }

    public void load(Vector vector) {
        this.operations = new Vector();
        this.rating = 0;
        Enumeration en = vector.elements();
        while (en.hasMoreElements()) {
            Vector v = (Vector)en.nextElement();
            String s = (String)v.elementAt(0);
            Operation op = new Operation();
            op.load(s);
            SubOperationQueue soq = new SubOperationQueue();
            soq.load((Vector)v.elementAt(1));
            op.setSubOperationQueue(soq);
            this.operations.add(op);
        }
    }
}

