/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.binqueue;

import java.awt.Color;
import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import jedas.TextObj;
import mauda.operation.SubOperation;
import mauda.plugin.fibheap.FibHeap;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibNode;

public class BinQueue
extends FibHeapExt {
    private TextObj[] message;
    private DPair[] messagePos;
    private Color[] messageColor;

    public BinQueue() {
        FibHeap.setTextMode(0);
        FibHeap.showArray = false;
        this.minPointer.setColor(Color.white);
        this.minPointer.setArrowFillColor(Color.white);
        this.messagePos = new DPair[3];
        this.messagePos[0] = new DPair(0.5, 0.85);
        this.messagePos[1] = new DPair(0.5, 0.9);
        this.messagePos[2] = new DPair(0.5, 0.95);
        this.messageColor = new Color[3];
        this.messageColor[0] = Color.RED;
        this.messageColor[1] = Color.BLUE;
        this.messageColor[2] = Color.BLACK;
        this.message = new TextObj[3];
        int i = 0;
        while (i < 3) {
            this.message[i] = new TextObj("", this.messagePos[i], 14, 0, 0, this.messageColor[i]);
            this.mainCompObj.addItem((Item)this.message[i]);
            ++i;
        }
    }

    public FibNode insert(int k) {
        this.showMessage("Insert(" + k + ")", 1);
        FibNode newFibNode = super.insert(k);
        this.consolidate();
        this.resetMin();
        return newFibNode;
    }

    public FibNode findmin() {
        FibNode temp = this.min.getRightSibling();
        FibNode last = this.min;
        while (temp != last) {
            if (temp.getKey() < this.min.getKey()) {
                this.min = temp;
            }
            temp = temp.getRightSibling();
        }
        this.showMessage("Minimum key is " + this.min.getKey(), 2);
        return this.min;
    }

    public int deletemin() {
        this.showMessage("Delete_Min()", 0);
        return this.delete(this.findmin());
    }

    public int delete(FibNode node) {
        this.showMessage("Delete(" + node.getKey() + ")", 1);
        this.cutTree(node);
        this.remove(node);
        this.consolidate();
        this.resetMin();
        return node.getKey();
    }

    public void decreasekey(FibNode FibNode2, int k) {
        this.hideMessage();
        this.showMessage("Decrease key " + FibNode2.getKey() + " to " + k, 0);
        this.delete(FibNode2);
        this.insert(k);
    }

    void cutTree(FibNode node) {
        this.resetMin();
        if (!node.isRoot()) {
            this.cutTree(node.getParentNode());
        }
        FibNode temp = node.getRightSibling();
        while (node.isLeftOf(temp)) {
            FibNode it = temp;
            temp = temp.getRightSibling();
            if (it.getKey() != it.getRoot().getKey()) {
                this.add(new SubOperation("CUT", it.getKey()));
            }
            it.cut(it.getRoot());
            this.animate();
            this.resetMin();
        }
        if (node.getKey() != node.getRoot().getKey()) {
            this.add(new SubOperation("CUT", node.getKey()));
        }
        node.cut(node.getRoot());
        this.animate();
        this.resetMin();
    }

    void resetMin() {
        this.min = this.getLeftmostNode().getLeftSibling();
    }

    void showMessage(String text, int level) {
        this.message[level].setText(text);
        this.message[level].setVisible(true);
        Jedas.updateDisplay();
    }

    void hideMessage() {
        this.message[0].setText("");
        this.message[1].setText("");
        this.message[2].setText("");
        Jedas.updateDisplay();
    }
}

