/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.util.StringTokenizer;
import mauda.Exercise;
import mauda.plugin.KBFormulaEvaluator;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibNode;
import mauda.undoredo.UndoRedo;

public class FibHeapKBFormulaEvaluator
extends KBFormulaEvaluator {
    public FibHeapKBFormulaEvaluator(Exercise exercise) {
        super(exercise);
    }

    public String getSpecialConstant(String sc) {
        StringTokenizer st = new StringTokenizer(sc, ".");
        String[] tokens = new String[st.countTokens()];
        int counter = 0;
        while (st.hasMoreTokens()) {
            tokens[counter++] = st.nextToken();
        }
        UndoRedo ur = this.exercise.getUndoRedo();
        String filledConstant = "";
        int i = 0;
        String token = tokens[i];
        if (token.matches("\\d+\\[\\d+\\]")) {
            FibNode node;
            int nodenr = Integer.parseInt(token.substring(0, token.indexOf("[")));
            int offset = this.getPositionNr(0, token);
            Object dsObject = ur.getEntry(offset);
            FibHeapExt fibHeap = (FibHeapExt)dsObject;
            FibNode[] fibNodes = fibHeap.getAllNodes();
            while (true) {
                if (++i >= tokens.length) {
                    return String.valueOf(nodenr);
                }
                String command = tokens[i].toLowerCase();
                node = fibNodes[nodenr];
                if (node == null) {
                    return null;
                }
                if (command.equals("pre")) {
                    if (--offset < 0) {
                        return null;
                    }
                    dsObject = ur.getEntry(offset);
                    fibHeap = (FibHeapExt)dsObject;
                    fibNodes = fibHeap.getAllNodes();
                    continue;
                }
                if (command.equals("parent")) {
                    if (node.isRoot()) {
                        return null;
                    }
                    nodenr = node.parent.getKey();
                    continue;
                }
                if (command.equals("child")) {
                    if (node.getRank() == 0) {
                        return null;
                    }
                    nodenr = node.child.getKey();
                    continue;
                }
                if (command.equals("left")) {
                    if (node.getSibling() == node) {
                        return null;
                    }
                    nodenr = node.left.getKey();
                    continue;
                }
                if (command.equals("right")) {
                    if (node.getSibling() == node) {
                        return null;
                    }
                    nodenr = node.right.getKey();
                    continue;
                }
                if (command.equals("ismarked")) {
                    if (node.isMarked()) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                if (command.equals("rank")) {
                    return String.valueOf(node.getRank());
                }
                if (command.equals("isroot")) break;
            }
            if (node.isRoot()) {
                return "TRUE";
            }
            return "FALSE";
        }
        if (token.equals("min")) {
            Object dsObject = ur.getDSObject();
            FibHeapExt fibHeap = (FibHeapExt)dsObject;
            FibNode[] fibNodes = fibHeap.getAllNodes();
            int j = 0;
            while (j < fibNodes.length && fibNodes[j] == null) {
                ++j;
            }
            return String.valueOf(j);
        }
        return sc;
    }
}

