/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

public class FibNodeDS {
    FibNodeDS left;
    FibNodeDS right;
    FibNodeDS parent;
    FibNodeDS child;
    private int key;
    private int rank;
    private boolean mark;

    public FibNodeDS(int key) {
        this.key = key;
        this.left = this.right = this;
    }

    FibNodeDS() {
        this.key = 0;
        this.left = this.right = this;
    }

    void setParameters(int key, int rank, boolean mark, FibNodeDS parent, FibNodeDS child, FibNodeDS left, FibNodeDS right) {
        this.key = key;
        this.rank = rank;
        this.mark = mark;
        this.parent = parent;
        this.child = child;
        this.left = left;
        this.right = right;
    }

    public FibNodeDS getParentNode() {
        if (this.isRoot()) {
            return null;
        }
        return this.parent;
    }

    public FibNodeDS getChildNode() {
        return this.child;
    }

    public FibNodeDS getSibling() {
        if (this.right == this) {
            return null;
        }
        return this.right;
    }

    public FibNodeDS getRightSibling() {
        return this.right;
    }

    public FibNodeDS getLeftSibling() {
        return this.left;
    }

    public int getRank() {
        return this.rank;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int k) {
        this.key = k;
    }

    public boolean isRoot() {
        return this.parent == null || this.parent.child == null;
    }

    public boolean hasChildren() {
        return this.rank > 0;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void mark() {
        if (!this.mark) {
            this.mark = true;
        }
    }

    public void unmark() {
        if (this.mark) {
            this.mark = false;
        }
    }

    public void addChild(FibNodeDS newChild) {
        newChild.separate(false);
        newChild.parent = this;
        if (this.hasChildren()) {
            this.child.left.join(newChild, false);
        } else {
            this.child = newChild;
        }
        ++this.rank;
    }

    public void cut(FibNodeDS target) {
        if (!this.isRoot()) {
            boolean isOnlyChild = this.parent.rank == 1 && this.getTreeWidth() == 1;
            this.separate(!isOnlyChild);
            target.join(this, isOnlyChild);
        }
    }

    private void separate(boolean thereIsGap) {
        if (!this.isRoot()) {
            --this.parent.rank;
            if (!this.parent.hasChildren()) {
                this.parent.child = null;
            } else if (this.parent.child == this) {
                this.parent.child = this.right;
            }
        }
        this.left.right = this.right;
        this.right.left = this.left;
        this.left = this;
        this.right = this;
        this.parent = null;
    }

    public void join(FibNodeDS other, boolean spaceNeeded) {
        this.right.left = other.left;
        other.left.right = this.right;
        this.right = other;
        other.left = this;
    }

    public void delete() {
        if (this.isRoot()) {
            if (this.hasChildren()) {
                if (this.left != this) {
                    this.left.right = this.child;
                    this.right.left = this.child.left;
                    this.child.left.right = this.right;
                    this.child.left = this.left;
                    this.left = this.right = this;
                }
            } else {
                this.separate(true);
            }
            this.child = null;
        }
    }

    public int getTreeWidth() {
        int width = 1;
        if (this.child != null) {
            FibNodeDS temp = this.child.right;
            width = this.child.getTreeWidth();
            while (temp != this.child) {
                width += temp.getTreeWidth();
                temp = temp.right;
            }
        }
        return width;
    }

    private int getListWidth() {
        int width = 0;
        FibNodeDS temp = this;
        do {
            width += temp.getTreeWidth();
            temp = temp.right;
        } while (temp.right != this);
        return width;
    }

    private FibNodeDS[] getChildlist() {
        if (!this.hasChildren()) {
            return null;
        }
        FibNodeDS[] childlist = new FibNodeDS[this.rank];
        FibNodeDS temp = this.child;
        int i = 0;
        while (i < this.rank) {
            childlist[i] = temp;
            temp = temp.right;
            ++i;
        }
        return childlist;
    }

    public int getTreeDepth() {
        if (this.child == null) {
            return 1;
        }
        int depth = 0;
        FibNodeDS temp = this.child;
        do {
            if (temp.getTreeDepth() <= depth) continue;
            depth = temp.getTreeDepth();
        } while ((temp = temp.right) != this.child);
        return depth + 1;
    }

    public int getTreeSize() {
        int size = 1;
        if (this.hasChildren()) {
            FibNodeDS temp = this.child;
            do {
                size += temp.getTreeSize();
            } while ((temp = temp.right) != this.child);
        }
        return size;
    }

    public int getDepth() {
        int depth = 1;
        FibNodeDS temp = this;
        while (!temp.isRoot()) {
            ++depth;
            temp = temp.parent;
        }
        return depth;
    }

    public FibNodeDS getRoot() {
        FibNodeDS temp = this;
        while (!temp.isRoot()) {
            temp = temp.parent;
        }
        return temp;
    }

    public Object clone() {
        FibNodeDS newFibNode = new FibNodeDS(this.getKey());
        newFibNode.setParameters(this.getKey(), this.getRank(), this.isMarked(), null, null, null, null);
        return newFibNode;
    }
}

