/*
 * Decompiled with CFR 0.152.
 */
package mauda.treeoperationview;

import javax.swing.tree.DefaultMutableTreeNode;
import mauda.operation.SimpleOperation;
import mauda.treeoperationview.TreeOperationView;

public class TreeObject {
    public static final int UNDEFINED = 0;
    public static final int CORRECT = 1;
    public static final int INCORRECT = 2;
    public static int initialCorrectness = 0;
    private int correctness;
    private boolean actual = false;
    private boolean processing = false;
    private String text;
    private SimpleOperation simpleOperation;
    private DefaultMutableTreeNode node;
    private int state = 0;
    public static final int NORMAL = 0;
    public static final int INIT = 1;
    public static final int TODO = 2;

    public TreeObject(SimpleOperation so) {
        this.simpleOperation = so;
        this.correctness = initialCorrectness;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setNode(DefaultMutableTreeNode n) {
        this.node = n;
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public void setState(int s) {
        this.state = s;
    }

    public int getState() {
        return this.state;
    }

    public String toString() {
        String t = "The Exercise";
        if (this.simpleOperation != null) {
            switch (TreeOperationView.DISPLAY_MODE) {
                case 0: {
                    t = this.simpleOperation.out();
                    break;
                }
                case 1: {
                    t = "" + this.simpleOperation;
                }
            }
        }
        switch (this.state) {
            case 0: {
                if (this.isActual()) {
                    t = "<html><b>" + t + "</b></html>";
                    break;
                }
                if (!this.isProcessing()) break;
                t = "<html><b><i>" + t + "</i></b></html>";
                break;
            }
            case 1: {
                if (this.isActual()) {
                    t = "<html><b color=#66aa66>" + t + "</b></html>";
                    break;
                }
                if (this.isProcessing()) {
                    t = "<html><b color=#66aa66><i>" + t + "</i></b></html>";
                    break;
                }
                t = "<html><font color=#66aa66>" + t + "</font></html>";
                break;
            }
            case 2: {
                t = this.isActual() ? "<html><b color=#000000>" + t + "</b></html>" : (this.isProcessing() ? "<html><b color=#000000><i>" + t + "</i></b></html>" : "<html><font color=#000000>" + t + "</font></html>");
            }
        }
        return t;
    }

    public SimpleOperation getOperation() {
        return this.simpleOperation;
    }

    public void setActual(boolean b) {
        this.actual = b;
    }

    public boolean isActual() {
        return this.actual;
    }

    public void setProcessing(boolean b) {
        this.processing = b;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setCorrectness(int c) {
        this.correctness = c;
    }

    public int getCorrectness() {
        return this.correctness;
    }
}

