/*
 * Decompiled with CFR 0.152.
 */
package mauda.treeoperationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.Failure;
import mauda.OperationRecorder;
import mauda.images.ImageHandler;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.treeoperationview.MyTreeCellRenderer;
import mauda.treeoperationview.NodePopup;
import mauda.treeoperationview.TreeObject;
import mauda.undoredo.UndoRedoElement;
import mauda.undoredo.UndoRedoInfo;
import mauda.undoredo.UndoRedoUnit;

public class TreeOperationView
implements ExerciseUpdateListener,
MouseListener,
ActionListener {
    public static final int NORMAL_DISPLAY_MODE = 0;
    public static final int GENERATION_DISPLAY_MODE = 1;
    public static int DISPLAY_MODE = 0;
    private Exercise exercise;
    private JPopupMenu popupMenu;
    private DefaultMutableTreeNode currentTreeNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    protected static final String rootNodeText = "The Exercise";
    private DefaultMutableTreeNode rootNode;
    private UndoRedoInfo undoRedoInfo;
    private Vector treeObjects;
    private static final String play = "Play";
    private static final String stop = "Stop";
    private static final String back = "Back";
    private static final String forward = "Forward";
    private JPanel panel;
    private boolean finishedLoading;
    private boolean finishedLoadingMessage;
    private int position;
    private boolean jumping;
    private boolean stopPossible;
    private DefaultMutableTreeNode oldActualNode = null;

    public TreeOperationView(Exercise exercise) {
        this.exercise = exercise;
        this.finishedLoading = false;
        this.finishedLoadingMessage = true;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        TreeObject to = new TreeObject(null);
        to.setText(rootNodeText);
        this.rootNode = new DefaultMutableTreeNode(to);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(this);
        this.panel.add((Component)new JScrollPane(this.tree), "Center");
        JButton playButton = new JButton(ImageHandler.createImageIcon("Play16.gif"));
        playButton.addActionListener(this);
        playButton.setActionCommand(play);
        JButton stopButton = new JButton(ImageHandler.createImageIcon("Stop16.gif"));
        stopButton.addActionListener(this);
        stopButton.setActionCommand(stop);
        JButton backButton = new JButton(ImageHandler.createImageIcon("StepBack16.gif"));
        backButton.addActionListener(this);
        backButton.setActionCommand(back);
        JButton forwardButton = new JButton(ImageHandler.createImageIcon("StepForward16.gif"));
        forwardButton.addActionListener(this);
        forwardButton.setActionCommand(forward);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4));
        buttonPanel.add(playButton);
        buttonPanel.add(stopButton);
        buttonPanel.add(backButton);
        buttonPanel.add(forwardButton);
        this.panel.add((Component)buttonPanel, "South");
        this.undoRedoInfo = new UndoRedoInfo();
        this.position = -1;
        this.treeObjects = new Vector();
        this.jumping = false;
        this.popupMenu = new NodePopup(this);
        this.currentTreeNode = null;
        this.stopPossible = false;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void enableJumping() {
        this.jumping = true;
    }

    public void disableJumping() {
        this.jumping = false;
    }

    public void noFinishedLoadingMessage() {
        this.finishedLoadingMessage = false;
        this.finishedLoading = true;
    }

    public void markTodoPosition() {
        int todoPosition = this.exercise.getOperationRecorder().getTodoPosition();
        int i = 0;
        while (i < this.treeObjects.size()) {
            TreeObject to = (TreeObject)this.treeObjects.elementAt(i);
            if (i < todoPosition && to.getState() != 1) {
                to.setState(1);
                this.treeModel.reload(to.getNode());
            } else if (i >= todoPosition && to.getState() != 2) {
                to.setState(2);
                this.treeModel.reload(to.getNode());
            }
            ++i;
        }
    }

    public NodePopup getNodePopup() {
        return (NodePopup)this.popupMenu;
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 4) {
            this.finishedLoading = true;
            return;
        }
        if (!this.finishedLoading) {
            return;
        }
        if (e.getID() == 3) {
            UndoRedoUnit uru = this.cutTree();
            this.undoRedoInfo.addUnit(uru);
            return;
        }
        if (e.getID() == 14) {
            int p = this.position + 1;
            DefaultMutableTreeNode node = null;
            if (p == -1) {
                node = this.rootNode;
            }
            if (p < this.treeObjects.size()) {
                TreeObject to = (TreeObject)this.treeObjects.elementAt(p);
                node = to.getNode();
            }
            if (node != null) {
                this.makeActualProcessing(node);
            }
        }
        if (!e.dsChanged()) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                this.interactiveEvent(e.getOperation());
                break;
            }
            case 7: {
                --this.position;
                this.makeActual(this.getActNode());
                break;
            }
            case 8: {
                ++this.position;
                this.makeActual(this.getActNode());
                break;
            }
            case 18: {
                this.undo();
                break;
            }
            case 19: {
                this.redo();
                break;
            }
            case 10: {
                while (this.rootNode.getChildCount() > 0) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.rootNode.getChildAt(0));
                }
                this.treeModel.reload();
                this.finishedLoading = false;
                this.stopPossible = false;
                if (!this.finishedLoadingMessage) {
                    this.finishedLoading = true;
                    this.stopPossible = true;
                }
                this.position = -1;
                this.treeObjects.removeAllElements();
                this.undoRedoInfo.clear(new Vector());
                break;
            }
            case 12: {
                this.position += e.getValue();
                this.makeActual(this.getActNode());
                break;
            }
        }
    }

    private void undo() {
        UndoRedoUnit uru = this.undoRedoInfo.undo(this.treeObjects);
        this.performGraphicalChange(uru);
    }

    private void redo() {
        UndoRedoUnit uru = this.undoRedoInfo.redo(this.treeObjects);
        this.performGraphicalChange(uru);
    }

    private void performGraphicalChange(UndoRedoUnit uru) {
        Enumeration en = uru.getElements().elements();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node;
            UndoRedoElement ure = (UndoRedoElement)en.nextElement();
            int p = ure.getPos();
            TreeObject to = (TreeObject)ure.getObj();
            int id = ure.getID();
            if (id == 0) {
                this.treeModel.removeNodeFromParent(to.getNode());
                continue;
            }
            if (id != 1) continue;
            DefaultMutableTreeNode newNode = to.getNode();
            int childindex = 0;
            if (to.getOperation() instanceof Operation) {
                node = this.rootNode;
                childindex = node.getChildCount();
            } else {
                node = (DefaultMutableTreeNode)this.rootNode.getChildAt(this.rootNode.getChildCount() - 1);
                childindex = node.getChildCount();
            }
            this.treeModel.insertNodeInto(newNode, node, childindex);
            if (this.tree.isExpanded(0)) continue;
            this.tree.expandRow(0);
        }
    }

    private void interactiveEvent(SimpleOperation op) {
        DefaultMutableTreeNode node;
        SimpleOperation o;
        TreeObject to;
        if (op != null && this.position < this.treeObjects.size() - 1 && (to = (TreeObject)this.treeObjects.elementAt(this.position + 1)) != null && (o = to.getOperation()).equals(op)) {
            ++this.position;
            this.makeActual(to.getNode());
            return;
        }
        UndoRedoUnit uru = this.cutTree();
        ++this.position;
        TreeObject newTO = new TreeObject(op);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newTO);
        newTO.setNode(newNode);
        if (op instanceof Operation) {
            node = this.rootNode;
        } else {
            TreeObject to2 = (TreeObject)this.treeObjects.lastElement();
            node = to2.getNode();
            if (to2.getOperation() instanceof SubOperation) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
        }
        this.treeModel.insertNodeInto(newNode, node, node.getChildCount());
        this.makeActual(newNode);
        this.treeObjects.add(newTO);
        uru.addElement(new UndoRedoElement(this.position, newTO, 1));
        this.undoRedoInfo.addUnit(uru);
    }

    public UndoRedoUnit cutTree() {
        UndoRedoUnit uru = new UndoRedoUnit();
        int cutPosition = this.position + 1;
        int i = this.treeObjects.size() - 1;
        while (i >= cutPosition) {
            TreeObject to = (TreeObject)this.treeObjects.elementAt(i);
            this.treeModel.removeNodeFromParent(to.getNode());
            this.treeObjects.removeElementAt(i);
            UndoRedoElement ure = new UndoRedoElement(i, to, 0);
            uru.addElement(ure);
            --i;
        }
        return uru;
    }

    public void makeActual(DefaultMutableTreeNode node) {
        TreeObject to;
        if (this.oldActualNode != null) {
            to = (TreeObject)this.oldActualNode.getUserObject();
            to.setActual(false);
            to.setProcessing(false);
            this.updateNodeDisplay(this.oldActualNode);
        }
        if (node != null) {
            to = (TreeObject)node.getUserObject();
            to.setActual(true);
            to.setProcessing(false);
            this.updateNodeDisplay(node);
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
        }
        this.oldActualNode = node;
    }

    public void makeActualProcessing(DefaultMutableTreeNode node) {
        TreeObject to;
        if (this.oldActualNode != null) {
            to = (TreeObject)this.oldActualNode.getUserObject();
            to.setActual(false);
            to.setProcessing(false);
            this.updateNodeDisplay(this.oldActualNode);
        }
        if (node != null) {
            to = (TreeObject)node.getUserObject();
            to.setActual(false);
            to.setProcessing(true);
            this.updateNodeDisplay(node);
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
        }
        this.oldActualNode = node;
    }

    private void updateNodeDisplay(DefaultMutableTreeNode node) {
        this.treeModel.nodeChanged(node);
    }

    private DefaultMutableTreeNode getActNode() {
        if (this.position == -1) {
            return this.rootNode;
        }
        TreeObject to = (TreeObject)this.treeObjects.elementAt(this.position);
        return to.getNode();
    }

    private Vector genJumpTo(DefaultMutableTreeNode n) {
        TreeObject to = (TreeObject)n.getUserObject();
        int offset = this.treeObjects.indexOf(to);
        if (offset == -1 && this.position == -1) {
            return new Vector();
        }
        OperationRecorder or = this.exercise.getOperationRecorder();
        int delta = offset + or.getOffset(0, -1) - or.getCurrentOffset();
        Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
        if (delta != 0) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 12);
            eue.setValue(delta);
            v.add(eue);
            return v;
        }
        return v;
    }

    public void markCorrectness(boolean limited, boolean folderMark) {
        OperationRecorder or = this.exercise.getOperationRecorder();
        int orOffset = or.getOffset(0, -1);
        int c = 0;
        int startOffset = 0;
        int endOffset = 0;
        boolean stop = false;
        TreeObject to = null;
        int opOffset = -1;
        while (true) {
            Failure f = null;
            f = limited ? or.getLimitedFailure(c + orOffset) : or.getUnlimitedFailure(c + orOffset);
            if (f != null) {
                startOffset = f.getOffset() - orOffset;
                endOffset = f.getMaxOffset() - orOffset;
                if (f.getDescription() == 1) {
                    --endOffset;
                }
                opOffset = or.getOffset(f.getOpNr(), -1) - orOffset;
            } else {
                startOffset = this.treeObjects.size();
                endOffset = startOffset - 1;
                stop = true;
            }
            if (startOffset >= this.treeObjects.size()) {
                startOffset = this.treeObjects.size();
            }
            if (endOffset >= this.treeObjects.size()) {
                endOffset = this.treeObjects.size() - 1;
                stop = true;
            }
            int i = c;
            while (i < startOffset) {
                to = (TreeObject)this.treeObjects.elementAt(i);
                if (i == opOffset) {
                    if (folderMark) {
                        this.markCorrectness(to.getNode(), 2);
                    }
                } else if (folderMark || to.getOperation() instanceof SubOperation) {
                    this.markCorrectness(to.getNode(), 1);
                }
                ++i;
            }
            i = startOffset;
            while (i <= endOffset) {
                to = (TreeObject)this.treeObjects.elementAt(i);
                this.markCorrectness(to.getNode(), 2);
                ++i;
            }
            if (stop) {
                return;
            }
            c = endOffset + 1;
        }
    }

    public void markActAsCorrect() {
        this.markCorrectness(this.getActNode(), 1);
    }

    public void markActAsIncorrect() {
        this.markCorrectness(this.getActNode(), 2);
    }

    public void markAsCorrect(int index) {
        TreeObject to = (TreeObject)this.treeObjects.elementAt(index);
        this.markCorrectness(to.getNode(), 1);
    }

    public void markAsIncorrect(int index) {
        TreeObject to = (TreeObject)this.treeObjects.elementAt(index);
        this.markCorrectness(to.getNode(), 2);
    }

    private void markCorrectness(DefaultMutableTreeNode node, int c) {
        if (node == null) {
            return;
        }
        TreeObject to = (TreeObject)node.getUserObject();
        if (to.getCorrectness() != c) {
            to.setCorrectness(c);
            this.treeModel.reload(node);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        Vector v;
        DefaultMutableTreeNode tn;
        int y;
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        int x = e.getX();
        TreePath path = this.tree.getPathForLocation(x, y = e.getY());
        if (path == null) {
            return;
        }
        this.currentTreeNode = tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (e.isPopupTrigger()) {
            this.popupMenu.show(this.tree, x, y);
        } else if (this.jumping && (v = this.genJumpTo(this.currentTreeNode)).size() > 0) {
            this.exercise.commit(v);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void enableStop() {
        this.stopPossible = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.finishedLoading) {
            return;
        }
        String command = e.getActionCommand();
        if (command == stop && this.stopPossible) {
            this.exercise.stopPlaying();
        }
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        if (command == "Replay from here") {
            if (this.jumping) {
                Vector exOps = this.genJumpTo(this.currentTreeNode);
                TreeObject to = (TreeObject)this.currentTreeNode.getUserObject();
                int index = this.treeObjects.indexOf(to);
                int i = index + 1;
                while (i < this.treeObjects.size()) {
                    to = (TreeObject)this.treeObjects.elementAt(i);
                    SimpleOperation so = to.getOperation();
                    exOps.add(so.clone());
                    ++i;
                }
                if (exOps.size() > 0) {
                    this.exercise.jedasPanel.nextNoProgressBar();
                    this.exercise.commit(exOps);
                }
            }
        } else if (command == "Jump to here") {
            Vector v;
            if (this.jumping && (v = this.genJumpTo(this.currentTreeNode)).size() > 0) {
                this.exercise.commit(v);
            }
        } else if (command == play) {
            if (this.jumping) {
                Vector<Object> exOps = new Vector<Object>();
                int i = this.position + 1;
                while (i < this.treeObjects.size()) {
                    TreeObject to = (TreeObject)this.treeObjects.elementAt(i);
                    SimpleOperation so = to.getOperation();
                    exOps.add(so.clone());
                    ++i;
                }
                if (exOps.size() > 0) {
                    this.exercise.jedasPanel.nextNoProgressBar();
                    this.exercise.commit(exOps);
                }
            }
        } else if (command == back) {
            if (this.position >= 0 && this.jumping) {
                this.exercise.back();
            }
        } else if (command == forward && this.position < this.treeObjects.size() - 1 && this.jumping) {
            this.exercise.forward();
        }
    }

    public int getActionIndex() {
        TreeObject to = (TreeObject)this.currentTreeNode.getUserObject();
        return this.treeObjects.indexOf(to);
    }

    public Vector save() {
        Vector<Integer> v = new Vector<Integer>();
        Enumeration en = this.treeObjects.elements();
        while (en.hasMoreElements()) {
            TreeObject to = (TreeObject)en.nextElement();
            v.add(new Integer(to.getCorrectness()));
        }
        return v;
    }

    public void load(Vector v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            int c = (Integer)v.elementAt(i);
            TreeObject to = (TreeObject)this.treeObjects.elementAt(i);
            this.markCorrectness(to.getNode(), c);
            ++i;
        }
    }
}

