/*
 * Decompiled with CFR 0.152.
 */
package mauda.undoredo;

import java.util.Vector;
import jedas.CompPanel;
import jedas.Item;
import jedas.Jedas;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.plugin.Copyable;
import mauda.plugin.JedasMainCompObj;
import mauda.undoredo.UndoRedoInfo;
import mauda.undoredo.UndoRedoUnit;

public class UndoRedo
implements ExerciseUpdateListener {
    protected UndoRedoInfo undoRedoInfo;
    protected Exercise exercise;
    protected CompPanel compPanel;
    protected Object dsObject;
    protected Vector vector;
    protected int position = -1;
    protected int minPosition = 0;

    public UndoRedo(Exercise exercise) {
        this.exercise = exercise;
        this.compPanel = Exercise.compPanel;
        this.undoRedoInfo = new UndoRedoInfo();
        this.vector = new Vector();
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 7) {
            this.back();
            e.getExercise().setDSObject(this.getDSObject());
        } else if (e.getID() == 8) {
            this.forward();
            e.getExercise().setDSObject(this.getDSObject());
        } else if (e.getID() == 9) {
            this.forward();
        } else if (e.getID() == 18) {
            this.undo();
        } else if (e.getID() == 19) {
            this.redo();
        } else if (e.getID() == 0) {
            this.snapshot(e.getOperation());
        } else if (e.getID() == 10) {
            this.clear();
            e.getExercise().setDSObject(this.getDSObject());
        } else if (e.getID() == 2) {
            this.clearPreceding();
        } else if (e.getID() == 3) {
            this.clearFollowing();
        } else if (e.getID() == 12) {
            this.position += e.getValue();
            this.compPanel.clear();
            this.dsObject = ((Copyable)this.vector.elementAt(this.position)).deepCopy();
            this.compPanel.addItem((Item)((JedasMainCompObj)this.dsObject).getMainCompObj());
            Jedas.updateDisplay();
            e.getExercise().setDSObject(this.dsObject);
        }
    }

    public void initialSnapshot(Object o) {
        this.snapshot(o);
    }

    protected void snapshot(Object o) {
        int counter = this.compPanel.getItemCount();
        Item item = this.compPanel.getFirstItem();
        ++this.position;
        this.undoRedoInfo.storeChange(this.position, this.vector, ((Copyable)this.exercise.getDSObject()).deepCopy());
    }

    public boolean canBack() {
        return this.position > this.minPosition;
    }

    public boolean canForward() {
        return this.position < this.vector.size() - 1;
    }

    public boolean canUndo() {
        return this.position >= this.minPosition && this.undoRedoInfo.canUndo();
    }

    public boolean canRedo() {
        return this.undoRedoInfo.canRedo();
    }

    public int getUndoJumpDelta() {
        int p = this.undoRedoInfo.getUndoJumpPosition();
        return p - this.position;
    }

    public int getRedoJumpDelta() {
        int p = this.undoRedoInfo.getRedoJumpPosition();
        return p - (this.position + 1);
    }

    protected void back() {
        if (!this.canBack()) {
            return;
        }
        --this.position;
        this.compPanel.clear();
        this.dsObject = ((Copyable)this.vector.elementAt(this.position)).deepCopy();
        this.compPanel.addItem((Item)((JedasMainCompObj)this.dsObject).getMainCompObj());
        Jedas.updateDisplay();
    }

    protected void forward() {
        if (!this.canForward()) {
            return;
        }
        ++this.position;
        this.compPanel.clear();
        this.dsObject = ((Copyable)this.vector.elementAt(this.position)).deepCopy();
        this.compPanel.addItem((Item)((JedasMainCompObj)this.dsObject).getMainCompObj());
        Jedas.updateDisplay();
    }

    protected void undo() {
        UndoRedoUnit uru = this.undoRedoInfo.undo(this.vector);
    }

    protected void redo() {
        UndoRedoUnit uru = this.undoRedoInfo.redo(this.vector);
    }

    public void clear() {
        this.minPosition = 0;
        this.position = 1;
        this.back();
        Object o = this.vector.elementAt(0);
        Vector newv = new Vector();
        newv.add(o);
        this.undoRedoInfo.clear(newv);
        this.vector.removeAllElements();
        this.vector.addAll(newv);
    }

    protected void clearPreceding() {
        this.position = 1;
        Object o = this.vector.elementAt(0);
        Object o2 = this.vector.lastElement();
        Vector newv = new Vector();
        newv.add(o);
        newv.add(o2);
        this.undoRedoInfo.clear(newv);
        this.vector.removeAllElements();
        this.vector.addAll(newv);
        this.minPosition = 1;
    }

    protected void clearFollowing() {
        this.undoRedoInfo.clearFollowing(this.position + 1, this.vector);
    }

    public Object getDSObject() {
        return this.dsObject;
    }

    public String toString() {
        return "#Entries: " + this.vector.size() + "\n" + "Position: " + this.position + "\n";
    }

    public Object getEntry(int offset) {
        return this.vector.elementAt(offset + 1);
    }
}

