/*
 * Decompiled with CFR 0.152.
 */
package mauda.undoredo;

import java.util.Vector;
import mauda.undoredo.UndoRedoElement;
import mauda.undoredo.UndoRedoUnit;

public class UndoRedoInfo {
    public boolean DEBUG = false;
    private int position = -1;
    private Vector units = new Vector();

    public void storeChange(int p, Vector v, Object newObject) {
        UndoRedoElement ure;
        UndoRedoUnit uru = new UndoRedoUnit();
        int i = v.size() - 1;
        while (i >= p) {
            Object o = v.elementAt(i);
            ure = new UndoRedoElement(i, o, 0);
            uru.addElement(ure);
            v.removeElementAt(i);
            --i;
        }
        ure = new UndoRedoElement(p, newObject, 1);
        uru.addElement(ure);
        v.add(newObject);
        this.addUnit(uru);
        if (this.DEBUG) {
            System.out.println("UndoRedoInfo.storeChange(..): LOGGED: (units.size()=" + this.units.size() + ")");
            System.out.println(uru);
        }
    }

    public void addUnit(UndoRedoUnit uru) {
        this.units.add(uru);
        this.position = this.units.size() - 1;
    }

    public UndoRedoUnit undo(Vector v) {
        if (this.DEBUG) {
            System.out.println("UndoRedoInfo.undo(..): position=" + this.position);
        }
        UndoRedoUnit uru = (UndoRedoUnit)this.units.elementAt(this.position);
        --this.position;
        uru = uru.invert();
        uru.perform(v);
        this.units.add(uru);
        return uru;
    }

    public UndoRedoUnit redo(Vector v) {
        if (this.DEBUG) {
            System.out.println("UndoRedoInfo.redo(..): position=" + this.position);
        }
        boolean addUnit = true;
        if (this.position != this.units.size() - 1) {
            addUnit = false;
            this.units.removeElementAt(this.units.size() - 1);
        }
        ++this.position;
        UndoRedoUnit uru = (UndoRedoUnit)this.units.elementAt(this.position);
        uru.perform(v);
        if (addUnit) {
            this.units.add(uru);
        }
        return uru;
    }

    public int getUndoJumpPosition() {
        UndoRedoUnit uru = (UndoRedoUnit)this.units.elementAt(this.position);
        UndoRedoUnit uru2 = uru.invert();
        return uru2.getMaxAppendPos();
    }

    public int getRedoJumpPosition() {
        UndoRedoUnit uru = (UndoRedoUnit)this.units.elementAt(this.position + 1);
        return uru.getMaxAppendPos() + 1;
    }

    public boolean canUndo() {
        return this.units.size() > 0 && this.position > 0 && this.units.elementAt(this.position) != null;
    }

    public boolean canRedo() {
        return this.position + 1 < this.units.size();
    }

    public void clear(Vector fill) {
        this.position = -1 + fill.size();
        this.units.removeAllElements();
        int i = 0;
        while (i < fill.size()) {
            if (fill.elementAt(i) != null) {
                UndoRedoUnit uru = new UndoRedoUnit();
                uru.addElement(new UndoRedoElement(i, fill.elementAt(i), 1));
                this.units.add(uru);
            } else {
                this.units.add(null);
            }
            ++i;
        }
    }

    public void clearFollowing(int p, Vector v) {
        UndoRedoUnit uru = new UndoRedoUnit();
        int i = v.size() - 1;
        while (i >= p) {
            Object o = v.elementAt(i);
            UndoRedoElement ure = new UndoRedoElement(i, o, 0);
            uru.addElement(ure);
            v.removeElementAt(i);
            --i;
        }
        this.addUnit(uru);
    }
}

