/*
 * Decompiled with CFR 0.152.
 */
package mauda.undoredo;

import java.util.Enumeration;
import java.util.Vector;
import mauda.undoredo.UndoRedoElement;

public class UndoRedoUnit {
    private Vector elements = new Vector();

    public void addElement(UndoRedoElement ure) {
        this.elements.add(ure);
    }

    public Vector getElements() {
        return this.elements;
    }

    public void perform(Vector v) {
        int c = this.elements.size() - 1;
        int i = 0;
        while (i <= c) {
            UndoRedoElement unit = (UndoRedoElement)this.elements.elementAt(i);
            if (unit.getID() == 1) {
                v.insertElementAt(unit.getObj(), unit.getPos());
            } else if (unit.getID() == 0) {
                v.removeElementAt(unit.getPos());
            }
            ++i;
        }
    }

    public UndoRedoUnit invert() {
        int c;
        UndoRedoUnit uru = new UndoRedoUnit();
        int i = c = this.elements.size() - 1;
        while (i >= 0) {
            UndoRedoElement element = (UndoRedoElement)this.elements.elementAt(i);
            uru.addElement(element.invert());
            --i;
        }
        return uru;
    }

    public int getMaxAppendPos() {
        int maxpos = -1;
        int minpos = Integer.MAX_VALUE;
        Enumeration en = this.elements.elements();
        while (en.hasMoreElements()) {
            UndoRedoElement ure = (UndoRedoElement)en.nextElement();
            switch (ure.getID()) {
                case 1: {
                    if (ure.getPos() <= maxpos) break;
                    maxpos = ure.getPos();
                    break;
                }
                case 0: {
                    if (ure.getPos() >= minpos) break;
                    minpos = ure.getPos();
                }
            }
        }
        if (maxpos == -1) {
            return minpos - 1;
        }
        return maxpos;
    }

    public boolean equals(Object o) {
        UndoRedoUnit uru = (UndoRedoUnit)o;
        return this.elements.equals(uru.getElements());
    }

    public String toString() {
        String s = "  URUnit:\n";
        Enumeration en = this.elements.elements();
        while (en.hasMoreElements()) {
            s = String.valueOf(s) + "    " + en.nextElement() + "\n";
        }
        return s;
    }
}

