/*
 * Decompiled with CFR 0.152.
 */
package mauda.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.XMLFileAccess;

public class PreviewPanel
extends JPanel
implements ActionListener {
    private JTextArea textArea;
    private JButton showMeta;
    private MetaData metaData;

    public PreviewPanel() {
        this.setLayout(new BorderLayout());
        this.metaData = null;
        JLabel label = new JLabel(" Meta-Data");
        label.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)label, "North");
        this.textArea = new JTextArea("", 7, 13);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.showMeta = new JButton("Show");
        this.showMeta.setMargin(new Insets(0, 0, 0, 0));
        this.showMeta.setEnabled(false);
        this.showMeta.addActionListener(this);
        this.add((Component)this.showMeta, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.metaData == null) {
            return;
        }
        boolean mod = this.metaData.inputDialog();
        if (mod) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Changings in Meta-Data will not be saved!");
        }
    }

    public void configure(File f) {
        String msg = "";
        if (f.exists()) {
            String filename = f.getAbsolutePath();
            Vector v = XMLFileAccess.load(filename);
            if (v == null) {
                this.textArea.setText("");
                this.showMeta.setEnabled(false);
                this.metaData = null;
                return;
            }
            HashMap ht = (HashMap)v.firstElement();
            this.metaData = new MetaData();
            this.metaData.load(ht.get("Meta-Data"));
            this.showMeta.setEnabled(true);
            HashMap meta = this.metaData.save();
            msg = this.metaData.getPreviewString();
        } else {
            msg = "File not exists!";
        }
        this.textArea.setText(msg);
        this.textArea.setCaretPosition(0);
    }
}

