/*
 * Decompiled with CFR 0.152.
 */
package evalplayer;

import evalplayer.EvalPlayerMenu;
import evalplayer.MenuToolBarListener;
import evalplayer.SpeedSlider;
import evalplayer.TimeSlider;
import evalplayer.TopToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jedas.Jedas;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.ModifiedDetector;
import mauda.evaluation.PlayerExercise;
import mauda.utils.FileLocation;
import mauda.utils.MyWindowListener;

public class EvalPlayer
extends JFrame
implements ExerciseUpdateListener {
    private String frameTitle = "MA&DA EvalPlayer V1.00";

    public static void main(String[] args) {
        new EvalPlayer();
    }

    public EvalPlayer() {
        MAUDA.setApplicationMainFrame(this);
        FileLocation.config();
        this.setDefaultCloseOperation(0);
        PlayerExercise exercise = new PlayerExercise("FibHeap");
        exercise.addExerciseUpdateListener(this);
        exercise.setInteractiveMode(3);
        exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));
        this.addWindowListener(new MyWindowListener(exercise));
        Container contentPane = this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
        mainPanel.add((Component)new TopToolBar(menuToolBarListener), "North");
        this.setMenuBar(new EvalPlayerMenu(menuToolBarListener));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane(0);
        sp.setTopComponent(exercise.getTreeOperationView().getPanel());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)exercise.getCommentView().getPanel(), "Center");
        bottomPanel.add((Component)new SpeedSlider().getPanel(), "South");
        sp.setBottomComponent(bottomPanel);
        sp.setOneTouchExpandable(true);
        sp.setDividerLocation(350);
        rightPanel.add((Component)sp, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setRightComponent(rightPanel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)exercise.jedasPanel, "Center");
        TimeSlider timeSlider = new TimeSlider(exercise);
        leftPanel.add((Component)timeSlider.getPanel(), "South");
        splitPane.setLeftComponent(leftPanel);
        splitPane.setOneTouchExpandable(true);
        rightPanel.setMinimumSize(new Dimension(240, 50));
        mainPanel.add((Component)splitPane, "Center");
        contentPane.add((Component)mainPanel, "Center");
        this.setBounds(0, 0, 800, 550);
        this.setTitle(this.frameTitle);
        splitPane.setDividerLocation(540);
        MetaData.setDisplayMode(2);
        Jedas.setApplicationMainFrame(this);
        exercise.jedasPanel.setMessage("Please load an exercise...");
        this.setVisible(true);
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() != 1) {
            return;
        }
        String filename = e.getExercise().getFilename();
        filename = filename.replace('\\', '/');
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        this.setTitle(String.valueOf(filename) + " - " + this.frameTitle);
    }
}

