/*
 * Decompiled with CFR 0.152.
 */
package evalplayer;

import help.HelpFrame;
import help.HelpTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mauda.AboutFrame;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.evaluation.PlayerExercise;
import mauda.utils.FileLocation;
import mauda.utils.PreviewPanel;
import mauda.utils.XMLFilter;

public class MenuToolBarListener
implements ActionListener {
    private PlayerExercise exercise;
    private JFileChooser fileChooser;
    private PreviewPanel previewPanel = new PreviewPanel();

    public MenuToolBarListener(PlayerExercise exercise) {
        this.exercise = exercise;
        this.fileChooser = new JFileChooser(FileLocation.evaluatedPath);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.addChoosableFileFilter(new XMLFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAccessory(this.previewPanel);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                    File f = (File)e.getNewValue();
                    if (f == null) {
                        return;
                    }
                    String s = f.getPath();
                    String suffix = null;
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        suffix = s.substring(i + 1).toLowerCase();
                    }
                    if (suffix != null && suffix.equals("xml")) {
                        MenuToolBarListener.this.previewPanel.configure(f);
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s == "OpenFile") {
            MetaData.setDisplayMode(2);
            this.fileChooser.setCurrentDirectory(new File(FileLocation.evaluatedPath));
            this.openFile();
        } else if (s == "Meta") {
            boolean mod = this.exercise.getMetaData().inputDialog();
            if (mod) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Changings in Meta-Data will not be saved!");
            }
        } else if (s == "Exit") {
            System.exit(0);
        } else if (s == "ShowAbout") {
            AboutFrame.createAndShowGUI();
        } else if (s == "ShowHelp") {
            HelpTree.setView(4);
            HelpFrame.createAndShowGUI();
        }
    }

    private void openFile() {
        File file;
        int state = this.fileChooser.showOpenDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()).isFile()) {
            this.openFile(file);
        }
    }

    private void openFile(File file) {
        this.exercise.setFilename(file.getAbsolutePath());
        HashMap hm = this.exercise.load(this.exercise.getFilename());
        if (hm == null) {
            return;
        }
        String editorState = this.exercise.getMetaData().getEditorState();
        String evaluatorState = this.exercise.getMetaData().getEvaluatorState();
        String evaluatorName = this.exercise.getMetaData().getEvaluatorName();
        if (!evaluatorState.equals("evaluated")) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a not evaluated exercises!");
            return;
        }
        if (evaluatorName.equals("AutoEvaluator")) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a automatically evaluated exercise!");
            return;
        }
        this.exercise.loadEvaluated(hm);
    }
}

