/*
 * Decompiled with CFR 0.152.
 */
package generation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mauda.Difficulties;
import mauda.ExerciseMode;
import mauda.SimpleExercise;
import mauda.XMLFileAccess;
import mauda.operation.OperationQueue;
import mauda.plugin.GeneralAnalyst;
import mauda.plugin.PlugInHandler;
import mauda.utils.FileLocation;

public class AutoGenerator {
    private String initFilename = "init.xml";
    private String scrambleFilename = "scramble.xml";
    private String autoGenFilename = "autogen.xml";
    private String ratingFilename = "rating.xml";
    private int mode;
    private SimpleExercise exercise;

    public AutoGenerator(String type, String diffStr, String modeStr, boolean saveGeneratedExercise) {
        FileLocation.config();
        this.exercise = new SimpleExercise();
        PlugInHandler plugInHandler = new PlugInHandler(this.exercise);
        boolean plugInOk = false;
        String[] plugInNames = plugInHandler.getAvailablePlugIns();
        int i = 0;
        while (i < plugInNames.length) {
            if (type.equals(plugInNames[i])) {
                plugInOk = true;
            }
            ++i;
        }
        if (!plugInOk) {
            System.out.println("ERROR: Unknown PlugIn-Name: " + type);
            System.exit(0);
        } else if (Difficulties.getID(diffStr) == -1) {
            System.out.println("ERROR: Unknown Difficulty: " + diffStr);
            System.exit(0);
        } else if (ExerciseMode.getID(modeStr) == -1) {
            System.out.println("ERROR: Unknown Mode: " + modeStr);
            System.exit(0);
        }
        plugInHandler.load(type);
        this.exercise.setDifficulty(Difficulties.getID(diffStr));
        this.exercise.getMetaData().setSource("AutoGenerator");
        this.exercise.getMetaData().setComment("Generated by 'AutoGenerator.java'.");
        this.exercise.setMode(ExerciseMode.getID(modeStr));
        this.automatic();
        if (saveGeneratedExercise) {
            this.save();
        }
        System.out.println("Exercise Ready!");
    }

    private void save() {
        String filename = FileLocation.genFilename(FileLocation.unworkedPath, FileLocation.unworkedPrefix);
        this.exercise.save(filename);
    }

    public HashMap getExercise() {
        HashMap hm = this.exercise.save(null);
        return hm;
    }

    private OperationQueue loadConfig(String filename) {
        Vector v = XMLFileAccess.load(filename);
        if (v == null) {
            System.err.println("Cant load '" + filename + "'!");
            System.err.println("No automatic generation of exercises possible without this file!");
            return null;
        }
        OperationQueue oq = new OperationQueue();
        oq.load((Vector)v.firstElement());
        return oq;
    }

    private void automatic() {
        System.out.println("Loading files...");
        String d = this.exercise.getDataDirectory();
        OperationQueue initOQ = this.loadConfig(String.valueOf(d) + this.initFilename);
        OperationQueue scrambleOQ = this.loadConfig(String.valueOf(d) + this.scrambleFilename);
        OperationQueue autoGenOQ = this.loadConfig(String.valueOf(d) + this.autoGenFilename);
        System.out.println("Call to GeneralAnalyst.fullAutomatic(...)");
        OperationQueue[] oq = GeneralAnalyst.fullAutomatic(this.exercise.getDSObject(), initOQ, scrambleOQ, autoGenOQ, this.exercise.getDifficulty(), this.exercise.getMode());
        this.exercise.getOperationRecorder().setTodoPosition(oq[0].length());
        OperationQueue exeOQ = new OperationQueue();
        exeOQ.addAll(oq[0]);
        exeOQ.addAll(oq[1]);
        System.out.println("Execute Operations on Exercise");
        Enumeration en = exeOQ.toVector().elements();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            this.exercise.operationExecuted(o);
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: AutoGenerator Type Difficulty Mode");
            System.out.println("    Type = e.g. FibHeap");
            System.out.println("    Difficulty = EASY | MEDIUM | HARD");
            System.out.println("    Mode = NORMAL | FAULT");
            System.exit(0);
        }
        String type = args[0];
        String diff = args[1];
        String mode = args[2];
        new AutoGenerator(type, diff, mode, true);
    }
}

