/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.EditTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mauda.ExerciseUpdateEvent;
import mauda.Failure;
import mauda.MAUDA;
import mauda.OperationRecorder;
import mauda.generation.GenExercise;
import mauda.operation.Operation;
import mauda.operation.SubOperationQueue;
import mauda.treeoperationview.NodePopup;

public class ExerciseTab
extends EditTab {
    protected static final String tabName = "Exercise";
    protected static final String startExercise = "StartEx";
    protected static final String upExercisePoint = "Up";
    protected static final String downExercisePoint = "Down";
    protected static final String checkExercise = "Check";
    protected static final String clearFollowing = "Clear following operations...";
    protected static final String showSubOperations = "Show Suboperations...";

    public ExerciseTab(GenExercise exercise) {
        super(exercise);
        this.setTabName(tabName);
        this.setTopPanel(exercise.getTreeOperationView().getPanel());
        this.createButton(upExercisePoint);
        this.createButton(downExercisePoint);
        this.createButton(startExercise);
        this.createButton(checkExercise);
        NodePopup np = exercise.getTreeOperationView().getNodePopup();
        np.addItem(clearFollowing, this);
        np.addItem(showSubOperations, this);
    }

    protected void doUpdate() {
        this.actualizeTree();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        OperationRecorder or = this.exercise.getOperationRecorder();
        if (s == startExercise) {
            or.goInTodoMode();
            int p = or.getTodoPosition();
            or.setTodoPosition(or.getPossibleTodoPosition(p));
            this.actualizeTree();
        } else if (s == upExercisePoint) {
            or.decreaseTodoPosition();
            this.actualizeTree();
        } else if (s == downExercisePoint) {
            or.increaseTodoPosition();
            this.actualizeTree();
        } else if (s == checkExercise) {
            String result = this.exercise.isReadyToSave();
            if (result.equals("OK") && this.exercise.getMode() == 1) {
                Failure f = this.exercise.getOperationRecorder().getUnlimitedFailure(0);
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                JTextArea ta = new JTextArea(f.getDescriptionString(), 16, 60);
                ta.setEditable(false);
                ta.setFont(new Font("Monospaced", 0, 12));
                p.add((Component)new JLabel("FAILURE FOUND:"), "North");
                p.add((Component)new JScrollPane(ta), "Center");
                p.add((Component)new JLabel("Exercise is ready for saving."), "South");
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), p);
            } else {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), result);
            }
        } else if (s == clearFollowing) {
            Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 12);
            int index = this.exercise.getTreeOperationView().getActionIndex();
            int delta = index + or.getOffset(0, -1) - or.getCurrentOffset();
            eue.setValue(delta);
            v.add(eue);
            eue = new ExerciseUpdateEvent(this.exercise, 3);
            v.add(eue);
            this.exercise.commit(v);
        } else if (s == showSubOperations) {
            this.showSubOperations(this.exercise.getTreeOperationView().getActionIndex());
        }
        this.update();
    }

    private void actualizeTree() {
        this.exercise.getTreeOperationView().markTodoPosition();
    }

    private void showSubOperations(int index) {
        OperationRecorder or = this.exercise.getOperationRecorder();
        Object op = or.getEntry(index + or.getOffset(0, -1));
        if (op != null && op instanceof Operation) {
            Vector<String> v = new Vector<String>();
            SubOperationQueue soq = ((Operation)op).getSubOperationQueue();
            int i = 0;
            while (i < soq.length()) {
                v.add((i + 1 < 10 ? " " : "") + (i + 1) + ". " + soq.get(i));
                ++i;
            }
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            Container contentPane = frame.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JLabel opLabel = new JLabel("" + op);
            JList<String> list = new JList<String>();
            list.setListData(v);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object o = e.getSource();
                    while (o != null && !(o instanceof Window)) {
                        o = ((Container)o).getParent();
                    }
                    if (o != null) {
                        ((Window)o).dispose();
                    } else {
                        System.out.println("Window not found!");
                    }
                }
            });
            contentPane.add((Component)opLabel, "North");
            contentPane.add((Component)new JScrollPane(list), "Center");
            contentPane.add((Component)okButton, "South");
            frame.setTitle("SubOperations");
            frame.setBounds(MAUDA.getRelativeBounds(200, 250));
            frame.setVisible(true);
        }
    }
}

