/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.AutoGenTab;
import generation.EditTab;
import generation.ExerciseTab;
import generation.GeneratorMenu;
import generation.InitTab;
import generation.MenuToolBarListener;
import generation.OpTemplateTab;
import generation.OperationsTab;
import generation.RatingTab;
import generation.ScrambleTab;
import generation.TopToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.ModifiedDetector;
import mauda.generation.GenExercise;
import mauda.plugin.PlugInHandler;
import mauda.utils.FileLocation;
import mauda.utils.MyWindowListener;

public class GenEditor
extends JFrame
implements ExerciseUpdateListener {
    private static String frameTitle = "MA&DA GenEditor V1.01";

    public static void main(String[] args) {
        new GenEditor();
    }

    public GenEditor() {
        MAUDA.setApplicationMainFrame(this);
        FileLocation.config();
        this.setDefaultCloseOperation(0);
        GenExercise exercise = new GenExercise("FibHeap");
        exercise.addExerciseUpdateListener(this);
        exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));
        this.addWindowListener(new MyWindowListener(exercise));
        MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
        GeneratorMenu generatorMenu = new GeneratorMenu(menuToolBarListener);
        PlugInHandler pih = exercise.getPlugInHandler();
        String[] pinames = pih.getAvailablePlugIns();
        int i = 0;
        while (i < pinames.length) {
            String id = pinames[i];
            generatorMenu.addPlugIn(id, pih.getPlugInString(id));
            ++i;
        }
        Container contentPane = this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane tp = (JTabbedPane)e.getSource();
                EditTab et = (EditTab)tp.getSelectedComponent();
                et.doUpdate();
            }
        });
        ExerciseTab exerciseTab = new ExerciseTab(exercise);
        OperationsTab operationsTab = new OperationsTab(exercise);
        RatingTab ratingTab = new RatingTab(exercise);
        InitTab initTab = new InitTab(exercise);
        ScrambleTab scrambleTab = new ScrambleTab(exercise);
        AutoGenTab autoGenTab = new AutoGenTab(exercise);
        tabbedPane.add(exerciseTab.getTabName(), exerciseTab);
        tabbedPane.add(operationsTab.getTabName(), operationsTab);
        tabbedPane.add(ratingTab.getTabName(), ratingTab);
        tabbedPane.add(initTab.getTabName(), initTab);
        tabbedPane.add(scrambleTab.getTabName(), scrambleTab);
        tabbedPane.add(autoGenTab.getTabName(), autoGenTab);
        exercise.addExerciseUpdateListener(exerciseTab);
        exercise.addExerciseUpdateListener(operationsTab);
        exercise.addExerciseUpdateListener(ratingTab);
        exercise.addExerciseUpdateListener(initTab);
        exercise.addExerciseUpdateListener(scrambleTab);
        exercise.addExerciseUpdateListener(autoGenTab);
        Vector<OpTemplateTab> editTabs = new Vector<OpTemplateTab>();
        editTabs.add(initTab);
        editTabs.add(scrambleTab);
        editTabs.add(autoGenTab);
        menuToolBarListener.setEditTabs(editTabs);
        mainPanel.add((Component)new TopToolBar(menuToolBarListener), "North");
        opPanel.add((Component)tabbedPane, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setBottomComponent(opPanel);
        splitPane.setTopComponent(exercise.jedasPanel);
        splitPane.setOneTouchExpandable(true);
        opPanel.setMinimumSize(new Dimension(220, 50));
        exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));
        mainPanel.add((Component)splitPane, "Center");
        contentPane.add((Component)mainPanel, "Center");
        this.setMenuBar(generatorMenu);
        this.setBounds(0, 0, 800, 500);
        this.setTitle(frameTitle);
        this.setVisible(true);
        MetaData.setDisplayMode(1);
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() != 1) {
            return;
        }
        String filename = e.getExercise().getFilename();
        filename = filename.replace('\\', '/');
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        this.setTitle(String.valueOf(filename) + " - " + frameTitle);
    }
}

