/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.AutoGenTab;
import generation.EditTab;
import generation.InitTab;
import generation.ScrambleTab;
import help.HelpFrame;
import help.HelpTree;
import java.awt.CheckboxMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jedas.Jedas;
import mauda.AboutFrame;
import mauda.Difficulties;
import mauda.Exercise;
import mauda.MAUDA;
import mauda.OperationRecorder;
import mauda.operation.OperationQueue;
import mauda.plugin.GeneralAnalyst;
import mauda.utils.FileLocation;
import mauda.utils.PreviewPanel;
import mauda.utils.Prop;
import mauda.utils.XMLFilter;

public class MenuToolBarListener
implements ActionListener,
ItemListener {
    private Exercise exercise;
    private Vector editTabs;
    private JFileChooser fileChooser;
    private PreviewPanel previewPanel = new PreviewPanel();

    public MenuToolBarListener(Exercise exercise) {
        this.exercise = exercise;
        this.fileChooser = new JFileChooser(new File(FileLocation.unworkedPath));
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.addChoosableFileFilter(new XMLFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAccessory(this.previewPanel);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                    File f = (File)e.getNewValue();
                    if (f == null) {
                        return;
                    }
                    String s = f.getPath();
                    String suffix = null;
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        suffix = s.substring(i + 1).toLowerCase();
                    }
                    if (suffix != null && suffix.equals("xml")) {
                        MenuToolBarListener.this.previewPanel.configure(f);
                    }
                }
            }
        });
    }

    protected void setEditTabs(Vector et) {
        this.editTabs = et;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s.startsWith("PLUGIN: ")) {
            if (!this.dialogDiscardActiveExercise()) {
                return;
            }
            String plugInName = s.substring(8);
            this.exercise.switchTo(plugInName);
        } else if (s == "NewFile") {
            this.newFile();
        } else if (s == "OpenFile") {
            this.openFile();
        } else if (s == "SaveFile") {
            String status = this.exercise.isReadyToSave();
            if (!status.equals("OK")) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), status);
            } else {
                this.saveFile(this.exercise.getFilename());
            }
        } else if (s == "SaveAsFile") {
            String status = this.exercise.isReadyToSave();
            if (!status.equals("OK")) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), status);
            } else {
                this.saveAsFile();
            }
        } else if (s == "Dump") {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), this.exercise.getDSObject());
        } else if (s == "Meta") {
            this.exercise.updateMetaDataInitTodoRating();
            boolean mod = this.exercise.getMetaData().inputDialog();
            if (mod) {
                this.exercise.setModified(true);
            }
        } else if (s == "Automatic") {
            if (this.exercise.getMode() == 1) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "AutomaticFaultModeNotSupported"));
                return;
            }
            if (this.newFile()) {
                InitTab initTab = null;
                ScrambleTab scrambleTab = null;
                AutoGenTab autoGenTab = null;
                Enumeration en = this.editTabs.elements();
                while (en.hasMoreElements()) {
                    EditTab et = (EditTab)en.nextElement();
                    if (et instanceof InitTab) {
                        initTab = (InitTab)et;
                        continue;
                    }
                    if (et instanceof ScrambleTab) {
                        scrambleTab = (ScrambleTab)et;
                        continue;
                    }
                    if (!(et instanceof AutoGenTab)) continue;
                    autoGenTab = (AutoGenTab)et;
                }
                OperationQueue[] oq = GeneralAnalyst.fullAutomatic(this.exercise.getDSObject(), initTab.operationQueue, scrambleTab.operationQueue, autoGenTab.operationQueue, this.exercise.getDifficulty(), this.exercise.getMode());
                this.exercise.getOperationRecorder().setTodoPosition(oq[0].length());
                OperationQueue exeOQ = new OperationQueue();
                exeOQ.addAll(oq[0]);
                exeOQ.addAll(oq[1]);
                this.exercise.commit(exeOQ);
            }
        } else if (s == "Undo") {
            this.exercise.undo();
        } else if (s == "Redo") {
            this.exercise.redo();
        } else if (s == "Difficulty-0") {
            this.exercise.setDifficulty(Difficulties.getID("EASY"));
        } else if (s == "Difficulty-1") {
            this.exercise.setDifficulty(Difficulties.getID("MEDIUM"));
        } else if (s == "Difficulty-2") {
            this.exercise.setDifficulty(Difficulties.getID("HARD"));
        } else if (s != "SubOperationEdit") {
            if (s == "NormalMode") {
                this.exercise.setMode(0);
            } else if (s == "FaultMode") {
                this.exercise.setMode(1);
            } else if (s == "Exit") {
                if (this.dialogDiscardActiveExercise()) {
                    System.exit(0);
                }
            } else if (s == "ShowAbout") {
                AboutFrame.createAndShowGUI();
            } else if (s == "ShowHelp") {
                HelpTree.setView(1);
                HelpFrame.createAndShowGUI();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem cmi = (CheckboxMenuItem)e.getSource();
        String s = cmi.getActionCommand();
        boolean selected = cmi.getState();
        if (s == "SubOperationEdit") {
            if (selected) {
                this.exercise.setInteractiveMode(2);
            } else {
                this.exercise.setInteractiveMode(0);
            }
        }
    }

    protected boolean newFile() {
        if (!this.dialogDiscardActiveExercise()) {
            return false;
        }
        this.exercise.reset();
        Jedas.updateDisplay();
        this.exercise.setDefaultFilename();
        this.updateFilenameLabel();
        return true;
    }

    protected void openFile() {
        File file;
        if (!this.dialogDiscardActiveExercise()) {
            return;
        }
        int state = this.fileChooser.showOpenDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()).isFile()) {
            this.openFile(file);
        }
    }

    protected void openFile(File file) {
        String newFilename = file.getAbsolutePath();
        HashMap hm = this.exercise.load(newFilename);
        String editorState = this.exercise.getMetaData().getEditorState();
        if (!editorState.equals("unworked")) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a worked-out or evaluated exercise.");
            return;
        }
        if (hm == null) {
            return;
        }
        this.exercise.reset();
        this.exercise.load(hm);
        this.exercise.loadConfig(hm);
        this.exercise.setFilename(newFilename);
        this.updateFilenameLabel();
        OperationRecorder or = this.exercise.getOperationRecorder();
        Vector exOps = new Vector();
        exOps.addAll((Vector)or.getInitOperations().clone());
        exOps.addAll((Vector)or.getTodoOperations().clone());
        exOps = this.exercise.addFullLoadedMessage(exOps);
        this.exercise.getUndoRedo().clear();
        this.exercise.setDSObject(this.exercise.getUndoRedo().getDSObject());
        or.clear();
        this.exercise.commit(exOps);
    }

    protected void saveFile(String fname) {
        if (fname.equals(this.exercise.getDefaultFilename())) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "DialogChooseSaveAs"));
            return;
        }
        this.exercise.updateMetaDataInitTodoRating();
        this.exercise.getMetaData().inputDialog();
        this.exercise.save(fname);
        this.exercise.setFilename(fname);
        this.updateFilenameLabel();
    }

    protected void saveAsFile() {
        File file;
        int state = this.fileChooser.showSaveDialog(null);
        if (state == 0 && (file = this.fileChooser.getSelectedFile()) != null) {
            String fname = file.getAbsolutePath();
            if (file.exists() && !this.dialogExistsOverwrite(fname)) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), Prop.get(this, "FileNotSaved"));
                return;
            }
            if (!fname.toLowerCase().endsWith(".xml")) {
                fname = String.valueOf(fname) + ".xml";
            }
            this.saveFile(fname);
        }
    }

    protected void updateFilenameLabel() {
    }

    private boolean dialogExistsOverwrite(String filename) {
        String s = Prop.get(this, "DialogExistsOverwrite");
        s = s.replaceAll("FILENAME", filename);
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogExistsOverwriteTitle"), 1, 2);
        return result == 0;
    }

    private boolean dialogDiscardActiveExercise() {
        if (!this.exercise.isModified()) {
            return true;
        }
        String s = Prop.get(this, "DialogDiscardActiveExercise");
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "DialogDiscardActiveExerciseTitle"), 1, 2);
        return result == 0;
    }
}

