/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.EditTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import mauda.MAUDA;
import mauda.XMLFileAccess;
import mauda.generation.GenExercise;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.utils.Prop;

public class OpTemplateTab
extends EditTab {
    private JList list;
    public OperationQueue operationQueue;
    protected static final String tabName = "OpTemplate";
    protected static final String execute = "Execute";
    protected static final String load = "Load";
    protected static final String save = "Save";
    protected static final String add = "Add";
    protected static final String remove = "Remove";
    protected static final String clear = "Clear";
    protected static final String addMessageTitle = "AddMessageTitle";
    protected static final String addMessage = "AddMessage";

    public OpTemplateTab(GenExercise exercise) {
        super(exercise);
        this.setTabName(tabName);
        this.operationQueue = new OperationQueue();
        this.list = new JList(new Vector());
        this.setTopPanel(new JScrollPane(this.list));
        this.createButton(execute);
        this.createButton(clear);
        this.createButton(add);
        this.createButton(remove);
        this.createButton(load);
        this.createButton(save);
    }

    protected void update() {
        if (this.isVisible()) {
            OperationQueue oq = new OperationQueue();
            Enumeration en = this.operationQueue.toVector().elements();
            while (en.hasMoreElements()) {
                oq.add(((Operation)en.nextElement()).getID());
            }
            this.operationQueue = oq;
            this.doUpdate();
        }
    }

    protected void doUpdate() {
        Vector v = this.operationQueue.toVector();
        Vector<String> listData = new Vector<String>();
        int counter = 0;
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            listData.add(String.valueOf(++counter) + ". " + op);
        }
        this.list.setListData(listData);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s == execute) {
            this.executePressed(this.exercise);
        } else if (s == add) {
            JPanel inputPanel = new JPanel();
            inputPanel.setLayout(new BorderLayout());
            inputPanel.add((Component)new JLabel(Prop.get(this, "OpTemplateAddMessage")), "North");
            JPanel p = new JPanel();
            JTextField textField = new JTextField("1", 2);
            p.add(textField);
            ButtonGroup g = new ButtonGroup();
            Vector aop = this.exercise.getAvailableOperations();
            int size = aop.size();
            JRadioButton[] rbs = new JRadioButton[size];
            int i = 0;
            while (i < size) {
                rbs[i] = new JRadioButton("" + aop.elementAt(i));
                g.add(rbs[i]);
                p.add(rbs[i]);
                ++i;
            }
            inputPanel.add((Component)p, "Center");
            int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), inputPanel, Prop.get(this, "OpTemplateAddMessageTitle"), 2);
            if (result == 0) {
                Operation op = null;
                int i2 = 0;
                while (i2 < size) {
                    if (rbs[i2].isSelected()) {
                        op = (Operation)aop.elementAt(i2);
                        break;
                    }
                    ++i2;
                }
                if (op != null) {
                    int times = Integer.parseInt(textField.getText());
                    int i3 = 0;
                    while (i3 < times) {
                        this.operationQueue.add((Operation)op.clone());
                        ++i3;
                    }
                }
            }
        } else if (s == remove) {
            int[] indices = this.list.getSelectedIndices();
            if (indices.length <= 0) {
                return;
            }
            int i = indices.length - 1;
            while (i >= 0) {
                this.operationQueue.remove(indices[i]);
                --i;
            }
        } else if (s == clear) {
            this.operationQueue = new OperationQueue();
        } else if (s == load) {
            if (this.dialog("LOAD " + this.dataFilename)) {
                this.loadConfig(this.dataFilename);
            }
        } else if (s == save && this.dialog("SAVE " + this.dataFilename)) {
            Vector<Vector> savevev = new Vector<Vector>();
            savevev.add(this.operationQueue.save());
            boolean result = XMLFileAccess.save(this.dataFilename, savevev);
            if (!result) {
                JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '" + this.dataFilename + "' !\n\n" + "--> File not saved!");
            }
        }
        this.update();
    }

    protected void loadConfig(String filename) {
        Vector v = XMLFileAccess.load(filename);
        if (v == null) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load '" + filename + "'!");
            return;
        }
        OperationQueue oq = new OperationQueue();
        oq.load((Vector)v.firstElement());
        this.operationQueue = oq;
        this.update();
    }

    protected void executePressed(GenExercise ex) {
    }

    protected void defaultPressed(GenExercise ex) {
    }

    protected void updateSettings() {
        this.operationQueue = new OperationQueue();
        this.update();
    }
}

