/*
 * Decompiled with CFR 0.152.
 */
package generation;

import generation.EditTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedas.Jedas;
import mauda.MAUDA;
import mauda.generation.GenExercise;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SubOperationQueue;
import mauda.plugin.GeneralAnalyst;
import mauda.utils.Prop;

public class OperationsTab
extends EditTab
implements ListSelectionListener {
    private JList list1;
    private JList list2;
    private Operation[] operations1;
    private Operation[] operations2;
    private int lastListClicked = 0;
    protected static final String tabName = "Operations";
    protected static final String execute = "Execute";
    protected static final String sortedByRating = "SortedByRating";
    protected static final String sortedByName = "SortedByName";

    public OperationsTab(GenExercise exercise) {
        super(exercise);
        this.setTabName(tabName);
        Vector<String> v = new Vector<String>();
        v.add("Entry 1");
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)new JLabel(Prop.get(this, "OperationsSortedByRating")), "North");
        this.list1 = new JList(v);
        this.list1.addListSelectionListener(this);
        p1.add((Component)new JScrollPane(this.list1), "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)new JLabel(Prop.get(this, "OperationsSortedByName")), "North");
        this.list2 = new JList(v);
        this.list2.addListSelectionListener(this);
        p2.add((Component)new JScrollPane(this.list2), "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerLocation(170);
        splitPane.setLeftComponent(p1);
        splitPane.setRightComponent(p2);
        this.setTopPanel(splitPane);
        this.createButton(execute);
    }

    protected void doUpdate() {
        this.updateLists();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        String s = e.getActionCommand();
        if (s == execute) {
            Operation op = null;
            if (this.lastListClicked == 1) {
                int index = this.list1.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                op = this.operations1[index];
            } else if (this.lastListClicked == 2) {
                int index = this.list2.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                op = this.operations2[index];
            }
            if (op != null) {
                this.exercise.commit(op);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = ((JList)e.getSource()).getSelectedIndex();
        if (index == -1) {
            return;
        }
        Operation op = null;
        if (e.getSource() == this.list1) {
            this.lastListClicked = 1;
            op = this.operations1[index];
        } else if (e.getSource() == this.list2) {
            this.lastListClicked = 2;
            op = this.operations2[index];
        }
        if (op != null) {
            SubOperationQueue soq = op.getSubOperationQueue();
            String msg = op + "\n\n" + soq;
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
        }
    }

    protected void updateLists() {
        OperationQueue oq = GeneralAnalyst.getOperations(this.exercise.getDSObject());
        if (oq == null) {
            this.list1.setListData(new Vector());
            this.list2.setListData(new Vector());
            return;
        }
        this.operations1 = oq.toArray();
        Operation.setSort(0);
        Arrays.sort(this.operations1);
        this.operations2 = oq.toArray();
        Operation.setSort(1);
        Arrays.sort(this.operations2);
        Vector<Operation> listVec1 = new Vector<Operation>();
        Vector<Operation> listVec2 = new Vector<Operation>();
        int i = 0;
        while (i < this.operations1.length) {
            listVec1.add(this.operations1[i]);
            listVec2.add(this.operations2[i]);
            ++i;
        }
        this.list1.setListData(listVec1);
        this.list2.setListData(listVec2);
        Jedas.updateDisplay();
    }
}

