/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import mauda.MAUDA;
import mauda.images.ImageHandler;

public class HelpFrame
extends JFrame
implements ActionListener {
    private String frameTitle = "MA&DA Help V1.01";
    private static HelpFrame instance = null;
    private HelpTree helpTree;
    private JButton backButton;
    private JButton forwardButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton exitButton;

    public HelpFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                instance = null;
                HelpFrame.this.dispose();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        this.helpTree = new HelpTree(editorPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        this.exitButton = new JButton("Exit");
        this.backButton = new JButton(ImageHandler.createImageIcon("Back16.gif"));
        this.forwardButton = new JButton(ImageHandler.createImageIcon("Forward16.gif"));
        this.undoButton = new JButton(ImageHandler.createImageIcon("Undo16.gif"));
        this.redoButton = new JButton(ImageHandler.createImageIcon("Redo16.gif"));
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.undoButton.addActionListener(this);
        this.redoButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        buttonPanel.add(this.exitButton);
        buttonPanel.add(new JSeparator());
        buttonPanel.add(this.backButton);
        buttonPanel.add(this.forwardButton);
        buttonPanel.add(new JSeparator());
        buttonPanel.add(this.undoButton);
        buttonPanel.add(this.redoButton);
        contentPane.add((Component)buttonPanel, "North");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)new JScrollPane(this.helpTree.getPanel()), "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add((Component)new JScrollPane(editorPane), "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(leftPanel);
        splitPane.setRightComponent(rightPanel);
        leftPanel.setMinimumSize(new Dimension(100, 50));
        rightPanel.setMinimumSize(new Dimension(100, 50));
        contentPane.add((Component)splitPane, "Center");
        this.setBounds(MAUDA.getRelativeBounds(800, 550));
        this.setTitle(this.frameTitle);
        splitPane.setDividerLocation(200);
        this.setVisible(true);
        instance = this;
    }

    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button == this.exitButton) {
            instance = null;
            this.dispose();
        } else if (button == this.backButton) {
            this.helpTree.back();
        } else if (button == this.forwardButton) {
            this.helpTree.forward();
        } else if (button == this.undoButton) {
            this.helpTree.undo();
        } else if (button == this.redoButton) {
            this.helpTree.redo();
        }
    }

    public static void createAndShowGUI() {
        if (instance == null) {
            new HelpFrame();
        } else {
            instance.setExtendedState(0);
            instance.toFront();
        }
    }

    public static void main(String[] args) {
        HelpTree.setView(0);
        new HelpFrame();
    }
}

