/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HelpTree
implements TreeSelectionListener {
    private static boolean DEBUG = false;
    public static final int COMPLETE_VIEW = 0;
    public static final int GENEDITOR_VIEW = 1;
    public static final int WORKEDITOR_VIEW = 2;
    public static final int EVALEDITOR_VIEW = 3;
    public static final int EVALPLAYER_VIEW = 4;
    private static boolean SHOW_GENEDITOR = true;
    private static boolean SHOW_WORKEDITOR = true;
    private static boolean SHOW_EVALEDITOR = true;
    private static boolean SHOW_EVALPLAYER = true;
    private JPanel panel;
    private JTree tree;
    private JEditorPane htmlPane;
    private boolean nextNoHistoryEntry;
    private int position;
    private Vector history;

    public HelpTree(JEditorPane editorPane) {
        this.htmlPane = editorPane;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.tree = new JTree(this.createTree());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.panel.add((Component)this.tree, "Center");
        this.history = new Vector();
        this.position = -1;
        this.nextNoHistoryEntry = false;
        this.tree.setSelectionRow(0);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.nodeClicked(node);
    }

    private void nodeClicked(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        HelpInfo helpInfo = (HelpInfo)nodeInfo;
        this.displayURL(helpInfo.getURL());
        this.urlClicked(helpInfo.getURL());
        if (DEBUG) {
            System.out.print(helpInfo.getURL() + ":  \n    ");
        }
        if (DEBUG) {
            System.out.println(nodeInfo.toString());
        }
    }

    private void displayURL(URL url) {
        try {
            if (url != null) {
                this.htmlPane.setPage(url);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + url);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean canUndo() {
        return this.position > 0;
    }

    public boolean canRedo() {
        return this.position < this.history.size() - 1;
    }

    private void urlClicked(URL url) {
        if (this.nextNoHistoryEntry) {
            this.nextNoHistoryEntry = false;
            return;
        }
        ++this.position;
        while (this.history.size() > this.position) {
            this.history.removeElementAt(this.position);
        }
        this.history.add(this.tree.getSelectionPath());
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        --this.position;
        this.nextNoHistoryEntry = true;
        TreePath tp = (TreePath)this.history.elementAt(this.position);
        this.tree.setSelectionPath(tp);
        this.tree.scrollPathToVisible(tp);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ++this.position;
        this.nextNoHistoryEntry = true;
        TreePath tp = (TreePath)this.history.elementAt(this.position);
        this.tree.setSelectionPath(tp);
        this.tree.scrollPathToVisible(tp);
    }

    public void back() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if ((node = node.getPreviousNode()) == null) {
            return;
        }
        TreePath tp = new TreePath(((DefaultTreeModel)this.tree.getModel()).getPathToRoot(node));
        this.tree.setSelectionPath(tp);
        this.tree.scrollPathToVisible(tp);
    }

    public void forward() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if ((node = node.getNextNode()) == null) {
            return;
        }
        TreePath tp = new TreePath(((DefaultTreeModel)this.tree.getModel()).getPathToRoot(node));
        this.tree.setSelectionPath(tp);
        this.tree.scrollPathToVisible(tp);
    }

    public static void setView(int id) {
        if (id == 0) {
            SHOW_GENEDITOR = true;
            SHOW_WORKEDITOR = true;
            SHOW_EVALEDITOR = true;
            SHOW_EVALPLAYER = true;
            return;
        }
        SHOW_GENEDITOR = false;
        SHOW_WORKEDITOR = false;
        SHOW_EVALEDITOR = false;
        SHOW_EVALPLAYER = false;
        switch (id) {
            case 1: {
                SHOW_GENEDITOR = true;
                break;
            }
            case 2: {
                SHOW_WORKEDITOR = true;
                break;
            }
            case 3: {
                SHOW_EVALEDITOR = true;
                break;
            }
            case 4: {
                SHOW_EVALPLAYER = true;
            }
        }
    }

    private DefaultMutableTreeNode createTree() {
        DefaultMutableTreeNode top = null;
        DefaultMutableTreeNode cat1 = null;
        DefaultMutableTreeNode cat2 = null;
        DefaultMutableTreeNode cat3 = null;
        top = new DefaultMutableTreeNode(new HelpInfo("MA & DA", "main.html"));
        cat1 = new DefaultMutableTreeNode(new HelpInfo("Einf\u00fchrung", "introduction/main.html"));
        top.add(cat1);
        cat2 = new DefaultMutableTreeNode(new HelpInfo("Operationen & Teiloperationen", "introduction/opasubop/main.html"));
        cat1.add(cat2);
        cat3 = new DefaultMutableTreeNode(new HelpInfo("Fibonacci-Heap", "introduction/opasubop/fibheap.html"));
        cat2.add(cat3);
        cat3 = new DefaultMutableTreeNode(new HelpInfo("Binomial-Queue", "introduction/opasubop/binqueue.html"));
        cat2.add(cat3);
        cat2 = new DefaultMutableTreeNode(new HelpInfo("Interaktion", "introduction/interaction.html"));
        cat1.add(cat2);
        if (SHOW_GENEDITOR) {
            cat1 = new DefaultMutableTreeNode(new HelpInfo("GenEditor", "geneditor/main.html"));
            top.add(cat1);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Interaktion", "geneditor/interaction/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fibonacci-Heap", "geneditor/interaction/fibheap.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Binomial-Queue", "geneditor/interaction/binqueue.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Die Reiter", "geneditor/tabs/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Exercise", "geneditor/tabs/exercise.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Operations", "geneditor/tabs/operations.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Ratings", "geneditor/tabs/ratings.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("1st Init", "geneditor/tabs/1stinit.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("2nd Scramble", "geneditor/tabs/2ndscramble.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("3rd AutoGen", "geneditor/tabs/3rdautogen.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Aufgabenerstellung", "geneditor/exercisecreation/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Normal-Mode", "geneditor/exercisecreation/normalmode.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fault-Mode", "geneditor/exercisecreation/faultmode.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Automatische Generierung", "geneditor/exercisecreation/automatic.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Wechseln des PlugIns", "geneditor/changeplugin.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Speichern von Aufgaben", "geneditor/saveexercise.html"));
            cat1.add(cat2);
        }
        if (SHOW_GENEDITOR) {
            cat1 = new DefaultMutableTreeNode(new HelpInfo("AutoGenerator", "autogenerator/main.html"));
            top.add(cat1);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Parameter", "autogenerator/parameter.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Automatische Speicherung", "autogenerator/autosave.html"));
            cat1.add(cat2);
        }
        if (SHOW_WORKEDITOR) {
            cat1 = new DefaultMutableTreeNode(new HelpInfo("WorkEditor", "workeditor/main.html"));
            top.add(cat1);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Interaktion", "workeditor/interaction/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fibonacci-Heap", "workeditor/interaction/fibheap.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Binomial-Queue", "workeditor/interaction/binqueue.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Aufgabentypen", "workeditor/extypes/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Normal-Mode", "workeditor/extypes/normalmode.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fault-Mode", "workeditor/extypes/faultmode.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Task-Bereich", "workeditor/taskpanel.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Feedback-Bereich", "workeditor/feedbackpanel.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Anzeige durchgef\u00fchrter Operationen", "workeditor/executedoperations.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Anfordern von Aufgaben", "workeditor/requestexercise.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Aufgabe bearbeiten", "workeditor/workonexercise/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Normal-Mode", "workeditor/workonexercise/normalmode.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fault-Mode", "workeditor/workonexercise/faultmode.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Feedback-Typen", "workeditor/feedback/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Immediate Feedback & Error Correction", "workeditor/feedback/ifaec.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Error Flagging", "workeditor/feedback/errorflagging.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Demand-Feedback", "workeditor/feedback/demandfeedback.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("NoTutor", "workeditor/feedback/notutor.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Fault-Feedback", "workeditor/feedback/faultfeedback.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Speichern/Laden von Aufgaben", "workeditor/loadsaveexercise.html"));
            cat1.add(cat2);
        }
        if (SHOW_EVALEDITOR) {
            cat1 = new DefaultMutableTreeNode(new HelpInfo("EvalEditor", "evaleditor/main.html"));
            top.add(cat1);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Anzeige der durchgef\u00fchrten Operationen", "evaleditor/executedoperations.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Operationskommentar", "evaleditor/operationcomment.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("JEDAS-Annotationen", "evaleditor/jedasannotation/main.html"));
            cat1.add(cat2);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Notes-Fenster", "evaleditor/jedasannotation/noteswindow.html"));
            cat2.add(cat3);
            cat3 = new DefaultMutableTreeNode(new HelpInfo("Record-Fenster", "evaleditor/jedasannotation/recordwindow.html"));
            cat2.add(cat3);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Aufgaben tutoriell evaluieren", "evaleditor/tutorevaluation.html"));
            cat1.add(cat2);
        }
        if (SHOW_EVALPLAYER) {
            cat1 = new DefaultMutableTreeNode(new HelpInfo("EvalPlayer", "evalplayer/main.html"));
            top.add(cat1);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Durchgef\u00fchrte Operationen", "evalplayer/executedoperations.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Operationskommentar", "evalplayer/operationcomment.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Geschwindigkeits-Regler", "evalplayer/speedslider.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Zeit-Regler", "evalplayer/timeslider.html"));
            cat1.add(cat2);
            cat2 = new DefaultMutableTreeNode(new HelpInfo("Abspielen einer Aufgabe", "evalplayer/playexercise.html"));
            cat1.add(cat2);
        }
        return top;
    }
}

