/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import jedas.CompObj;
import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import mauda.Exercise;
import mauda.plugin.JedasMainCompObj;

public class AutomaticZoomThread
extends Thread {
    private static int updateInterval = 1000;
    private static int currentTime;
    private static int sleepTime;
    private static Exercise exercise;
    private boolean stopThread;
    private static boolean enabled;
    private static double minx;
    private static double miny;
    private static double maxx;
    private static double maxy;
    private static int itemCounter;

    static {
        sleepTime = 100;
        enabled = false;
    }

    public AutomaticZoomThread() {
        exercise = null;
        this.stopThread = false;
    }

    public void run() {
        block2: while (!this.stopThread) {
            currentTime = 0;
            AutomaticZoomThread.forceZoom(exercise);
            while (currentTime <= updateInterval) {
                if (this.stopThread) continue block2;
                currentTime += sleepTime;
                try {
                    AutomaticZoomThread.sleep(sleepTime);
                }
                catch (Exception ex) {
                    System.err.println("AutomaticZoomThread.run(): sleep-Exception");
                }
            }
        }
        AutomaticZoomThread.forceZoom(exercise);
    }

    public void startZooming(Exercise ex) {
        exercise = ex;
        this.stopThread = false;
        this.start();
    }

    public void stopZooming() {
        this.stopThread = true;
    }

    public static void forceZoom(Exercise ex) {
        if (!enabled) {
            return;
        }
        exercise = ex;
        if (exercise == null) {
            return;
        }
        boolean running = false;
        if (Exercise.scheduler.isRunning()) {
            running = true;
        }
        if (running) {
            Exercise.scheduler.suspend();
        }
        AutomaticZoomThread.adjustZoom();
        Jedas.updateDisplay();
        if (running) {
            Exercise.scheduler.resume();
        }
        currentTime = 0;
    }

    public static void setEnabled(boolean en) {
        enabled = en;
        if (!enabled) {
            Exercise.compPanel.setZoom(1.0);
            Exercise.compPanel.setHotSpot(new DPair(0.5, 0.5));
            Jedas.updateDisplay();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static void adjustZoom() {
        CompObj compObj = ((JedasMainCompObj)exercise.getDSObject()).getMainCompObj();
        long timeMillis = System.currentTimeMillis();
        minx = Double.MAX_VALUE;
        miny = Double.MAX_VALUE;
        maxx = Double.MIN_VALUE;
        maxy = Double.MIN_VALUE;
        itemCounter = 0;
        AutomaticZoomThread.calculateBBox(0.0, 0.0, compObj);
        DPair pos = new DPair(minx -= 0.05, miny -= 0.05);
        DPair size = new DPair((maxx += 0.05) - minx, (maxy += 0.05) - miny);
        double dx = maxx - minx;
        double dy = maxy - miny;
        double x = dx / 2.0 + minx;
        double y = dy / 2.0 + miny;
        double zoom = 0.0;
        zoom = dx > dy ? 1.0 / dx : 1.0 / dy;
        Exercise.compPanel.setZoom(zoom);
        Exercise.compPanel.setHotSpot(new DPair(x, y));
        timeMillis = System.currentTimeMillis() - timeMillis;
    }

    private static void calculateBBox(double ox, double oy, CompObj co) {
        DPair copos = co.getPos();
        double cox = copos.get(0);
        double coy = copos.get(1);
        Item item = co.getFirstItem();
        while (item != null) {
            if (item instanceof CompObj) {
                AutomaticZoomThread.calculateBBox(ox + cox, oy + coy, (CompObj)item);
            } else {
                DPair p = item.getPos();
                AutomaticZoomThread.updateBBox(ox + p.get(0), oy + p.get(1));
                DPair s = item.getSize();
                double x = p.get(0) + s.get(0);
                double y = p.get(1) + s.get(1);
                AutomaticZoomThread.updateBBox(ox + x, oy + y);
            }
            item = co.getNextItem();
        }
    }

    private static void updateBBox(double x, double y) {
        ++itemCounter;
        if (x < minx) {
            minx = x;
        }
        if (y < miny) {
            miny = y;
        }
        if (x > maxx) {
            maxx = x;
        }
        if (y > maxy) {
            maxy = y;
        }
    }
}

