/*
 * Decompiled with CFR 0.152.
 */
package mauda;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mauda.Difficulties;
import mauda.ExerciseMode;
import mauda.MAUDA;
import mauda.utils.Prop;

public class MetaData {
    public static final int ALL = 0;
    public static final int CREATOR = 1;
    public static final int EDITOR = 2;
    public static final int EVALUATOR = 3;
    private static int displayMode = 0;
    private String type = "unknown";
    private int difficulty = -1;
    private int mode = 0;
    private String source = "Generator";
    private String date = this.getActualDateTime();
    private int initRating = -1;
    private int todoRating = -1;
    private String comment = "";
    private String editorName = "";
    private String editorDate = "";
    private String editorState = "unworked";
    private String editorFeedback = "";
    private String editorComment = "";
    private String evaluatorName = "";
    private String evaluatorDate = "";
    private String evaluatorState = "not evaluated";
    private String evaluatorScore = "";
    private String evaluatorJEAFilename = "";
    private String evaluatorComment = "";

    public static void setDisplayMode(int m) {
        displayMode = m;
    }

    public static int getDisplayMode() {
        return displayMode;
    }

    public String getPreviewString() {
        String msg = String.valueOf(this.type) + "\n";
        msg = String.valueOf(msg) + Difficulties.getString(this.difficulty) + "\n";
        msg = String.valueOf(msg) + ExerciseMode.getString(this.mode) + "\n";
        switch (displayMode) {
            case 1: {
                msg = String.valueOf(msg) + this.source + "\n" + this.date + "\n" + this.comment;
                break;
            }
            case 2: {
                msg = String.valueOf(msg) + this.editorName + "\n" + this.editorDate + "\n" + this.editorState + "\n" + this.editorFeedback + "\n" + this.editorComment;
                break;
            }
            case 3: {
                msg = String.valueOf(msg) + this.evaluatorName + "\n" + this.evaluatorDate + "\n" + this.evaluatorState + "\n" + this.evaluatorScore + "\n" + this.evaluatorComment;
                break;
            }
            default: {
                msg = String.valueOf(msg) + "ERROR";
            }
        }
        return msg;
    }

    private String getActualDateTime() {
        Calendar c = Calendar.getInstance();
        int day = c.get(5);
        int month = c.get(2) + 1;
        int year = c.get(1);
        String s = String.valueOf(day < 10 ? "0" : "") + day + "." + (month < 10 ? "0" : "") + month + "." + year;
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        String time = String.valueOf(hour < 10 ? "0" : "") + hour + ":" + (min < 10 ? "0" : "") + min + ":" + (sec < 10 ? "0" : "") + sec;
        s = String.valueOf(s) + " " + time;
        return s;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void setDifficulty(int d) {
        this.difficulty = d;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public int getMode() {
        return this.mode;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public void setInitRating(int r) {
        this.initRating = r;
    }

    private int getInitRating() {
        return this.initRating;
    }

    public void setTodoRating(int r) {
        this.todoRating = r;
    }

    private int getTodoRating() {
        return this.todoRating;
    }

    public void setComment(String c) {
        this.comment = c;
    }

    public void setEditorName(String n) {
        this.editorName = n;
    }

    public void actualizeEditorDate() {
        this.editorDate = this.getActualDateTime();
    }

    public void setEditorState(String s) {
        this.editorState = s;
    }

    public String getEditorState() {
        return this.editorState;
    }

    public void setEditorFeedback(String s) {
        this.editorFeedback = s;
    }

    public String getEditorFeedback() {
        return this.editorFeedback;
    }

    public void setEvaluatorName(String s) {
        this.evaluatorName = s;
    }

    public String getEvaluatorName() {
        return this.evaluatorName;
    }

    public void actualizeEvaluatorDate() {
        this.evaluatorDate = this.getActualDateTime();
    }

    public void setEvaluatorState(String s) {
        this.evaluatorState = s;
    }

    public String getEvaluatorState() {
        return this.evaluatorState;
    }

    public void setEvaluatorScore(String s) {
        this.evaluatorScore = s;
    }

    public void setEvaluatorJEAFilename(String s) {
        this.evaluatorJEAFilename = s;
    }

    public String getEvaluatorJEAFilename() {
        return this.evaluatorJEAFilename;
    }

    public HashMap save() {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("Type", this.type);
        meta.put("Difficulty", Difficulties.getString(this.difficulty));
        meta.put("Mode", ExerciseMode.getString(this.mode));
        meta.put("Source", this.source);
        meta.put("Date", this.date);
        meta.put("Rating", String.valueOf(this.initRating) + " / " + this.todoRating);
        meta.put("Comment", this.comment);
        meta.put("EditorName", this.editorName);
        meta.put("EditorDate", this.editorDate);
        meta.put("EditorState", this.editorState);
        meta.put("EditorFeedback", this.editorFeedback);
        meta.put("EditorComment", this.editorComment);
        meta.put("EvaluatorName", this.evaluatorName);
        meta.put("EvaluatorDate", this.evaluatorDate);
        meta.put("EvaluatorState", this.evaluatorState);
        meta.put("EvaluatorScore", this.evaluatorScore);
        meta.put("EvaluatorJEAFilename", this.evaluatorJEAFilename);
        meta.put("EvaluatorComment", this.evaluatorComment);
        return meta;
    }

    public void load(Object o) {
        HashMap meta = (HashMap)o;
        this.type = (String)meta.get("Type");
        this.difficulty = Difficulties.getID((String)meta.get("Difficulty"));
        this.mode = ExerciseMode.getID((String)meta.get("Mode"));
        this.source = (String)meta.get("Source");
        this.date = (String)meta.get("Date");
        String ratings = (String)meta.get("Rating");
        StringTokenizer st = new StringTokenizer(ratings);
        this.initRating = Integer.parseInt(st.nextToken());
        String dummy = st.nextToken();
        this.todoRating = Integer.parseInt(st.nextToken());
        this.comment = (String)meta.get("Comment");
        this.editorName = (String)meta.get("EditorName");
        this.editorDate = (String)meta.get("EditorDate");
        this.editorState = (String)meta.get("EditorState");
        if (this.editorState == null) {
            this.editorState = "unworked";
        }
        this.editorFeedback = (String)meta.get("EditorFeedback");
        this.editorComment = (String)meta.get("EditorComment");
        this.evaluatorName = (String)meta.get("EvaluatorName");
        this.evaluatorDate = (String)meta.get("EvaluatorDate");
        this.evaluatorState = (String)meta.get("EvaluatorState");
        if (this.evaluatorState == null) {
            this.evaluatorState = "not evaluated";
        }
        this.evaluatorScore = (String)meta.get("EvaluatorScore");
        this.evaluatorJEAFilename = (String)meta.get("EvaluatorJEAFilename");
        this.evaluatorComment = (String)meta.get("EvaluatorComment");
    }

    public boolean inputDialog() {
        HashMap restoreMetaData = this.save();
        JTextField typeIn = new JTextField(this.type, 24);
        typeIn.setEditable(false);
        JTextField difficultyIn = new JTextField(Difficulties.getString(this.difficulty), 24);
        difficultyIn.setEditable(false);
        JTextField modeIn = new JTextField(ExerciseMode.getString(this.mode), 24);
        modeIn.setEditable(false);
        JTextField sourceIn = new JTextField(this.source);
        JTextField dateIn = new JTextField(this.date);
        JTextField ratingIn = new JTextField(String.valueOf(this.initRating) + " / " + this.todoRating);
        ratingIn.setEditable(false);
        JTextArea commentIn = new JTextArea(this.comment, 5, 24);
        commentIn.setLineWrap(true);
        JTextField editorNameIn = new JTextField(this.editorName);
        JTextField editorDateIn = new JTextField(this.editorDate);
        JTextField editorStateIn = new JTextField(this.editorState);
        editorStateIn.setEditable(false);
        JTextField editorFeedbackIn = new JTextField(this.editorFeedback);
        editorFeedbackIn.setEditable(false);
        JTextArea editorCommentIn = new JTextArea(this.editorComment, 5, 24);
        editorCommentIn.setLineWrap(true);
        JTextField evaluatorNameIn = new JTextField(this.evaluatorName);
        JTextField evaluatorDateIn = new JTextField(this.evaluatorDate);
        JTextField evaluatorStateIn = new JTextField(this.evaluatorState);
        evaluatorStateIn.setEditable(false);
        JTextField evaluatorScoreIn = new JTextField(this.evaluatorScore);
        JTextField evaluatorJEAFilenameIn = new JTextField(this.evaluatorJEAFilename);
        JTextArea evaluatorCommentIn = new JTextArea(this.evaluatorComment, 5, 24);
        evaluatorCommentIn.setLineWrap(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gbl);
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataType")), gbl, c, 0, 0, 1, 1));
        p.add(this.newGridElement(typeIn, gbl, c, 1, 0, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataDifficulty")), gbl, c, 0, 1, 1, 1));
        p.add(this.newGridElement(difficultyIn, gbl, c, 1, 1, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataMode")), gbl, c, 0, 2, 1, 1));
        p.add(this.newGridElement(modeIn, gbl, c, 1, 2, 1, 1));
        mainPanel.add((Component)p, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        mainPanel.add((Component)tabbedPane, "Center");
        p = new JPanel();
        gbl = new GridBagLayout();
        c = new GridBagConstraints();
        p.setLayout(gbl);
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataSource")), gbl, c, 0, 0, 1, 1));
        p.add(this.newGridElement(sourceIn, gbl, c, 1, 0, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataDate")), gbl, c, 0, 1, 1, 1));
        p.add(this.newGridElement(dateIn, gbl, c, 1, 1, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataRating")), gbl, c, 0, 2, 1, 1));
        p.add(this.newGridElement(ratingIn, gbl, c, 1, 2, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataComment")), gbl, c, 0, 3, 1, 1));
        p.add(this.newGridElement(new JScrollPane(commentIn), gbl, c, 1, 3, 1, 1));
        tabbedPane.add(Prop.get(this, "MetaDataCreatorTab"), p);
        p = new JPanel();
        gbl = new GridBagLayout();
        c = new GridBagConstraints();
        p.setLayout(gbl);
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEditorName")), gbl, c, 0, 0, 1, 1));
        p.add(this.newGridElement(editorNameIn, gbl, c, 1, 0, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEditorDate")), gbl, c, 0, 1, 1, 1));
        p.add(this.newGridElement(editorDateIn, gbl, c, 1, 1, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEditorState")), gbl, c, 0, 2, 1, 1));
        p.add(this.newGridElement(editorStateIn, gbl, c, 1, 2, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEditorFeedback")), gbl, c, 0, 3, 1, 1));
        p.add(this.newGridElement(editorFeedbackIn, gbl, c, 1, 3, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEditorComment")), gbl, c, 0, 4, 1, 1));
        p.add(this.newGridElement(new JScrollPane(editorCommentIn), gbl, c, 1, 4, 1, 1));
        tabbedPane.add(Prop.get(this, "MetaDataEditorTab"), p);
        p = new JPanel();
        gbl = new GridBagLayout();
        c = new GridBagConstraints();
        p.setLayout(gbl);
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorName")), gbl, c, 0, 0, 1, 1));
        p.add(this.newGridElement(evaluatorNameIn, gbl, c, 1, 0, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorDate")), gbl, c, 0, 1, 1, 1));
        p.add(this.newGridElement(evaluatorDateIn, gbl, c, 1, 1, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorState")), gbl, c, 0, 2, 1, 1));
        p.add(this.newGridElement(evaluatorStateIn, gbl, c, 1, 2, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorJEAFilename")), gbl, c, 0, 3, 1, 1));
        p.add(this.newGridElement(evaluatorJEAFilenameIn, gbl, c, 1, 3, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorScore")), gbl, c, 0, 4, 1, 1));
        p.add(this.newGridElement(evaluatorScoreIn, gbl, c, 1, 4, 1, 1));
        p.add(this.newGridElement(new JLabel(Prop.get(this, "MetaDataEvaluatorComment")), gbl, c, 0, 5, 1, 1));
        p.add(this.newGridElement(new JScrollPane(evaluatorCommentIn), gbl, c, 1, 5, 1, 1));
        tabbedPane.add(Prop.get(this, "MetaDataEvaluatorTab"), p);
        if (displayMode != 0) {
            if (displayMode != 1) {
                sourceIn.setEditable(false);
                dateIn.setEditable(false);
                ratingIn.setEditable(false);
                commentIn.setEditable(false);
            }
            if (displayMode != 2) {
                editorNameIn.setEditable(false);
                editorDateIn.setEditable(false);
                editorStateIn.setEditable(false);
                editorFeedbackIn.setEditable(false);
                editorCommentIn.setEditable(false);
            }
            if (displayMode != 3) {
                evaluatorNameIn.setEditable(false);
                evaluatorDateIn.setEditable(false);
                evaluatorStateIn.setEditable(false);
                evaluatorScoreIn.setEditable(false);
                evaluatorJEAFilenameIn.setEditable(false);
                evaluatorCommentIn.setEditable(false);
            }
        }
        int index = 0;
        switch (displayMode) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
            }
        }
        tabbedPane.setSelectedIndex(index);
        String title = Prop.get(this, "MetaDataTitle");
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), mainPanel, title, 2, 1);
        if (result == 0) {
            this.source = sourceIn.getText();
            this.date = dateIn.getText();
            this.comment = commentIn.getText();
            this.editorName = editorNameIn.getText();
            this.editorDate = editorDateIn.getText();
            this.editorState = editorStateIn.getText();
            this.editorFeedback = editorFeedbackIn.getText();
            this.editorComment = editorCommentIn.getText();
            this.evaluatorName = evaluatorNameIn.getText();
            this.evaluatorDate = evaluatorDateIn.getText();
            this.evaluatorState = evaluatorStateIn.getText();
            this.evaluatorScore = evaluatorScoreIn.getText();
            this.evaluatorJEAFilename = evaluatorJEAFilenameIn.getText();
            this.evaluatorComment = evaluatorCommentIn.getText();
            HashMap nowMetaData = this.save();
            if (!restoreMetaData.equals(nowMetaData)) {
                return true;
            }
        }
        return false;
    }

    private JComponent newGridElement(JComponent comp, GridBagLayout gbl, GridBagConstraints c, int gx, int gy, int gw, int gh) {
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        gbl.setConstraints(comp, c);
        return comp;
    }
}

