/*
 * Decompiled with CFR 0.152.
 */
package mauda.evaluation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jedas.Jedas;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.evaluation.OpTimeStamp;
import mauda.evaluation.PlayerExercise;

public class TimeStampRecorder
implements ExerciseUpdateListener {
    public static final long timeExtend = 1L;
    private Exercise exercise;
    private boolean finishedLoading;
    private boolean playerMode;
    private Vector timeStamps;
    private int position;
    private int oldPosition;
    private int suspendPosition;
    private Vector seqTimeStamps;

    public TimeStampRecorder(Exercise exercise) {
        this.exercise = exercise;
        this.finishedLoading = false;
        this.position = -1;
        this.oldPosition = -1;
        this.timeStamps = new Vector();
        this.playerMode = false;
        this.seqTimeStamps = null;
    }

    public void setPlayerMode(boolean b) {
        this.playerMode = b;
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 4) {
            this.finishedLoading = true;
            return;
        }
        if (!this.finishedLoading) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                break;
            }
            case 14: {
                ++this.position;
                this.storeStopStartTimeStamp();
                break;
            }
            case 7: {
                --this.position;
                break;
            }
            case 8: {
                ++this.position;
                this.storeStopStartTimeStamp();
                break;
            }
            case 10: {
                this.finishedLoading = false;
                this.position = -1;
                this.oldPosition = -1;
                this.timeStamps.removeAllElements();
                break;
            }
            case 12: {
                this.storeStopTimeStamp(this.oldPosition, this.getRecordingTime());
                this.oldPosition = -1;
                this.position += e.getValue();
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                OpTimeStamp ots1 = (OpTimeStamp)this.timeStamps.elementAt(this.position);
                ots1.addStop(this.getRecordingTime());
                this.suspendPosition = this.position;
                break;
            }
            case 16: {
                OpTimeStamp ots2 = (OpTimeStamp)this.timeStamps.elementAt(this.suspendPosition);
                ots2.addStart(this.getRecordingTime());
                break;
            }
        }
    }

    private long getRecordingTime() {
        long timeStamp = 0L;
        if (Jedas.isRecording()) {
            timeStamp = Jedas.getRecordTime();
        }
        return timeStamp * 1L;
    }

    private void storeStopStartTimeStamp() {
        if (this.playerMode) {
            return;
        }
        long timeStamp = this.getRecordingTime();
        this.storeStopTimeStamp(this.oldPosition, timeStamp);
        this.oldPosition = this.position;
        OpTimeStamp ots = null;
        if (this.position >= this.timeStamps.size()) {
            ots = new OpTimeStamp();
            this.timeStamps.add(ots);
        } else {
            ots = (OpTimeStamp)this.timeStamps.elementAt(this.position);
        }
        ots.clear();
        ots.addStart(timeStamp);
    }

    private void storeStopTimeStamp(int p, long timeStamp) {
        if (this.playerMode) {
            return;
        }
        if (p >= 0 && p < this.timeStamps.size()) {
            OpTimeStamp oldots = (OpTimeStamp)this.timeStamps.elementAt(p);
            oldots.addStop(timeStamp);
        }
    }

    public OpTimeStamp getEntry(int offset) {
        if (offset < 0 || offset >= this.timeStamps.size()) {
            return null;
        }
        return (OpTimeStamp)this.timeStamps.elementAt(offset);
    }

    public OpTimeStamp getSeqEntry(int offset) {
        if (offset < 0 || offset >= this.seqTimeStamps.size()) {
            return null;
        }
        return (OpTimeStamp)this.seqTimeStamps.elementAt(offset);
    }

    public OpTimeStamp getActOpTimeStamp() {
        return this.getEntry(this.position);
    }

    public void calculateSeqTimeStamps() {
        long animLength = ((PlayerExercise)this.exercise).getJedasPlayer().getJedasAnimation().animLength;
        long seqTime = 1L;
        this.seqTimeStamps = new Vector();
        Enumeration en = this.timeStamps.elements();
        while (en.hasMoreElements()) {
            OpTimeStamp ots = (OpTimeStamp)en.nextElement();
            Vector v = ots.getTimeStamps();
            OpTimeStamp seqots = new OpTimeStamp();
            Enumeration en2 = v.elements();
            while (en2.hasMoreElements()) {
                long start = (Long)en2.nextElement();
                long end = animLength * 1L;
                if (en2.hasMoreElements()) {
                    end = (Long)en2.nextElement();
                }
                seqots.addStart(seqTime);
                seqots.addStart(seqTime += end - start);
                ++seqTime;
                if (end != animLength) continue;
                ots.addStop(animLength);
                break;
            }
            this.seqTimeStamps.add(seqots);
        }
    }

    public Vector getTimeStamps() {
        return this.timeStamps;
    }

    public Vector getSeqTimeStamps() {
        return this.seqTimeStamps;
    }

    public void printSeqTimeStamps() {
        System.out.println("TimeStampRecorder.printSeqTimeStamps():");
        int counter = 0;
        Enumeration en = this.seqTimeStamps.elements();
        while (en.hasMoreElements()) {
            System.out.println(" " + ++counter + ". Operation:");
            OpTimeStamp ots = (OpTimeStamp)en.nextElement();
            Vector v = ots.getTimeStamps();
            Enumeration en2 = v.elements();
            while (en2.hasMoreElements()) {
                long start = (Long)en2.nextElement();
                long end = (Long)en2.nextElement();
                System.out.println("   " + start + " - " + end);
            }
        }
    }

    public Vector save() {
        Vector<HashMap> v = new Vector<HashMap>();
        Enumeration en = this.timeStamps.elements();
        while (en.hasMoreElements()) {
            OpTimeStamp ots = (OpTimeStamp)en.nextElement();
            v.add(ots.save());
        }
        return v;
    }

    public void load(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            HashMap hm = (HashMap)en.nextElement();
            OpTimeStamp ots = new OpTimeStamp();
            ots.load(hm);
            this.timeStamps.add(ots);
        }
    }
}

