/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mauda.OperationRecorder;
import mauda.feedback.Evaluator;
import mauda.feedback.FeedbackObject;
import mauda.operation.Operation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;

public class FaultEvaluator
extends Evaluator {
    private static final double falseCorrectWeight = 1.0;
    private static final double falseNotFirstWeight = 0.5;
    private static final double falseWeight = 1.0;
    private static final double falseFailureTypeRating = 0.5;
    public static final int SEARCH_FAILURE = 0;
    public static final int FIRST_FAILURE_FOUND = 1;
    public static final int FALSE_CORRECT = 2;
    public static final int FALSE_NOT_FIRST = 3;
    public static final int FALSE_FAILURE_TYPE_SELECTED = 4;
    public static final int CORRECT_MODE = 5;
    public static final int GIVE_UP = 6;
    private int state = 0;
    private Vector falseCorrectFeedbackObjects = new Vector();
    private Vector falseNotFirstFeedbackObjects = new Vector();
    private Vector falseFeedbackObjects = new Vector();
    private int falseFailureTypeCounter = 0;

    private double calculatePoints(Vector v, double weight) {
        double errorPoints = 0.0;
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            FeedbackObject fo = (FeedbackObject)en.nextElement();
            switch (fo.getCorrectness()) {
                case 3: {
                    errorPoints += 1.0 * weight;
                    ++this.errorCounter;
                    break;
                }
                case 1: 
                case 2: {
                    SubOperation cso = fo.getCorrectSubOperation();
                    int r = 1;
                    if (cso != null) {
                        r = (Integer)this.ratings.get(cso.getID());
                    }
                    errorPoints += (double)r * weight;
                }
            }
        }
        return errorPoints;
    }

    public void postProcessing(Vector v) {
        int counter = -1;
        int opnr = -1;
        int subopnr = -1;
        while (counter < v.size()) {
            if (++counter >= v.size()) break;
            Object o = v.elementAt(counter);
            if (!(o instanceof Operation)) continue;
            ++opnr;
            Operation op = (Operation)o;
            SubOperationQueue csoq = op.getSubOperationQueue();
            SubOperationQueue asoq = new SubOperationQueue();
            if (++counter < v.size()) {
                o = v.elementAt(counter);
                while (counter < v.size() && o instanceof SubOperation) {
                    asoq.add((SubOperation)o);
                    if (++counter >= v.size()) break;
                    o = v.elementAt(counter);
                }
            }
            --counter;
            this.maxPoints += 1.0;
            int i = 0;
            while (i < asoq.length()) {
                SubOperation aso = asoq.get(i);
                int r = (Integer)this.ratings.get(aso.getID());
                this.maxPoints += (double)r;
                ++i;
            }
        }
    }

    public void evaluate(OperationRecorder or) {
        if (this.state == 6) {
            return;
        }
        double fc = this.calculatePoints(this.falseCorrectFeedbackObjects, 1.0);
        double fnf = this.calculatePoints(this.falseNotFirstFeedbackObjects, 0.5);
        double f = this.calculatePoints(this.falseFeedbackObjects, 1.0);
        this.errorPoints = fc + fnf + f;
        this.errorPoints += (double)this.falseFailureTypeCounter * 0.5;
        if (this.errorPoints > this.maxPoints) {
            this.errorPoints = this.maxPoints;
        }
        this.errorCounter += this.falseCorrectFeedbackObjects.size();
        this.errorCounter += this.falseNotFirstFeedbackObjects.size();
        this.errorCounter += this.falseFeedbackObjects.size();
    }

    public void log(FeedbackObject fo) {
        Vector v = null;
        switch (this.state) {
            case 2: {
                v = this.falseCorrectFeedbackObjects;
                break;
            }
            case 3: {
                v = this.falseNotFirstFeedbackObjects;
                break;
            }
            case 5: {
                v = this.falseFeedbackObjects;
            }
        }
        if (!v.contains(fo)) {
            v.add(fo);
        }
    }

    public void log(int id) {
        String s = "";
        switch (id) {
            case 0: {
                s = "SEARCH_FAILURE";
                break;
            }
            case 1: {
                s = "FIRST_FAILURE_FOUND";
                break;
            }
            case 2: {
                s = "FALSE_CORRECT";
                break;
            }
            case 3: {
                s = "FALSE_NOT_FIRST";
                break;
            }
            case 4: {
                s = "FALSE_FAILURE_TYPE_SELECTED";
                break;
            }
            case 5: {
                s = "GO_IN_CORRECT_MODE";
            }
        }
        if (id == 4) {
            ++this.falseFailureTypeCounter;
        }
        this.state = id;
    }

    public String getHTMLMessage() {
        String msg = "";
        if (this.state == 6) {
            msg = String.valueOf(msg) + "Exercise was given up!<br><br>";
            msg = String.valueOf(msg) + "You have reached 0 points.<br>";
            return msg;
        }
        this.percent = this.doubleRound((this.maxPoints - this.errorPoints) / this.maxPoints * 100.0);
        msg = String.valueOf(msg) + "<table width=100%><tr><td>Score:</td><td align=right>";
        msg = String.valueOf(msg) + "<big><b>" + this.percent + "</b></big> of 100";
        msg = String.valueOf(msg) + "</td></tr></table>";
        msg = String.valueOf(msg) + "<hr>";
        msg = String.valueOf(msg) + "You have made " + this.errorCounter + " errors.<br>";
        msg = String.valueOf(msg) + this.falseCorrectFeedbackObjects.size() + " times you think a operation was incorrect although the operation was correct.<br>";
        msg = String.valueOf(msg) + this.falseNotFirstFeedbackObjects.size() + " times you found a non first failure.<br>";
        msg = String.valueOf(msg) + this.falseFailureTypeCounter + " attemps you needed to specify the type of the failure.<br>";
        msg = String.valueOf(msg) + this.falseFeedbackObjects.size() + " tries you needed to specify the correct operation.<br>";
        msg = String.valueOf(msg) + this.doubleRound(this.maxPoints) + " are the maximal reachable points in this exercise.<br>";
        msg = String.valueOf(msg) + "You have reached " + this.doubleRound(this.maxPoints - this.errorPoints) + " points.<br>";
        return msg;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int id) {
        this.state = id;
    }

    public HashMap save() {
        HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
        hm.put("FalseCorrectFeedbackObjects", this.saveFeedbackObjects(this.falseCorrectFeedbackObjects));
        hm.put("FalseNotFirstFeedbackObjects", this.saveFeedbackObjects(this.falseNotFirstFeedbackObjects));
        hm.put("FalseFeedbackObjects", this.saveFeedbackObjects(this.falseFeedbackObjects));
        hm.put("State", new Integer(this.state));
        hm.put("FalseFailureTypeCounter", new Integer(this.falseFailureTypeCounter));
        return hm;
    }

    public void load(HashMap hm) {
        this.falseCorrectFeedbackObjects = this.loadFeedbackObjects((Vector)hm.get("FalseCorrectFeedbackObjects"));
        this.falseNotFirstFeedbackObjects = this.loadFeedbackObjects((Vector)hm.get("FalseNotFirstFeedbackObjects"));
        this.falseFeedbackObjects = this.loadFeedbackObjects((Vector)hm.get("FalseFeedbackObjects"));
        this.state = (Integer)hm.get("State");
        this.falseFailureTypeCounter = (Integer)hm.get("FalseFailureTypeCounter");
    }
}

