/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.util.Vector;
import javax.swing.JOptionPane;
import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.MAUDA;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackKB;
import mauda.feedback.FeedbackKBObject;
import mauda.feedback.FeedbackObject;
import mauda.operation.Operation;
import mauda.operation.SubOperation;
import mauda.plugin.KBFormulaEvaluator;

public class FeedbackGenerator
implements ExerciseUpdateListener {
    private Exercise exercise;
    private FeedbackKB feedbackKB;
    private static KBFormulaEvaluator kbFormulaEvaluator;

    public FeedbackGenerator(Exercise exercise) {
        this.exercise = exercise;
        exercise.addExerciseUpdateListener(this);
        this.loadKB();
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 11) {
            this.loadKB();
        }
    }

    public void loadKB() {
        this.feedbackKB = new FeedbackKB();
        String filename = String.valueOf(this.exercise.getDataDirectory()) + "feedbackkb.txt";
        boolean ok = this.feedbackKB.load(filename);
        if (!ok) {
            JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Error while loading Feedback-Knowledge-Base:\n" + filename);
            return;
        }
    }

    public static void setKBFormulaEvaluator(KBFormulaEvaluator kbfe) {
        kbFormulaEvaluator = kbfe;
    }

    public KBFormulaEvaluator getKBFormulaEvaluator() {
        return kbFormulaEvaluator;
    }

    public FeedbackObject getFeedback() {
        OperationRecorder or = this.exercise.getOperationRecorder();
        int opnr = or.getCurrentOperationNr();
        int subopnr = or.getCurrentSubOperationNr();
        Operation op = or.getOperation(opnr);
        SubOperation so1 = or.getSubOperation(opnr, subopnr);
        SubOperation so2 = or.getCorrectSubOperation(opnr, subopnr);
        FeedbackObject fo = new FeedbackObject();
        fo.setCorrectness(0);
        fo.setOperation(op);
        fo.setSubOperation(so1);
        fo.setCorrectSubOperation(so2);
        fo.setOpNr(opnr);
        fo.setSubOpNr(subopnr);
        if (subopnr > 0) {
            SubOperation pso1 = or.getSubOperation(opnr, subopnr - 1);
            SubOperation pso2 = or.getCorrectSubOperation(opnr, subopnr - 1);
            if (pso2 == null || !pso1.equals(pso2)) {
                fo.setCorrectness(2);
                Vector<String> messages = new Vector<String>();
                messages.add("No feedback for aftereffects available");
                fo.setMessages(messages);
                return fo;
            }
        }
        if (so1 == null) {
            fo.setCorrectness(3);
            Vector<String> messages = new Vector<String>();
            messages.add("You have to perform SubOperations by right-click in the drawing pane!");
            fo.setMessages(messages);
            return fo;
        }
        Vector fkbos = null;
        fkbos = this.feedbackKB.call(kbFormulaEvaluator);
        Vector messages = new Vector();
        FeedbackKBObject fkbo = null;
        int copnr = or.getCurrentOperationNr();
        int csubopnr = or.getCurrentSubOperationNr();
        if (fkbos != null && !fkbos.isEmpty()) {
            fkbo = (FeedbackKBObject)fkbos.firstElement();
            messages = (Vector)fkbo.getMessages().clone();
        } else if (kbFormulaEvaluator.isFinishOperationState()) {
            SubOperation so = or.getCorrectSubOperation(copnr, csubopnr + 1);
            messages.add("Think about what you can have forgotten!");
            messages.add("Missing <i>" + so.getID().toLowerCase() + "</i>.");
        } else {
            messages.add("Dont know what you are doing.");
        }
        int i = 0;
        while (i < messages.size()) {
            String msg = (String)messages.elementAt(i);
            messages.setElementAt(this.makeSubstitutions(msg), i);
            ++i;
        }
        fo.setCorrectness(0);
        if (kbFormulaEvaluator.isFinishOperationState()) {
            fo.setCorrectness(3);
        } else if (so1 != null && so2 != null && so1.equals(so2)) {
            fo.setCorrectness(1);
        } else {
            fo.setCorrectness(2);
        }
        fo.setMessages(messages);
        return fo;
    }

    private String makeSubstitutions(String msg) {
        OperationRecorder or = this.exercise.getOperationRecorder();
        int copnr = or.getCurrentOperationNr();
        if (copnr < 0) {
            return msg;
        }
        int csubopnr = or.getCurrentSubOperationNr();
        Operation op = or.getOperation(copnr);
        SubOperation subop = or.getSubOperation(copnr, csubopnr);
        SubOperation csubop = or.getCorrectSubOperation(copnr, csubopnr);
        Vector<String> k = new Vector<String>();
        Vector<String> v = new Vector<String>();
        if (csubopnr >= 0) {
            if (csubop != null) {
                k.add("CORRECTSUBOPERATIONID");
                v.add(csubop.getID().toLowerCase());
                k.add("CORRECTSUBOPERATION");
                v.add(csubop.out());
                k.add("CORRECTSUBOPPARAM1");
                v.add(String.valueOf(csubop.getParameter1()));
                k.add("CORRECTSUBOPPARAM2");
                v.add(String.valueOf(csubop.getParameter2()));
            } else {
                String s = "'Next Operation'";
                k.add("CORRECTSUBOPERATIONID");
                v.add(s);
                k.add("CORRECTSUBOPERATION");
                v.add(s);
                k.add("CORRECTSUBOPPARAM1");
                v.add(s);
                k.add("CORRECTSUBOPPARAM2");
                v.add(s);
            }
            k.add("SUBOPERATIONID");
            v.add(subop.getID().toLowerCase());
            k.add("SUBOPERATION");
            v.add(subop.out());
            k.add("SUBOPPARAM1");
            v.add(String.valueOf(subop.getParameter1()));
            k.add("SUBOPPARAM2");
            v.add(String.valueOf(subop.getParameter2()));
        }
        k.add("OPERATIONID");
        v.add(op.getID());
        k.add("OPERATION");
        v.add(op.out());
        k.add("OPPARAM1");
        v.add(String.valueOf(op.getParameter1()));
        k.add("OPPARAM2");
        v.add(String.valueOf(op.getParameter2()));
        int i = 0;
        while (i < k.size()) {
            String key = (String)k.elementAt(i);
            String value = (String)v.elementAt(i);
            msg = msg.replaceAll(key, "<i>" + value + "</i>");
            ++i;
        }
        return msg;
    }

    public String genMessage(String img1, String txt1, String img2, String txt2) {
        String msg = "<table border=0 cellpadding=1><tr><td valign=top>";
        if (img1 != null) {
            msg = String.valueOf(msg) + "<img src='./images/" + img1 + "'>";
        }
        msg = String.valueOf(msg) + "</td><td>" + txt1 + "</td></tr>";
        if (img2 != null || txt2 != null) {
            msg = String.valueOf(msg) + "<tr><td valign=top>";
            if (img2 != null) {
                msg = String.valueOf(msg) + "<img src='./images/" + img2 + "'>";
            }
            msg = String.valueOf(msg) + "</td><td>" + txt2 + "</td></tr>";
        }
        msg = String.valueOf(msg) + "</table>";
        return msg;
    }

    public String genMessage(String img1, String txt1) {
        return this.genMessage(img1, txt1, null, null);
    }
}

