/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import mauda.feedback.FeedbackKBObject;
import mauda.plugin.KBFormulaEvaluator;

public class FeedbackKB {
    private Vector kbObjects = new Vector();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(String filename) {
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        this.kbObjects = new Vector();
        Vector<String> formulas = new Vector<String>();
        Vector<String> messages = new Vector<String>();
        try {
            while (br.ready()) {
                String line = br.readLine();
                formulas.removeAllElements();
                messages.removeAllElements();
                if (!line.startsWith("FORMULA: ")) continue;
                while (line.startsWith("FORMULA: ")) {
                    String formula = line.substring(9);
                    formulas.add(formula);
                    line = br.readLine();
                    if (br.ready()) continue;
                }
                while (line.startsWith("MESSAGE: ")) {
                    String message = line.substring(9);
                    messages.add(message);
                    line = br.readLine();
                    if (br.ready()) continue;
                }
                if (messages.size() == 0) {
                    System.err.println("Error in KB. Loading of KB canceled!");
                    System.err.println("1. Formula: " + formulas.elementAt(0));
                    return false;
                }
                Enumeration en = formulas.elements();
                while (en.hasMoreElements()) {
                    String formula = (String)en.nextElement();
                    FeedbackKBObject fkbo = new FeedbackKBObject();
                    fkbo.setFormula(formula);
                    fkbo.setMessages((Vector)messages.clone());
                    this.kbObjects.add(fkbo);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            br.close();
            return true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Vector call(KBFormulaEvaluator evaluator) {
        if (this.kbObjects.size() == 0) {
            return null;
        }
        Vector<FeedbackKBObject> v = new Vector<FeedbackKBObject>();
        Enumeration en = this.kbObjects.elements();
        while (en.hasMoreElements()) {
            FeedbackKBObject fkbo = (FeedbackKBObject)en.nextElement();
            boolean result = evaluator.evaluate(fkbo.getFormula());
            if (!result) continue;
            v.add(fkbo);
        }
        return v;
    }
}

