/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.Failure;
import mauda.MAUDA;
import mauda.MetaData;
import mauda.OperationRecorder;
import mauda.feedback.Evaluator;
import mauda.feedback.FaultEvaluator;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackGenerator;
import mauda.feedback.FeedbackObject;
import mauda.feedback.FeedbackPanel;
import mauda.feedback.NormalEvaluator;
import mauda.feedback.types.FaultFeedback;
import mauda.feedback.types.ImmediateFeedbackAndErrorCorrection;
import mauda.feedback.types.NoTutor;
import mauda.feedback.types.SolutionFeedback;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.plugin.KBFormulaEvaluator;
import mauda.undoredo.UndoRedoInfo;
import mauda.utils.FileLocation;

public abstract class SimpleFeedback
implements ExerciseUpdateListener {
    protected FeedbackExercise exercise;
    protected Evaluator evaluator;
    public static FeedbackGenerator feedbackGenerator;
    protected boolean finishedLoading;
    protected boolean finishedExercise;
    protected boolean configurated;
    protected FeedbackObject currentFeedbackObject;
    protected OperationQueue todoOperationQueue;
    protected OperationQueue initOperationQueue;
    protected String specialState;
    protected int feedbackBound;
    public static final int MAX_TRIES = 3;
    protected int todoPosition;
    protected int maxTodoPosition;
    protected int counter;
    protected Vector firstFailureFeedbackObjects;
    protected Vector FFFOVector;
    private UndoRedoInfo undoRedoInfo;
    private UndoRedoInfo undoRedoInfoFFFO;
    protected Vector feedbackObjects;
    protected boolean differentOperation;

    public SimpleFeedback(FeedbackExercise exercise) {
        this.exercise = exercise;
        exercise.getFeedbackPanel().disableAllButtons();
        exercise.getFeedbackPanel().hideDemandButton();
        if (this instanceof FaultFeedback) {
            this.setEvaluator(new FaultEvaluator());
        } else {
            this.setEvaluator(new NormalEvaluator());
        }
        this.finishedLoading = false;
        this.finishedExercise = false;
        this.feedbackBound = -1;
        this.counter = -1;
        this.todoPosition = -1;
        this.maxTodoPosition = -1;
        this.configurated = true;
        this.undoRedoInfo = new UndoRedoInfo();
        this.undoRedoInfoFFFO = new UndoRedoInfo();
        this.currentFeedbackObject = null;
        this.firstFailureFeedbackObjects = new Vector();
        this.feedbackObjects = new Vector();
        this.FFFOVector = new Vector();
        this.todoOperationQueue = null;
        this.initOperationQueue = null;
    }

    public FeedbackGenerator getFeedbackGenerator() {
        return feedbackGenerator;
    }

    public void setEvaluator(Evaluator e) {
        this.evaluator = e;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void displayLoadingMessage() {
        this.displayMessage("FEEDBACK", "");
        this.displayMessage("TASK", "<b>Loading Exercise.</b><br><br>Please wait ...");
    }

    protected void displayMessage(String view, String html) {
        this.displayMessage(view, html, true);
    }

    protected void displayMessage(String view, String html, boolean gotoView) {
        FeedbackPanel fbp = this.exercise.getFeedbackPanel();
        if (view.equals("TASK")) {
            if (gotoView) {
                fbp.getTabbedPane().setSelectedIndex(0);
            }
            fbp.getTaskView().setBodyHTML(html);
        } else if (view.equals("FEEDBACK")) {
            if (gotoView) {
                fbp.getTabbedPane().setSelectedIndex(1);
            }
            fbp.getFeedbackView().setBodyHTML(html);
        }
    }

    protected void setBackButtonText(String t) {
        this.exercise.getFeedbackPanel().backButton.setText(t);
    }

    protected void setBackEnabled(boolean b) {
        this.exercise.getFeedbackPanel().backButton.setEnabled(b);
    }

    protected void setForwardButtonText(String t) {
        this.exercise.getFeedbackPanel().forwardButton.setText(t);
    }

    protected void setForwardEnabled(boolean b) {
        this.exercise.getFeedbackPanel().forwardButton.setEnabled(b);
    }

    protected void setSpecialButtonText(String t) {
        this.exercise.getFeedbackPanel().specialButton.setText(t);
    }

    protected void setSpecialEnabled(boolean b) {
        this.exercise.getFeedbackPanel().specialButton.setEnabled(b);
    }

    protected void setDemandButtonText(String t) {
        this.exercise.getFeedbackPanel().demandButton.setText(t);
    }

    protected void setDemandEnabled(boolean b) {
        this.exercise.getFeedbackPanel().demandButton.setEnabled(b);
    }

    protected void setGiveUpEnabled(boolean b) {
        this.exercise.getFeedbackPanel().giveUpButton.setEnabled(b);
    }

    protected void giveUpPressed() {
        OperationQueue outstanding = null;
        boolean fault = this instanceof FaultFeedback;
        String msg = "Really give up?";
        if (!fault) {
            msg = String.valueOf(msg) + "\n\n";
            outstanding = new OperationQueue();
            msg = String.valueOf(msg) + "Outstanding operations:\n";
            int i = this.todoPosition + 1;
            while (i < this.todoOperationQueue.length()) {
                Operation op = this.todoOperationQueue.get(i);
                outstanding.add((Operation)op.clone());
                msg = String.valueOf(msg) + " - " + op.out() + "\n";
                ++i;
            }
        } else {
            msg = String.valueOf(msg) + "\n\n";
            msg = String.valueOf(msg) + "This will result in zero points!!!";
        }
        int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), msg, "Give up...", 2);
        if (result == 2) {
            return;
        }
        if (!fault) {
            this.exercise.getFeedbackPanel().disableAllButtons();
            Vector v = outstanding.toVector();
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, -1);
            eue.setMessage("GIVE-UP-PRESSED");
            v.add(eue);
            this.exercise.commit(v);
        } else {
            ((FaultEvaluator)this.evaluator).setState(6);
            this.finishedExercise();
        }
    }

    protected void jumpEvent(int delta) {
        OperationRecorder or = this.exercise.getOperationRecorder();
        int firstOpOffset = or.getOffset(0, -1);
        this.counter += delta;
        int opCounter = -1;
        int c = 0;
        while (c <= this.counter) {
            if (or.getEntry(c + firstOpOffset) instanceof Operation) {
                ++opCounter;
            }
            ++c;
        }
        this.todoPosition = opCounter;
    }

    protected abstract void backPressed();

    protected abstract void forwardPressed();

    protected abstract void specialPressed();

    protected abstract void demandPressed();

    protected abstract void interactiveEvent();

    protected void doInteractiveEvent() {
        this.preInteractiveEvent();
        this.interactiveEvent();
        this.postInteractiveEvent();
    }

    private void preInteractiveEvent() {
        ++this.counter;
        this.differentOperation = true;
        if (this.feedbackObjects.size() > this.counter) {
            FeedbackObject fo = (FeedbackObject)this.feedbackObjects.elementAt(this.counter);
            Object o = this.exercise.getOperationRecorder().getCurrentOperation();
            SimpleOperation so = null;
            if (o instanceof Operation) {
                so = fo.getOperation();
            } else if (o instanceof SubOperation) {
                so = fo.getSubOperation();
            }
            if (so != null && !so.equals(o)) {
                this.undoRedoInfo.storeChange(this.counter, this.feedbackObjects, this.callKB());
            } else if (so == null && o != null) {
                this.undoRedoInfo.storeChange(this.counter, this.feedbackObjects, this.callKB());
            } else {
                this.differentOperation = false;
            }
        } else {
            this.undoRedoInfo.storeChange(this.counter, this.feedbackObjects, this.callKB());
        }
    }

    private void postInteractiveEvent() {
        if (this instanceof SolutionFeedback) {
            return;
        }
        if (this.differentOperation) {
            this.undoRedoInfoFFFO.storeChange(this.counter, this.FFFOVector, this.deepCopyFFFO());
        }
        this.differentOperation = true;
    }

    protected Vector deepCopyFFFO() {
        Vector<Object> v = new Vector<Object>();
        Enumeration en = this.firstFailureFeedbackObjects.elements();
        while (en.hasMoreElements()) {
            FeedbackObject fo = (FeedbackObject)en.nextElement();
            if (fo != null) {
                v.add(fo.clone());
                continue;
            }
            v.add(null);
        }
        return v;
    }

    protected void forwardEvent() {
    }

    protected void backEvent() {
    }

    protected void linkClicked(String href) {
        if (href.equals("nextMessage")) {
            this.displayMessage("FEEDBACK", this.currentFeedbackObject.getNextMessage());
        } else if (href.equals("prevMessage")) {
            this.displayMessage("FEEDBACK", this.currentFeedbackObject.getPrevMessage());
        } else if (href.equals("showcorrectsolution")) {
            this.displayMessage("FEEDBACK", "Loading solution");
            this.loadCorrectSolution();
        }
    }

    private void loadCorrectSolution() {
        ExerciseUpdateEvent eue;
        SolutionFeedback fb = new SolutionFeedback(this.exercise);
        this.exercise.setFeedback(fb);
        this.switchTo(fb, false);
        OperationRecorder or = this.exercise.getOperationRecorder();
        int delta = or.getOffset(0, -1) - or.getCurrentOffset();
        Vector<Object> cv = new Vector<Object>();
        int offsetEUE = 0;
        if (--delta != 0) {
            eue = new ExerciseUpdateEvent(this.exercise, 12);
            eue.setValue(delta);
            cv.add(eue);
            offsetEUE = -1;
        }
        Vector tv = this.todoOperationQueue.toVector();
        Enumeration en = tv.elements();
        while (en.hasMoreElements()) {
            Operation op = (Operation)en.nextElement();
            cv.add((Operation)op.clone());
            cv.addAll(((SubOperationQueue)op.getSubOperationQueue().clone()).toVector());
        }
        delta = cv.size() + offsetEUE;
        eue = new ExerciseUpdateEvent(this.exercise, 12);
        eue.setValue(-delta);
        cv.add(eue);
        eue = new ExerciseUpdateEvent(this.exercise, -1);
        eue.setMessage("CorrectSolutionLoaded");
        cv.add(eue);
        this.exercise.jedasPanel.nextNoProgressBar();
        this.exercise.commit(cv);
    }

    protected void finishedLoading() {
        this.finishedLoading = true;
        this.exercise.setInteractiveMode(3);
        this.exercise.getFeedbackPanel().giveUpButton.setEnabled(true);
    }

    protected String getFeedbackDescription() {
        return "ERROR: Unknown Feedback.";
    }

    protected String genOpToPerformMessage() {
        String msg = "<b>Exercise ready.</b>";
        msg = String.valueOf(msg) + feedbackGenerator.genMessage("explanation.gif", "You have to perform the following operations correctly.");
        msg = String.valueOf(msg) + this.genOpList(-1);
        return msg;
    }

    protected String genOpToPerformFalseMessage() {
        String msg = "<b>Exercise ready.</b>";
        msg = String.valueOf(msg) + feedbackGenerator.genMessage("explanation.gif", "You have to find the <i>first</i> error in the following operations.");
        msg = String.valueOf(msg) + this.genOpList(-1);
        return msg;
    }

    protected String genOpList(int todoPosition) {
        if (todoPosition > this.maxTodoPosition) {
            this.maxTodoPosition = todoPosition;
        }
        String msg = "<ol>";
        String state = "";
        int counter = 1;
        int i = 0;
        while (i < this.todoOperationQueue.length()) {
            FeedbackObject fo;
            String error = "";
            if (!(this instanceof NoTutor) && i < this.firstFailureFeedbackObjects.size() && (fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(i)) != null) {
                error = " but with errors";
            }
            if (todoPosition >= 0) {
                state = i < todoPosition ? " (done" + error + ")" : (i == todoPosition ? " (in process)" : (i <= this.maxTodoPosition ? " (commenced)" : " (todo)"));
            }
            msg = String.valueOf(msg) + "<li><b>" + this.todoOperationQueue.get(i).out() + "</b>" + state + "</li>";
            ++counter;
            ++i;
        }
        msg = String.valueOf(msg) + "</ol>";
        return msg;
    }

    protected void updateTaskMessage() {
        String msg = "<b>Exercise state</b>";
        msg = String.valueOf(msg) + feedbackGenerator.genMessage("information.gif", "This is your actual exercise state:");
        msg = String.valueOf(msg) + this.genOpList(this.todoPosition);
        msg = String.valueOf(msg) + "<br>";
        msg = String.valueOf(msg) + this.getFeedbackDescription();
        this.displayMessage("TASK", msg, false);
    }

    public void exerciseUpdate(ExerciseUpdateEvent e) {
        if (e.getID() == 4) {
            this.finishedLoading();
        }
        if (!this.finishedLoading) {
            return;
        }
        if (e.getID() == 0) {
            this.doInteractiveEvent();
        } else if (e.getID() == 8) {
            this.forwardEvent();
        } else if (e.getID() == 7) {
            this.backEvent();
        } else if (e.getID() == 18) {
            this.undoRedoInfo.undo(this.feedbackObjects);
            this.undoRedoInfoFFFO.undo(this.FFFOVector);
            if (this.FFFOVector.size() > 0) {
                this.firstFailureFeedbackObjects = (Vector)this.FFFOVector.lastElement();
                this.firstFailureFeedbackObjects = this.deepCopyFFFO();
            } else {
                this.firstFailureFeedbackObjects = new Vector();
            }
        } else if (e.getID() == 19) {
            this.undoRedoInfo.redo(this.feedbackObjects);
            this.undoRedoInfoFFFO.redo(this.FFFOVector);
            if (this.FFFOVector.size() > 0) {
                this.firstFailureFeedbackObjects = (Vector)this.FFFOVector.lastElement();
                this.firstFailureFeedbackObjects = this.deepCopyFFFO();
            } else {
                this.firstFailureFeedbackObjects = new Vector();
            }
        } else if (e.getID() == 12) {
            this.jumpEvent(e.getValue());
        } else if (e.getID() == -1) {
            if (e.getMessage().equals("CorrectSolutionLoaded")) {
                this.exercise.getTreeOperationView().markCorrectness(false, true);
                this.exercise.getTreeOperationView().enableJumping();
                this.exercise.getTreeOperationView().enableStop();
                String msg = "<b>Correct solution loaded...</b><br>";
                msg = String.valueOf(msg) + feedbackGenerator.genMessage("explanation.gif", "Now you can navigate through the correct solution.");
                this.displayMessage("FEEDBACK", msg);
                this.exercise.setModified(false);
            } else if (e.getMessage().equals("GIVE-UP-PRESSED")) {
                this.finishedExercise();
            }
        }
    }

    protected String makeNextLink(String msg) {
        if (this.counter > this.feedbackBound) {
            return msg;
        }
        Object actop = this.exercise.getOperationRecorder().getCurrentOperation();
        return this.makeNextLink(msg, actop);
    }

    protected String makeNextLink(String msg, Object actop) {
        if (this.counter > this.feedbackBound) {
            return msg;
        }
        if (actop instanceof SubOperation) {
            msg = String.valueOf(msg) + "<br>To get information for <i>" + ((SubOperation)actop).out() + "</i> ";
            msg = String.valueOf(msg) + "click <a href='nextMessage'>here.</a>";
        }
        return msg;
    }

    protected void setFeedbackBound() {
        this.feedbackBound = this.counter;
    }

    protected void updateBackForwardButtons() {
        FeedbackPanel fbp = this.exercise.getFeedbackPanel();
        fbp.backButton.setEnabled(this.exercise.getUndoRedo().canBack() && this.counter >= 0);
        fbp.forwardButton.setEnabled(this.exercise.getUndoRedo().canForward());
    }

    public void setTodoOperationQueue(OperationQueue oq) {
        this.todoOperationQueue = (OperationQueue)oq.clone();
    }

    public OperationQueue getTodoOperationQueue() {
        return this.todoOperationQueue;
    }

    public void setInitOperationQueue(OperationQueue oq) {
        this.initOperationQueue = (OperationQueue)oq.clone();
    }

    public OperationQueue getInitOperationQueue() {
        return this.initOperationQueue;
    }

    protected FeedbackObject callKB() {
        FeedbackObject fo;
        this.currentFeedbackObject = fo = feedbackGenerator.getFeedback();
        if (fo != null) {
            return fo;
        }
        fo = new FeedbackObject();
        fo.setCorrectness(0);
        Vector<String> messages = new Vector<String>();
        messages.add("Error in FeedbackGenerator: no feedback available");
        fo.setMessages(messages);
        return fo;
    }

    private void setFailureFeedbackObject(FeedbackObject fo) {
        if (this.firstFailureFeedbackObjects.size() <= this.todoPosition) {
            this.firstFailureFeedbackObjects.add(fo);
        } else {
            this.firstFailureFeedbackObjects.setElementAt(fo, this.todoPosition);
        }
    }

    protected void cutFirstFailureFeedbackObjects() {
        int cutIndex = this.todoPosition + 1;
        OperationRecorder or = this.exercise.getOperationRecorder();
        Failure f = or.getLimitedFailure(or.getOffset(this.todoPosition, -1));
        if (f == null || f.getOffset() > or.getCurrentOffset()) {
            --cutIndex;
        }
        while (this.firstFailureFeedbackObjects.size() > cutIndex) {
            this.firstFailureFeedbackObjects.removeElementAt(cutIndex);
        }
    }

    protected void checkForFailure() {
        OperationRecorder or = this.exercise.getOperationRecorder();
        Failure f = or.getLimitedFailure(or.getOffset(this.todoPosition, -1));
        if (f == null || f.getOffset() > or.getCurrentOffset() + 1) {
            this.setFailureFeedbackObject(null);
            return;
        }
        FeedbackObject fo = null;
        if (f.getOffset() == or.getCurrentOffset()) {
            fo = this.callKB();
            this.setFailureFeedbackObject(fo);
            this.evaluator.log(this.currentFeedbackObject);
        } else if (f.getDescription() == 1 && f.getOffset() == or.getCurrentOffset() + 1) {
            KBFormulaEvaluator kbfe = feedbackGenerator.getKBFormulaEvaluator();
            kbfe.setFinishOperationState(true);
            fo = this.callKB();
            kbfe.setFinishOperationState(false);
            this.setFailureFeedbackObject(fo);
        } else {
            if (this.firstFailureFeedbackObjects.size() > this.todoPosition) {
                fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(this.todoPosition);
            }
            if (fo == null) {
                fo = this.callKB();
                if (fo.getCorrectness() == 2 || fo.getCorrectness() == 3) {
                    this.setFailureFeedbackObject(fo);
                } else {
                    this.setFailureFeedbackObject(null);
                }
            }
        }
    }

    public boolean exerciseFinished() {
        return this.finishedExercise;
    }

    protected void finishedExercise() {
        int result;
        this.finishedExercise = true;
        boolean tutorEvaluation = false;
        if (!(this instanceof FaultFeedback) && (result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), "Do you want a tutoriel evaluation!", "Question", 0)) == 0) {
            tutorEvaluation = true;
        }
        if (!tutorEvaluation) {
            this.exercise.getTreeOperationView().markCorrectness(false, true);
        }
        this.evaluator.evaluate(this.exercise.getOperationRecorder());
        this.exercise.setInteractiveMode(3);
        this.exercise.getTreeOperationView().disableJumping();
        FeedbackPanel fbp = this.exercise.getFeedbackPanel();
        fbp.backButton.setEnabled(false);
        fbp.forwardButton.setEnabled(false);
        fbp.specialButton.setEnabled(false);
        fbp.demandButton.setEnabled(false);
        fbp.giveUpButton.setEnabled(false);
        String msg = feedbackGenerator.genMessage("correct_v.gif", "<b>Congratulations</b>", null, "Exercise finished!");
        msg = !tutorEvaluation ? String.valueOf(msg) + "<br>" + this.evaluator.getHTMLMessage() : String.valueOf(msg) + "<br>The exercise will be evaluated by a tutor. When the tutor has processed the exercise, you can view it with the EvalPlayer.";
        if (!(this instanceof FaultFeedback)) {
            msg = String.valueOf(msg) + "<br><a href='showcorrectsolution'>Show correct solution</a>";
        }
        this.displayMessage("FEEDBACK", msg);
        ++this.todoPosition;
        this.updateTaskMessage();
        this.saveFile(tutorEvaluation);
    }

    private void saveFile(boolean tutorEvaluation) {
        String filename = null;
        MetaData md = this.exercise.getMetaData();
        md.actualizeEditorDate();
        md.setEditorState("completed");
        if (tutorEvaluation) {
            md.setEvaluatorState("not evaluated");
            filename = FileLocation.genFilename(FileLocation.completedPath, FileLocation.completedPrefix);
        } else {
            md.setEvaluatorName("AutoEvaluator");
            md.actualizeEvaluatorDate();
            md.setEvaluatorState("evaluated");
            md.setEvaluatorScore(this.evaluator.getScoreString());
            filename = FileLocation.genFilename(FileLocation.evaluatedPath, FileLocation.evaluatedPrefix);
        }
        md.inputDialog();
        this.exercise.saveWork(filename);
    }

    public int getFeedbackTypeID() {
        return -1;
    }

    public HashMap save() {
        HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
        hm.put("evaluator", this.evaluator.save());
        hm.put("counter", new Integer(this.counter));
        hm.put("feedbackBound", new Integer(this.feedbackBound));
        return hm;
    }

    public void load(HashMap hm) {
        this.exercise.getTreeOperationView().enableJumping();
        this.evaluator.load((HashMap)hm.get("evaluator"));
        int newCounter = (Integer)hm.get("counter");
        this.feedbackBound = (Integer)hm.get("feedbackBound");
        if (newCounter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            int delta = newCounter - this.counter;
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 12);
            eue.setValue(delta);
            Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
            v.add(eue);
            this.exercise.commit(v);
        }
        this.configurated = true;
    }

    public void switchTo(SimpleFeedback newFeedback, boolean update) {
        newFeedback.setEvaluator(this.getEvaluator());
        newFeedback.finishedLoading = this.finishedLoading;
        if (!(newFeedback instanceof ImmediateFeedbackAndErrorCorrection)) {
            newFeedback.feedbackBound = this.feedbackBound;
        }
        newFeedback.counter = this.counter;
        newFeedback.todoPosition = this.todoPosition;
        newFeedback.maxTodoPosition = this.maxTodoPosition;
        newFeedback.configurated = this.configurated;
        newFeedback.feedbackObjects = this.feedbackObjects;
        newFeedback.firstFailureFeedbackObjects = this.firstFailureFeedbackObjects;
        newFeedback.undoRedoInfo = this.undoRedoInfo;
        newFeedback.undoRedoInfoFFFO = this.undoRedoInfoFFFO;
        newFeedback.FFFOVector = this.FFFOVector;
        newFeedback.initOperationQueue = this.initOperationQueue;
        newFeedback.todoOperationQueue = this.todoOperationQueue;
        this.exercise.removeExerciseUpdateListener(this);
        this.exercise.addExerciseUpdateListener(newFeedback);
        if (this.counter >= 0) {
            switch (newFeedback.getFeedbackTypeID()) {
                case 0: {
                    this.exercise.getTreeOperationView().markCorrectness(false, false);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.setDemandEnabled(true);
                    break;
                }
            }
            newFeedback.updateTaskMessage();
            if (!(newFeedback instanceof SolutionFeedback)) {
                this.exercise.getFeedbackPanel().giveUpButton.setEnabled(true);
            }
            if (update) {
                ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 12);
                eue.setValue(0);
                Vector<ExerciseUpdateEvent> v = new Vector<ExerciseUpdateEvent>();
                v.add(eue);
                this.exercise.commit(v);
            }
        } else {
            newFeedback.finishedLoading();
        }
        this.updateBackForwardButtons();
    }
}

