/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;

public class DemandFeedback
extends SimpleFeedback
implements ActionListener {
    private static final int type = 2;
    private static final String specialGetNext = "Get next ...";
    private static final String specialFinishEx = "Finish ...";
    protected static final String requestFeedback = "Request ...";
    public static final String requestMenuItem = "Request Feedback";

    public DemandFeedback(FeedbackExercise exercise) {
        super(exercise);
        this.specialState = specialGetNext;
        exercise.getFeedbackPanel().showDemandButton();
        this.setDemandButtonText(requestFeedback);
        this.setDemandEnabled(false);
    }

    protected void jumpEvent(int delta) {
        super.jumpEvent(delta);
        this.updateBackForwardButtons();
        String msg = "";
        if (this.counter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
            msg = feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + so.out());
            this.exercise.setInteractiveMode(1);
        } else {
            msg = feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
            this.exercise.setInteractiveMode(3);
        }
        this.displayMessage("FEEDBACK", msg);
        if (this.todoPosition == this.todoOperationQueue.length() - 1) {
            this.setSpecialButtonText(specialFinishEx);
            this.specialState = specialFinishEx;
        } else {
            this.setSpecialButtonText(specialGetNext);
            this.specialState = specialGetNext;
        }
        this.updateTaskMessage();
    }

    protected void specialPressed() {
        String msg = null;
        if (this.specialState == specialGetNext) {
            if (this.todoPosition >= 0) {
                this.checkForFailure();
                FeedbackObject fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(this.todoPosition);
                if (fo != null && fo.getCorrectness() == 3) {
                    this.evaluator.log(this.currentFeedbackObject);
                }
            }
            this.exercise.getTreeOperationView().enableJumping();
            Operation op = (Operation)this.todoOperationQueue.get(this.todoPosition + 1).clone();
            op.setExecution(false);
            msg = feedbackGenerator.genMessage("explanation.gif", "Perform the SubOperations for:");
            msg = String.valueOf(msg) + "<ul><li><b>" + op.out() + "</b></li></ul>" + "by pressing the right mouse button in the drawing-area, and selecting the correct suboperation." + "<br><br>";
            if (this.todoPosition + 1 == this.todoOperationQueue.length() - 1) {
                msg = String.valueOf(msg) + "When you have finished all suboperations, please click the <b><i>Finish ...</i></b> button to complete the exercise.";
                this.setSpecialButtonText(specialFinishEx);
                this.specialState = specialFinishEx;
            } else {
                msg = String.valueOf(msg) + "When you have finished all suboperations, please click the <b><i>Get next ...</i></b> button.";
                this.setSpecialButtonText(specialGetNext);
            }
            this.displayMessage("FEEDBACK", msg);
            this.exercise.commit(op);
            this.exercise.setInteractiveMode(1);
            return;
        }
        if (this.specialState == specialFinishEx) {
            if (this.todoPosition >= 0) {
                this.checkForFailure();
                FeedbackObject fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(this.todoPosition);
                if (fo != null && fo.getCorrectness() == 3) {
                    this.evaluator.log(this.currentFeedbackObject);
                }
            }
            this.finishedExercise();
            return;
        }
    }

    protected void forwardPressed() {
        this.exercise.forward();
    }

    protected void backPressed() {
        this.exercise.back();
    }

    protected void forwardEvent() {
        ++this.counter;
        super.forwardEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            if (this.todoPosition == this.todoOperationQueue.length() - 1) {
                this.setSpecialButtonText(specialFinishEx);
                this.specialState = specialFinishEx;
            }
        }
        String msg = feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
    }

    protected void backEvent() {
        --this.counter;
        super.backEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getNextOperation();
        if (o instanceof Operation) {
            --this.todoPosition;
            if (this.todoPosition < this.todoOperationQueue.length() - 1) {
                this.setSpecialButtonText(specialGetNext);
                this.specialState = specialGetNext;
            }
        }
        String msg = feedbackGenerator.genMessage("information.gif", "<b>Back</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
    }

    protected void interactiveEvent() {
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            this.updateTaskMessage();
            this.updateBackForwardButtons();
            return;
        }
        this.updateBackForwardButtons();
        String msg = feedbackGenerator.genMessage("information.gif", "<b>Execute</b> " + ((SimpleOperation)o).out());
        this.displayMessage("FEEDBACK", msg);
        if (this.differentOperation) {
            this.cutFirstFailureFeedbackObjects();
            this.checkForFailure();
        }
    }

    protected void finishedLoading() {
        super.finishedLoading();
        String msg = this.genOpToPerformMessage();
        msg = String.valueOf(msg) + this.getFeedbackDescription();
        msg = String.valueOf(msg) + "<br>";
        msg = String.valueOf(msg) + "To perform the first operation, please click the <b><i>'Get next ...'</i></b> button below.";
        this.displayMessage("TASK", msg);
        this.setSpecialButtonText(specialGetNext);
        this.setSpecialEnabled(true);
        this.setDemandEnabled(true);
    }

    protected String getFeedbackDescription() {
        return "You will get feedback only on demand.";
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
    }

    protected void demandPressed() {
        if (this.counter < 0) {
            return;
        }
        this.exercise.getTreeOperationView().markCorrectness(true, true);
        OperationRecorder or = this.exercise.getOperationRecorder();
        SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
        this.requestFeedback(this.counter);
    }

    private void requestFeedbackOnOperation(int opnr) {
        String msgadd = null;
        FeedbackObject fo = null;
        if (this.firstFailureFeedbackObjects.size() > opnr) {
            fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(opnr);
        }
        if (fo != null) {
            fo.setMessagePosition(-1);
            this.currentFeedbackObject = fo;
            if (this.checkBefore(opnr)) {
                msgadd = "There are errors in previous operations!";
            }
        } else {
            if (opnr == 0) {
                Operation op = this.todoOperationQueue.get(opnr);
                if (this.counter <= 0) {
                    String msg = feedbackGenerator.genMessage("information.gif", "Start of exercise");
                    this.displayMessage("FEEDBACK", msg);
                } else {
                    String msg = feedbackGenerator.genMessage("correct_v.gif", "<b>Correct</b>", null, "No Failure in <i>" + op.out() + "</i>");
                    this.displayMessage("FEEDBACK", msg);
                }
                return;
            }
            fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(opnr - 1);
            if (fo != null) {
                fo.setMessagePosition(-1);
                this.currentFeedbackObject = fo;
                if (this.checkBefore(opnr - 1)) {
                    msgadd = "There are errors in previous operations!";
                }
            } else {
                Operation op = this.todoOperationQueue.get(opnr - 1);
                String msg = feedbackGenerator.genMessage("correct_v.gif", "<b>Correct</b>", null, "No Failure in <i>" + op.out() + "</i>");
                if (this.checkBefore(opnr - 1)) {
                    msg = String.valueOf(msg) + "<br>But there are errors in previous operations!";
                }
                this.displayMessage("FEEDBACK", msg);
                return;
            }
        }
        this.currentFeedbackObject.setLocationShow(true);
        String msg = this.currentFeedbackObject.getNextMessage();
        if (msgadd != null) {
            msg = String.valueOf(msg) + "<br>" + msgadd;
        }
        this.displayMessage("FEEDBACK", msg);
    }

    private boolean checkBefore(int opnr) {
        int i = 0;
        while (i < opnr) {
            FeedbackObject fo = (FeedbackObject)this.firstFailureFeedbackObjects.elementAt(i);
            if (fo != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == requestMenuItem) {
            if (this.finishedExercise) {
                return;
            }
            int index = this.exercise.getTreeOperationView().getActionIndex();
            this.requestFeedback(index);
        }
    }

    protected void requestFeedback(int index) {
        if (index < 0 || index >= this.feedbackObjects.size()) {
            return;
        }
        this.exercise.getTreeOperationView().markCorrectness(false, true);
        FeedbackObject fo = (FeedbackObject)this.feedbackObjects.elementAt(index);
        if (fo.getSubOpNr() < 0) {
            this.requestFeedbackOnOperation(fo.getOpNr());
            return;
        }
        String msgadd = null;
        if (this.checkBefore(fo.getOpNr())) {
            msgadd = "There are errors in previous operations!";
        }
        fo.setMessagePosition(-1);
        this.currentFeedbackObject = fo;
        String msg = fo.getNextMessage();
        if (msgadd != null) {
            msg = String.valueOf(msg) + "<br>" + msgadd;
        }
        this.displayMessage("FEEDBACK", msg);
    }

    public int getFeedbackTypeID() {
        return 2;
    }

    public HashMap save() {
        HashMap hm = super.save();
        return hm;
    }

    public void load(HashMap hm) {
        super.load(hm);
    }
}

