/*
 * Decompiled with CFR 0.152.
 */
package mauda.feedback.types;

import mauda.OperationRecorder;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;

public class SolutionFeedback
extends SimpleFeedback {
    private static final int type = -1;
    private static final String specialGetNext = "Get next ...";
    private static final String specialFinishOp = "Finish Operation ...";
    private static final String specialFinishEx = "Finish exercise ...";
    private static final String specialPerform = "Perform correct Operation...";

    public SolutionFeedback(FeedbackExercise exercise) {
        super(exercise);
        this.feedbackBound = Integer.MAX_VALUE;
        exercise.setInteractiveMode(3);
        this.setDemandEnabled(false);
        this.finishedLoading = true;
        this.finishedExercise = true;
    }

    protected void jumpEvent(int delta) {
        super.jumpEvent(delta);
        if (this.counter >= 0) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
            String msg = feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to " + so.out());
            if (so instanceof SubOperation) {
                FeedbackObject fo = this.callKB();
                this.displayMessage("FEEDBACK", fo.getNextMessage());
            } else if (so instanceof Operation) {
                this.displayMessage("FEEDBACK", msg);
                --this.todoPosition;
                --this.counter;
                this.doInteractiveEvent();
            }
        } else {
            String msg = feedbackGenerator.genMessage("information.gif", "<b>Jump</b> to beginning");
            this.displayMessage("FEEDBACK", msg);
        }
        this.updateBackForwardButtons();
    }

    protected void specialPressed() {
    }

    protected void demandPressed() {
    }

    protected void forwardPressed() {
        this.exercise.forward();
    }

    protected void backPressed() {
        this.exercise.back();
    }

    protected void forwardEvent() {
        ++this.counter;
        super.forwardEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getCurrentOperation();
        if (o instanceof Operation) {
            ++this.todoPosition;
            String msg = feedbackGenerator.genMessage("information.gif", "<b>Forward</b> " + ((Operation)o).out());
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
        } else if (o instanceof SubOperation) {
            String msg = fo.getNextMessage();
            this.displayMessage("FEEDBACK", msg);
        }
    }

    protected void backEvent() {
        --this.counter;
        super.backEvent();
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        Object o = this.exercise.getOperationRecorder().getNextOperation();
        if (o instanceof Operation) {
            --this.todoPosition;
            String msg = feedbackGenerator.genMessage("information.gif", "<b>Back</b> " + ((Operation)o).out());
            msg = this.makeNextLink(msg);
            this.displayMessage("FEEDBACK", msg);
        } else if (o instanceof SubOperation) {
            String msg = fo.getNextMessage();
            this.displayMessage("FEEDBACK", msg);
        }
    }

    protected void interactiveEvent() {
        FeedbackObject temp;
        OperationRecorder or = this.exercise.getOperationRecorder();
        SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
        if (so instanceof Operation) {
            ++this.todoPosition;
            this.updateBackForwardButtons();
            return;
        }
        this.updateBackForwardButtons();
        FeedbackObject fo = this.callKB();
        String msg = fo.getNextMessage();
        this.displayMessage("FEEDBACK", msg);
        this.currentFeedbackObject = temp = this.currentFeedbackObject;
    }

    protected void finishedLoading() {
        super.finishedLoading();
    }

    protected String getFeedbackDescription() {
        return "You will get an immediate feedback at any point in this correct solution.";
    }

    protected void linkClicked(String href) {
        super.linkClicked(href);
    }

    public int getFeedbackTypeID() {
        return -1;
    }
}

